/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins;

import com.sk89q.worldguard.protection.flags.StateFlag;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.Plugins.FlagResult;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.Plugins.Flags;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.WorldGuardFlagsManager;
import dev.lone.itemsadder.api.Events.CustomBlockInteractEvent;
import ia.m.R;
import ia.m.eM;
import ia.m.rt;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtectionPlugins {
    public static boolean registered;
    static boolean hasWorldGuard;

    public static void register(Plugin plugin) {
        if (registered) {
            return;
        }
        registered = true;
        try {
            Class.forName("com.sk89q.worldguard.WorldGuard");
            hasWorldGuard = true;
            WorldGuardFlagsManager.registerFlags();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean canSitOnFurniture(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        return ProtectionPlugins.canSitOnFurniture(playerInteractAtEntityEvent.getPlayer(), playerInteractAtEntityEvent.getRightClicked(), (Cancellable)playerInteractAtEntityEvent);
    }

    public static boolean canSitOnFurniture(Player player, Entity entity, Cancellable cancellable) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(Flags.FURNITURE_SIT, player, entity);
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION && cancellable.isCancelled()) {
                return false;
            }
        }
        return !cancellable.isCancelled();
    }

    public static boolean canMoveItemToCampfire(PlayerInteractEvent playerInteractEvent) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testBlockFlag(Flags.MOVE_ITEM_TO_CAMPFIRE, playerInteractEvent.getPlayer(), playerInteractEvent.getClickedBlock());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return true;
            }
        }
        return true;
    }

    public static boolean canRemoveItemToCampfire(PlayerInteractEvent playerInteractEvent) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testBlockFlag(Flags.REMOVE_ITEM_FROM_CAMPFIRE, playerInteractEvent.getPlayer(), playerInteractEvent.getClickedBlock());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return true;
            }
        }
        return true;
    }

    public static boolean canSitOnVehicle(PlayerInteractAtEntityEvent playerInteractAtEntityEvent, ItemStack itemStack) {
        boolean bl2;
        String string = eM.d(itemStack);
        boolean bl3 = bl2 = string != null && string.equals(playerInteractAtEntityEvent.getPlayer().getUniqueId().toString());
        if (bl2) {
            if (hasWorldGuard) {
                FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(Flags.VEHICLE_PERSONAL_SIT, playerInteractAtEntityEvent.getPlayer(), playerInteractAtEntityEvent.getRightClicked());
                if (flagResult == FlagResult.ALLOW) {
                    return true;
                }
                if (flagResult == FlagResult.DENY) {
                    return false;
                }
                if (flagResult == FlagResult.BYPASS) {
                    return true;
                }
                if (flagResult == FlagResult.NO_REGION) {
                    return !playerInteractAtEntityEvent.isCancelled();
                }
            }
        } else if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(Flags.VEHICLE_SIT, playerInteractAtEntityEvent.getPlayer(), playerInteractAtEntityEvent.getRightClicked());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return !playerInteractAtEntityEvent.isCancelled();
            }
        }
        return true;
    }

    public static boolean canRemoveVehicle(Player player, Entity entity, ItemStack itemStack) {
        boolean bl2;
        String string = eM.d(itemStack);
        boolean bl3 = bl2 = string != null && string.equals(player.getUniqueId().toString());
        if (bl2) {
            if (hasWorldGuard) {
                FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(Flags.VEHICLE_PERSONAL_REMOVE, player, entity);
                if (flagResult == FlagResult.ALLOW) {
                    return true;
                }
                if (flagResult == FlagResult.DENY) {
                    return false;
                }
                if (flagResult == FlagResult.BYPASS) {
                    return true;
                }
                if (flagResult == FlagResult.NO_REGION) {
                    return true;
                }
            }
        } else if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(Flags.VEHICLE_REMOVE, player, entity);
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return true;
            }
        }
        return rt.a((Entity)player, entity);
    }

    public static boolean canPlaceVehicle(Player player, Block block) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testBlockFlag(Flags.VEHICLE_PLACE, player, block);
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return true;
            }
        }
        return rt.b(block, player);
    }

    public static boolean canInteract_placedBlock(PlayerInteractEvent playerInteractEvent) {
        return ProtectionPlugins.canInteract_block(playerInteractEvent, Flags.PLACED_BLOCK_INTERACT);
    }

    public static boolean canInteract_tradeMachineBlock(PlayerInteractEvent playerInteractEvent) {
        return ProtectionPlugins.canInteract_block(playerInteractEvent, Flags.TRADE_MACHINES_USE);
    }

    public static boolean canInteract_tradeMachineArmorstand(Player player, Entity entity, boolean bl2) {
        return ProtectionPlugins.canInteract_entity(player, entity, Flags.TRADE_MACHINES_USE, bl2);
    }

    public static boolean canInteract_tradeMachineArmorstand(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        return ProtectionPlugins.canInteract_entity(playerInteractAtEntityEvent, Flags.TRADE_MACHINES_USE);
    }

    public static boolean canInteract_placedArmorStand(Player player, Entity entity, boolean bl2) {
        if (!ProtectionPlugins.canInteract_entity(player, entity, Flags.PLACED_FURNITURE_INTERACT, bl2)) {
            return false;
        }
        if (R.at) {
            return ProtectionPlugins.canInteract_entity(player, entity, Flags.PLACED_ARMORSTAND_INTERACT, bl2);
        }
        return true;
    }

    public static boolean canInteract_placedArmorStand(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (!ProtectionPlugins.canInteract_entity(playerInteractAtEntityEvent, Flags.PLACED_FURNITURE_INTERACT)) {
            return false;
        }
        if (R.at) {
            return ProtectionPlugins.canInteract_entity(playerInteractAtEntityEvent, Flags.PLACED_ARMORSTAND_INTERACT);
        }
        return true;
    }

    public static boolean canInteract_placedItemFrame(Player player, Entity entity, boolean bl2) {
        if (!ProtectionPlugins.canInteract_entity(player, entity, Flags.PLACED_FURNITURE_INTERACT, bl2)) {
            return false;
        }
        if (R.at) {
            return ProtectionPlugins.canInteract_entity(player, entity, Flags.PLACED_ITEMFRAME_INTERACT, bl2);
        }
        return true;
    }

    public static boolean canInteract_placedItemFrame(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (!ProtectionPlugins.canInteract_entity(playerInteractAtEntityEvent, Flags.PLACED_FURNITURE_INTERACT)) {
            return false;
        }
        if (R.at) {
            return ProtectionPlugins.canInteract_entity(playerInteractAtEntityEvent, Flags.PLACED_ITEMFRAME_INTERACT);
        }
        return true;
    }

    private static boolean canInteract_block(PlayerInteractEvent playerInteractEvent, StateFlag stateFlag) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testBlockFlag(stateFlag, playerInteractEvent.getPlayer(), playerInteractEvent.getClickedBlock());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return playerInteractEvent.useInteractedBlock() != Event.Result.DENY;
            }
        }
        return playerInteractEvent.useInteractedBlock() != Event.Result.DENY;
    }

    public static boolean canInteract_tradeMachineBlock(CustomBlockInteractEvent customBlockInteractEvent) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testBlockFlag(Flags.TRADE_MACHINES_USE, customBlockInteractEvent.getPlayer(), customBlockInteractEvent.getBlockClicked());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return !customBlockInteractEvent.isCancelled();
            }
        }
        return !customBlockInteractEvent.isCancelled();
    }

    private static boolean canInteract_entity(PlayerInteractAtEntityEvent playerInteractAtEntityEvent, StateFlag stateFlag) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(stateFlag, playerInteractAtEntityEvent.getPlayer(), playerInteractAtEntityEvent.getRightClicked());
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return !playerInteractAtEntityEvent.isCancelled();
            }
        }
        return !playerInteractAtEntityEvent.isCancelled();
    }

    private static boolean canInteract_entity(Player player, Entity entity, StateFlag stateFlag, boolean bl2) {
        if (hasWorldGuard) {
            FlagResult flagResult = WorldGuardFlagsManager.testEntityFlag(stateFlag, player, entity);
            if (flagResult == FlagResult.ALLOW) {
                return true;
            }
            if (flagResult == FlagResult.DENY) {
                return false;
            }
            if (flagResult == FlagResult.BYPASS) {
                return true;
            }
            if (flagResult == FlagResult.NO_REGION) {
                return !bl2;
            }
        }
        return !bl2;
    }

    public static boolean hasAnyProcetionPlugin() {
        return hasWorldGuard;
    }
}

