/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.locator.locators;

import com.dfsek.terra.api.structure.feature.BinaryColumn;
import com.dfsek.terra.api.structure.feature.Locator;
import com.dfsek.terra.api.util.Range;
import com.dfsek.terra.api.world.chunk.generation.util.Column;
import java.util.Random;

public class GaussianRandomLocator
implements Locator {
    private final double mean;
    private final Range points;
    private final double standardDeviation;
    private final int salt;

    public GaussianRandomLocator(Range height, Range points, double standardDeviation, int salt) {
        this.mean = (double)(height.getMax() + height.getMin()) / 2.0;
        this.points = points;
        this.standardDeviation = standardDeviation;
        this.salt = salt;
    }

    public BinaryColumn getSuitableCoordinates(Column<?> column) {
        long seed = column.getWorld().getSeed();
        seed = 31L * seed + (long)column.getX();
        seed = 31L * seed + (long)column.getZ();
        Random r = new Random(seed += (long)this.salt);
        int size = this.points.get(r);
        Column.BinaryColumnBuilder results = column.newBinaryColumn();
        for (int i = 0; i < size; ++i) {
            int h = (int)r.nextGaussian(this.mean, this.standardDeviation);
            if (h >= column.getMaxY() || h < column.getMinY()) continue;
            results.set(h);
        }
        return results.build();
    }
}

