/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SafeScoreboard<T extends TabPlayer>
implements Scoreboard {
    private static String lastTeamOverrideMessage;
    protected final T player;
    private final Map<String, String> blockedTeamAdds = new HashMap<String, String>();
    private final Map<String, String> allowedTeamAdds = new HashMap<String, String>();
    private boolean frozen;
    private final Map<String, Objective> objectives = new ConcurrentHashMap<String, Objective>();
    private final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();

    @Override
    public synchronized void registerObjective(@NonNull String objectiveName, @NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay display, @Nullable TabComponent numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        Objective existing = this.objectives.get(objectiveName);
        if (existing != null) {
            this.error("Tried to register duplicated objective %s to player ", objectiveName);
            return;
        }
        Objective objective = new Objective(objectiveName, title, display, numberFormat, null);
        this.objectives.put(objectiveName, objective);
        if (this.frozen) {
            return;
        }
        this.registerObjective(objective);
    }

    @Override
    public synchronized void setDisplaySlot(@NonNull String objectiveName, @NonNull Scoreboard.DisplaySlot displaySlot) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (displaySlot == null) {
            throw new NullPointerException("displaySlot is marked non-null but is null");
        }
        Objective objective = this.objectives.get(objectiveName);
        if (objective == null) {
            this.error("Tried to set display slot for non-existing objective %s to player ", objectiveName);
            return;
        }
        objective.setDisplaySlot(displaySlot);
        if (this.frozen) {
            return;
        }
        this.setDisplaySlot(objective);
    }

    @Override
    public synchronized void unregisterObjective(@NonNull String objectiveName) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        Objective objective = this.objectives.remove(objectiveName);
        if (objective == null) {
            this.error("Tried to unregister non-existing objective %s for player ", objectiveName);
            return;
        }
        if (this.frozen) {
            return;
        }
        this.unregisterObjective(objective);
    }

    @Override
    public synchronized void updateObjective(@NonNull String objectiveName, @NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay display, @Nullable TabComponent numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        Objective objective = this.objectives.get(objectiveName);
        if (objective == null) {
            this.error("Tried to modify non-existing objective %s for player ", objectiveName);
            return;
        }
        objective.update(title, display, numberFormat);
        if (this.frozen) {
            return;
        }
        this.updateObjective(objective);
    }

    @Override
    public synchronized void setScore(@NonNull String objectiveName, @NonNull String scoreHolder, int value, @Nullable TabComponent displayName, @Nullable TabComponent numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        Objective objective = this.objectives.get(objectiveName);
        if (objective == null) {
            this.error("Tried to update score (%s) without the existence of its requested objective '%s' to player ", scoreHolder, objectiveName);
            return;
        }
        Score score = objective.getScores().get(scoreHolder);
        if (score == null) {
            score = new Score(objective, scoreHolder, value, displayName, numberFormat);
            objective.getScores().put(scoreHolder, score);
        } else {
            score.update(value, displayName, numberFormat);
        }
        if (this.frozen) {
            return;
        }
        this.setScore(score);
    }

    @Override
    public synchronized void removeScore(@NonNull String objectiveName, @NonNull String scoreHolder) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        Objective objective = this.objectives.get(objectiveName);
        if (objective == null) {
            this.error("Tried to remove score (%s) without the existence of its requested objective '%s' to player ", scoreHolder, objectiveName);
            return;
        }
        Score score = objective.getScores().remove(scoreHolder);
        if (score == null) {
            return;
        }
        if (this.frozen) {
            return;
        }
        this.removeScore(score);
    }

    @Override
    public synchronized void registerTeam(@NonNull String name, @NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, @NonNull Collection<String> players, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        Team existing = this.teams.get(name);
        if (existing != null) {
            this.error("Tried to register duplicated team %s with entry %s, while this team already exists with entry %s to player ", name, players.toString(), existing.players.toString());
            return;
        }
        Team team = new Team(this.createTeam(name), name, prefix, suffix, visibility, collision, players, options, color);
        this.teams.put(name, team);
        if (this.frozen) {
            return;
        }
        this.registerTeam(team);
    }

    @Override
    public synchronized void unregisterTeam(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        Team team = this.teams.remove(teamName);
        if (team == null) {
            this.error("Tried to unregister non-existing team %s for player ", teamName);
            return;
        }
        if (this.frozen) {
            return;
        }
        this.unregisterTeam(team);
    }

    @Override
    public synchronized void updateTeam(@NonNull String name, @NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        Team team = this.teams.get(name);
        if (team == null) {
            this.error("Tried to modify non-existing team %s for player ", name);
            return;
        }
        team.update(prefix, suffix, visibility, collision, options, color);
        if (this.frozen) {
            return;
        }
        this.updateTeam(team);
    }

    @Override
    public synchronized void updateTeam(@NonNull String name, @NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        Team team = this.teams.get(name);
        if (team == null) {
            return;
        }
        team.update(prefix, suffix, color);
        if (this.frozen) {
            return;
        }
        this.updateTeam(team);
    }

    @Override
    public synchronized void updateTeam(@NonNull String name, @NonNull Scoreboard.CollisionRule collision) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        Team team = this.teams.get(name);
        if (team == null) {
            return;
        }
        team.collision = collision;
        if (this.frozen) {
            return;
        }
        this.updateTeam(team);
    }

    @Override
    public synchronized void updateTeam(@NonNull String name, @NonNull Scoreboard.NameVisibility visibility) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        Team team = this.teams.get(name);
        if (team == null) {
            return;
        }
        team.visibility = visibility;
        if (this.frozen) {
            return;
        }
        this.updateTeam(team);
    }

    @Override
    public synchronized void renameTeam(@NonNull String oldName, @NonNull String newName) {
        if (oldName == null) {
            throw new NullPointerException("oldName is marked non-null but is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        Team team = this.teams.get(oldName);
        if (team == null) {
            return;
        }
        this.unregisterTeam(oldName);
        this.registerTeam(newName, team.prefix, team.suffix, team.visibility, team.collision, team.players, team.options, team.color);
    }

    @Override
    public synchronized void resend() {
        for (Objective objective : this.objectives.values()) {
            this.registerObjective(objective);
            if (objective.getDisplaySlot() != null) {
                this.setDisplaySlot(objective);
            }
            for (Score score : objective.getScores().values()) {
                this.setScore(score);
            }
        }
        for (Team team : this.teams.values()) {
            this.registerTeam(team);
        }
    }

    @Override
    public synchronized void clear() {
        for (String objective : this.objectives.keySet()) {
            this.unregisterObjective(objective);
        }
        for (String team : this.teams.keySet()) {
            this.unregisterTeam(team);
        }
    }

    public synchronized void unregisterTeamSafe(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        Team team = this.teams.remove(teamName);
        if (team == null || this.frozen) {
            return;
        }
        this.unregisterTeam(team);
    }

    private void error(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        TAB.getInstance().getErrorManager().printError(String.format(format, args) + ((TabPlayer)this.player).getName(), null);
    }

    public static String cutTo(@Nullable String string, int length) {
        if (string == null) {
            return "";
        }
        if (string.length() <= length) {
            return string;
        }
        if (string.charAt(length - 1) == '\u00a7') {
            return string.substring(0, length - 1);
        }
        return string.substring(0, length);
    }

    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return packet;
    }

    @NotNull
    public Collection<String> onTeamPacket(int action, @NonNull String teamName, @NonNull Collection<String> players) {
        Team expectedTeam;
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        ArrayList<String> newList = new ArrayList<String>();
        if (action == 0 || action == 3) {
            for (String entry2 : players) {
                expectedTeam = this.getExpectedTeam(entry2);
                if (expectedTeam == null) {
                    this.blockedTeamAdds.remove(entry2);
                    this.allowedTeamAdds.put(entry2, teamName);
                    newList.add(entry2);
                    continue;
                }
                if (teamName.equals(expectedTeam.getName())) {
                    newList.add(entry2);
                    this.allowedTeamAdds.remove(entry2);
                    continue;
                }
                this.blockedTeamAdds.put(entry2, teamName);
                SafeScoreboard.logTeamOverride(teamName, entry2, expectedTeam);
            }
        }
        if (action == 4) {
            for (String entry2 : players) {
                expectedTeam = this.getExpectedTeam(entry2);
                if (expectedTeam != null) {
                    this.allowedTeamAdds.remove(entry2);
                    this.blockedTeamAdds.remove(entry2);
                    continue;
                }
                if (this.allowedTeamAdds.containsKey(entry2)) {
                    this.allowedTeamAdds.remove(entry2);
                    newList.add(entry2);
                    continue;
                }
                this.blockedTeamAdds.remove(entry2);
            }
        }
        if (action == 1) {
            this.allowedTeamAdds.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(teamName));
            this.blockedTeamAdds.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(teamName));
        }
        return newList;
    }

    @Nullable
    private Team getExpectedTeam(@NotNull String player) {
        for (Team team : this.teams.values()) {
            if (!team.getPlayers().contains(player)) continue;
            return team;
        }
        return null;
    }

    public static void logTeamOverride(@NonNull String team, @NonNull String player, @NonNull Team expectedTeam) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (expectedTeam == null) {
            throw new NullPointerException("expectedTeam is marked non-null but is null");
        }
        String source = null;
        String fix = null;
        if (team.startsWith("collideRule_")) {
            source = "Paper";
            fix = "set \"enable-player-collisions: true\" in paper config. To keep collisions disabled, set collision to false in TAB config.";
        } else if (team.startsWith("CMINP")) {
            source = "CMI";
            fix = "set \"DisableTeamManagement: true\" in \"plugins/CMI/config.yml\".";
        } else if (team.startsWith("CIT-")) {
            source = "Citizens";
            fix = "use NPC names that do not match names of online players.";
        }
        String message = "Blocked attempt to add player " + player + " into team " + team + " (expected team: " + expectedTeam.getName() + ").";
        if (source != null) {
            message = message + " Source of the team: " + source + ". To fix this, " + fix;
        }
        if (!message.equals(lastTeamOverrideMessage)) {
            lastTeamOverrideMessage = message;
            TAB.getInstance().getErrorManager().logAntiOverride(message);
        }
    }

    public abstract void registerObjective(@NonNull Objective var1);

    public abstract void setDisplaySlot(@NonNull Objective var1);

    public abstract void unregisterObjective(@NonNull Objective var1);

    public abstract void updateObjective(@NonNull Objective var1);

    public abstract void setScore(@NonNull Score var1);

    public abstract void removeScore(@NonNull Score var1);

    @NotNull
    public abstract Object createTeam(@NonNull String var1);

    public abstract void registerTeam(@NonNull Team var1);

    public abstract void unregisterTeam(@NonNull Team var1);

    public abstract void updateTeam(@NonNull Team var1);

    @Generated
    public SafeScoreboard(T player) {
        this.player = player;
    }

    @Generated
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Generated
    public T getPlayer() {
        return this.player;
    }

    public static class Objective {
        @Nullable
        private Scoreboard.DisplaySlot displaySlot;
        @NonNull
        private final String name;
        @NonNull
        private TabComponent title;
        @NonNull
        private Scoreboard.HealthDisplay healthDisplay;
        @Nullable
        private TabComponent numberFormat;
        @NonNull
        private final Map<String, Score> scores = new HashMap<String, Score>();
        @Nullable
        private Object platformObjective;

        private Objective(@NonNull String name, @NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay healthDisplay, @Nullable TabComponent numberFormat, @Nullable Object platformObjective) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (healthDisplay == null) {
                throw new NullPointerException("healthDisplay is marked non-null but is null");
            }
            this.name = name;
            this.title = title;
            this.healthDisplay = healthDisplay;
            this.numberFormat = numberFormat;
            this.platformObjective = platformObjective;
        }

        private void update(@NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay healthDisplay, @Nullable TabComponent numberFormat) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (healthDisplay == null) {
                throw new NullPointerException("healthDisplay is marked non-null but is null");
            }
            this.title = title;
            this.healthDisplay = healthDisplay;
            this.numberFormat = numberFormat;
        }

        @Nullable
        @Generated
        public Scoreboard.DisplaySlot getDisplaySlot() {
            return this.displaySlot;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public TabComponent getTitle() {
            return this.title;
        }

        @NonNull
        @Generated
        public Scoreboard.HealthDisplay getHealthDisplay() {
            return this.healthDisplay;
        }

        @Nullable
        @Generated
        public TabComponent getNumberFormat() {
            return this.numberFormat;
        }

        @NonNull
        @Generated
        public Map<String, Score> getScores() {
            return this.scores;
        }

        @Nullable
        @Generated
        public Object getPlatformObjective() {
            return this.platformObjective;
        }

        @Generated
        public void setDisplaySlot(@Nullable Scoreboard.DisplaySlot displaySlot) {
            this.displaySlot = displaySlot;
        }

        @Generated
        public void setTitle(@NonNull TabComponent title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
        }

        @Generated
        public void setHealthDisplay(@NonNull Scoreboard.HealthDisplay healthDisplay) {
            if (healthDisplay == null) {
                throw new NullPointerException("healthDisplay is marked non-null but is null");
            }
            this.healthDisplay = healthDisplay;
        }

        @Generated
        public void setNumberFormat(@Nullable TabComponent numberFormat) {
            this.numberFormat = numberFormat;
        }

        @Generated
        public void setPlatformObjective(@Nullable Object platformObjective) {
            this.platformObjective = platformObjective;
        }
    }

    public static class Score {
        @NonNull
        private final Objective objective;
        @NonNull
        private final String holder;
        private int value;
        @Nullable
        private TabComponent displayName;
        @Nullable
        private TabComponent numberFormat;

        private void update(int value, @Nullable TabComponent displayName, @Nullable TabComponent numberFormat) {
            this.value = value;
            this.displayName = displayName;
            this.numberFormat = numberFormat;
        }

        @Generated
        public Score(@NonNull Objective objective, @NonNull String holder, int value, @Nullable TabComponent displayName, @Nullable TabComponent numberFormat) {
            if (objective == null) {
                throw new NullPointerException("objective is marked non-null but is null");
            }
            if (holder == null) {
                throw new NullPointerException("holder is marked non-null but is null");
            }
            this.objective = objective;
            this.holder = holder;
            this.value = value;
            this.displayName = displayName;
            this.numberFormat = numberFormat;
        }

        @NonNull
        @Generated
        public Objective getObjective() {
            return this.objective;
        }

        @NonNull
        @Generated
        public String getHolder() {
            return this.holder;
        }

        @Generated
        public int getValue() {
            return this.value;
        }

        @Nullable
        @Generated
        public TabComponent getDisplayName() {
            return this.displayName;
        }

        @Nullable
        @Generated
        public TabComponent getNumberFormat() {
            return this.numberFormat;
        }

        @Generated
        public void setValue(int value) {
            this.value = value;
        }

        @Generated
        public void setDisplayName(@Nullable TabComponent displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setNumberFormat(@Nullable TabComponent numberFormat) {
            this.numberFormat = numberFormat;
        }
    }

    public static class Team {
        @NotNull
        private Object platformTeam;
        @NonNull
        private final String name;
        @NonNull
        private TabComponent prefix;
        @NonNull
        private TabComponent suffix;
        @NonNull
        private Scoreboard.NameVisibility visibility;
        @NonNull
        private Scoreboard.CollisionRule collision;
        @NonNull
        private Collection<String> players;
        private int options;
        @NonNull
        private EnumChatFormat color;

        private void update(@NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, int options, @NonNull EnumChatFormat color) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            if (visibility == null) {
                throw new NullPointerException("visibility is marked non-null but is null");
            }
            if (collision == null) {
                throw new NullPointerException("collision is marked non-null but is null");
            }
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.prefix = prefix;
            this.suffix = suffix;
            this.visibility = visibility;
            this.collision = collision;
            this.options = options;
            this.color = color;
        }

        private void update(@NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull EnumChatFormat color) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.prefix = prefix;
            this.suffix = suffix;
            this.color = color;
        }

        @Generated
        public Team(@NotNull Object platformTeam, @NonNull String name, @NonNull TabComponent prefix, @NonNull TabComponent suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, @NonNull Collection<String> players, int options, @NonNull EnumChatFormat color) {
            if (platformTeam == null) {
                throw new NullPointerException("platformTeam is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            if (visibility == null) {
                throw new NullPointerException("visibility is marked non-null but is null");
            }
            if (collision == null) {
                throw new NullPointerException("collision is marked non-null but is null");
            }
            if (players == null) {
                throw new NullPointerException("players is marked non-null but is null");
            }
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.platformTeam = platformTeam;
            this.name = name;
            this.prefix = prefix;
            this.suffix = suffix;
            this.visibility = visibility;
            this.collision = collision;
            this.players = players;
            this.options = options;
            this.color = color;
        }

        @NotNull
        @Generated
        public Object getPlatformTeam() {
            return this.platformTeam;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public TabComponent getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public TabComponent getSuffix() {
            return this.suffix;
        }

        @NonNull
        @Generated
        public Scoreboard.NameVisibility getVisibility() {
            return this.visibility;
        }

        @NonNull
        @Generated
        public Scoreboard.CollisionRule getCollision() {
            return this.collision;
        }

        @NonNull
        @Generated
        public Collection<String> getPlayers() {
            return this.players;
        }

        @Generated
        public int getOptions() {
            return this.options;
        }

        @NonNull
        @Generated
        public EnumChatFormat getColor() {
            return this.color;
        }

        @Generated
        public void setPlatformTeam(@NotNull Object platformTeam) {
            if (platformTeam == null) {
                throw new NullPointerException("platformTeam is marked non-null but is null");
            }
            this.platformTeam = platformTeam;
        }

        @Generated
        public void setPrefix(@NonNull TabComponent prefix) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.prefix = prefix;
        }

        @Generated
        public void setSuffix(@NonNull TabComponent suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            this.suffix = suffix;
        }

        @Generated
        public void setVisibility(@NonNull Scoreboard.NameVisibility visibility) {
            if (visibility == null) {
                throw new NullPointerException("visibility is marked non-null but is null");
            }
            this.visibility = visibility;
        }

        @Generated
        public void setCollision(@NonNull Scoreboard.CollisionRule collision) {
            if (collision == null) {
                throw new NullPointerException("collision is marked non-null but is null");
            }
            this.collision = collision;
        }

        @Generated
        public void setPlayers(@NonNull Collection<String> players) {
            if (players == null) {
                throw new NullPointerException("players is marked non-null but is null");
            }
            this.players = players;
        }

        @Generated
        public void setOptions(int options) {
            this.options = options;
        }

        @Generated
        public void setColor(@NonNull EnumChatFormat color) {
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.color = color;
        }
    }
}

