/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.animation;

import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.placeholders.animation.AnimationConfiguration;
import org.jetbrains.annotations.NotNull;

public class Animation {
    private final PlaceholderManagerImpl placeholderManager;
    private final String name;
    private final String[] messages;
    private final int interval;
    private final int refresh;

    public Animation(@NotNull PlaceholderManagerImpl placeholderManager, @NonNull String name, @NotNull AnimationConfiguration.AnimationDefinition configuration) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.placeholderManager = placeholderManager;
        this.name = name;
        this.messages = configuration.getTexts().toArray(new String[0]);
        int refresh = this.interval = configuration.getChangeInterval();
        ArrayList<String> nestedPlaceholders = new ArrayList<String>();
        for (int i = 0; i < this.messages.length; ++i) {
            this.messages[i] = EnumChatFormat.color(this.messages[i]);
            nestedPlaceholders.addAll(PlaceholderManagerImpl.detectPlaceholders(this.messages[i]));
        }
        for (String placeholder : nestedPlaceholders) {
            AnimationConfiguration cfg;
            int localRefresh = placeholder.startsWith("%animation:") ? ((cfg = TAB.getInstance().getConfiguration().getAnimations().getAnimations()).getAnimations().containsKey(placeholder) ? cfg.getAnimations().get(placeholder).getChangeInterval() : this.interval) : placeholderManager.getPlaceholder(placeholder).getRefresh();
            if (localRefresh == -1 || localRefresh >= refresh) continue;
            refresh = localRefresh;
        }
        this.refresh = refresh;
    }

    @NotNull
    public String getMessage() {
        return this.messages[(int)(this.placeholderManager.getLoopTime() % (long)(this.messages.length * this.interval) / (long)this.interval)];
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getRefresh() {
        return this.refresh;
    }
}

