/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.neznamy.tab.shared.data.Server;
import me.neznamy.tab.shared.data.ServerGroup;
import me.neznamy.tab.shared.data.World;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerListConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataManager {
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, ServerGroup> serverGroups = new HashMap<String, ServerGroup>();
    private final ServerGroup defaultServerGroup = new ServerGroup("DEFAULT", new ArrayList<String>());
    private final Map<String, World> worlds = new HashMap<String, World>();
    @Nullable
    private GlobalPlayerListConfiguration globalPlayerListConfiguration;

    public void applyConfiguration(@NotNull GlobalPlayerListConfiguration configuration) {
        this.globalPlayerListConfiguration = configuration;
        for (String string : configuration.getSpyServers()) {
            this.servers.computeIfAbsent(string, Server::new).markSpyServer();
        }
        for (Map.Entry entry : configuration.getSharedServers().entrySet()) {
            this.serverGroups.put((String)entry.getKey(), new ServerGroup((String)entry.getKey(), (List)entry.getValue()));
        }
        for (Server server : this.servers.values()) {
            server.setServerGroup(this.computeServerGroup(server));
        }
    }

    @Nullable
    ServerGroup computeServerGroup(@NotNull Server server) {
        if (this.globalPlayerListConfiguration == null) {
            return null;
        }
        for (ServerGroup group : this.serverGroups.values()) {
            for (String serverDefinition : group.getPatterns()) {
                if (!(serverDefinition.endsWith("*") ? server.getName().startsWith(serverDefinition.substring(0, serverDefinition.length() - 1).toLowerCase()) : (serverDefinition.startsWith("*") ? server.getName().endsWith(serverDefinition.substring(1).toLowerCase()) : server.getName().equals(serverDefinition)))) continue;
                return group;
            }
        }
        if (this.globalPlayerListConfiguration.isIsolateUnlistedServers()) {
            return new ServerGroup("", Collections.emptyList());
        }
        return this.defaultServerGroup;
    }

    @Generated
    public Map<String, Server> getServers() {
        return this.servers;
    }

    @Generated
    public Map<String, ServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    @Generated
    public ServerGroup getDefaultServerGroup() {
        return this.defaultServerGroup;
    }

    @Generated
    public Map<String, World> getWorlds() {
        return this.worlds;
    }

    @Nullable
    @Generated
    public GlobalPlayerListConfiguration getGlobalPlayerListConfiguration() {
        return this.globalPlayerListConfiguration;
    }
}

