/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.converter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabTextColor;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.placeholders.conditions.ConditionsSection;

public class ModernConverter {
    private final Map<Integer, Consumer<ConfigurationFile>> converters = new HashMap<Integer, Consumer<ConfigurationFile>>();

    public ModernConverter() {
        this.converters.put(0, config -> {
            LinkedHashMap<String, Boolean> components = new LinkedHashMap<String, Boolean>();
            components.put("minimessage-support", true);
            components.put("disable-shadow-for-heads", true);
            config.set("components", components);
        });
        this.converters.put(1, config -> {
            List<String> footer;
            List<String> header;
            LinkedHashMap<String, Object> design;
            TAB.getInstance().getPlatform().logWarn(new TabTextComponent("Please note that header/footer conversion may not be 100% accurate and will not convert per-group settings and per-user settings. Review your config to make sure it is set up the way you want.", TabTextColor.RED));
            ConfigurationSection headerFooter = config.getConfigurationSection("header-footer");
            boolean enabled = headerFooter.getBoolean("enabled", true);
            List<String> defaultHeader = headerFooter.getStringList("header", new ArrayList<String>());
            List<String> defaultFooter = headerFooter.getStringList("footer", new ArrayList<String>());
            String disableCondition = headerFooter.getString("disable-condition", "%world%=disabledworld");
            ConfigurationSection perWorld = headerFooter.getConfigurationSection("per-world");
            ConfigurationSection perServer = headerFooter.getConfigurationSection("per-server");
            LinkedHashMap designs = new LinkedHashMap();
            for (Object world : perWorld.getKeys()) {
                ConfigurationSection worldSection = perWorld.getConfigurationSection(world.toString());
                design = new LinkedHashMap<String, Object>();
                design.put("display-condition", Arrays.stream(world.toString().split(";")).map(part -> {
                    if (part.endsWith("*")) {
                        return "%world%|-" + part.substring(0, part.length() - 1);
                    }
                    if (part.startsWith("*")) {
                        return "%world%-|" + part.substring(1);
                    }
                    return "%world%=" + part;
                }).collect(Collectors.joining("|")));
                header = worldSection.getStringList("header");
                if (header == null) {
                    header = new ArrayList<String>();
                }
                if ((footer = worldSection.getStringList("footer")) == null) {
                    footer = new ArrayList<String>();
                }
                design.put("header", header);
                design.put("footer", footer);
                designs.put("world-" + world, design);
            }
            for (Object server : perServer.getKeys()) {
                ConfigurationSection serverSection = perServer.getConfigurationSection(server.toString());
                design = new LinkedHashMap();
                design.put("display-condition", Arrays.stream(server.toString().split(";")).map(part -> {
                    if (part.endsWith("*")) {
                        return "%server%|-" + part.substring(0, part.length() - 1);
                    }
                    if (part.startsWith("*")) {
                        return "%server%-|" + part.substring(1);
                    }
                    return "%server%=" + part;
                }).collect(Collectors.joining("|")));
                header = serverSection.getStringList("header");
                if (header == null) {
                    header = new ArrayList<String>();
                }
                if ((footer = serverSection.getStringList("footer")) == null) {
                    footer = new ArrayList<String>();
                }
                design.put("header", header);
                design.put("footer", footer);
                designs.put("server-" + server, design);
            }
            LinkedHashMap<String, Object> defaultDesign = new LinkedHashMap<String, Object>();
            if (!disableCondition.isEmpty()) {
                ConditionsSection conditions = ConditionsSection.fromSection(config.getConfigurationSection("conditions"));
                ConditionsSection.ConditionDefinition namedCondition = conditions.getConditions().get(disableCondition);
                if (namedCondition != null) {
                    defaultDesign.put("display-condition", "%condition:" + namedCondition.getName() + "%=" + namedCondition.getNo());
                } else {
                    defaultDesign.put("display-condition", new Condition(disableCondition).invert().toShortFormat());
                }
            }
            defaultDesign.put("header", defaultHeader);
            defaultDesign.put("footer", defaultFooter);
            designs.put("default", defaultDesign);
            LinkedHashMap<String, Serializable> newHeaderFooter = new LinkedHashMap<String, Serializable>();
            newHeaderFooter.put("enabled", Boolean.valueOf(enabled));
            newHeaderFooter.put("designs", designs);
            config.set("header-footer", newHeaderFooter);
        });
    }

    public void convert(@NonNull ConfigurationFile config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        int configVersion = config.getInt("config-version", 0);
        while (this.converters.containsKey(configVersion)) {
            TAB.getInstance().getPlatform().logInfo(new TabTextComponent("Performing configuration conversion from config version " + configVersion + " to " + (configVersion + 1), TabTextColor.YELLOW));
            this.converters.get(configVersion).accept(config);
            config.set("config-version", ++configVersion);
        }
    }
}

