/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.data.Server;
import me.neznamy.tab.shared.data.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConfiguration {
    @NotNull
    public static final List<String> VALID_PROPERTIES = Lists.newArrayList((Object[])new String[]{"tagprefix", "tagsuffix", "tabprefix", "customtabname", "tabsuffix"});

    public void setProperty(@NonNull String var1, @NonNull String var2, @Nullable Server var3, @Nullable World var4, @Nullable String var5);

    @NotNull
    public String[] getProperty(@NonNull String var1, @NonNull String var2, @Nullable Server var3, @Nullable World var4);

    public void remove(@NonNull String var1);

    @NotNull
    public Map<String, Object> getGlobalSettings(@NonNull String var1);

    @NotNull
    public Map<String, Map<String, Object>> getPerWorldSettings(@NonNull String var1);

    @NotNull
    public Map<String, Map<String, Object>> getPerServerSettings(@NonNull String var1);

    @NotNull
    public Set<String> getAllEntries();

    @NotNull
    default public Map<String, Map<String, Object>> convertMap(@NonNull Map<String, Map<String, Map<String, Object>>> map, String groupOrUser) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        HashMap<String, Map<String, Object>> converted = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : map.entrySet()) {
            converted.put(entry.getKey(), entry.getValue().get(groupOrUser));
        }
        return converted;
    }

    @NotNull
    default public String toString(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (obj instanceof List) {
            return ((List)obj).stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
        return obj.toString();
    }

    @Nullable
    default public Object fromString(@Nullable String string) {
        if (string != null && string.contains("\n")) {
            return Arrays.asList(string.split("\n"));
        }
        return string;
    }

    default public void checkProperty(@NonNull String source, @NonNull String type, @NonNull String name, @NonNull String property, @Nullable String server, @Nullable String world, boolean startupWarn) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (VALID_PROPERTIES.contains(property.toLowerCase(Locale.US))) {
            return;
        }
        StringBuilder msg = new StringBuilder(String.format("[%s] Unknown property \"%s\" defined for %s \"%s\"", source, property, type, name));
        if (world != null) {
            msg.append(" in world \"").append(world).append("\"");
        }
        if (server != null) {
            msg.append(" in server \"").append(server).append("\"");
        }
        msg.append(". Valid properties: ").append(VALID_PROPERTIES);
        if (startupWarn) {
            TAB.getInstance().getConfigHelper().startup().startupWarn(msg.toString());
        } else {
            TAB.getInstance().getConfigHelper().runtime().error(msg.toString());
        }
    }
}

