/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command.scoreboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.api.scoreboard.ScoreboardManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardAnnounceCommand
extends SubCommand {
    public ScoreboardAnnounceCommand() {
        super("announce", "tab.announce.scoreboard");
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        int duration;
        ScoreboardManager feature = (ScoreboardManager)TAB.getInstance().getFeatureManager().getFeature("ScoreBoard");
        if (feature == null) {
            this.sendMessage(sender, this.getMessages().getScoreboardFeatureNotEnabled());
            return;
        }
        if (args.length != 2) {
            this.sendMessage(sender, this.getMessages().getScoreboardAnnounceCommandUsage());
            return;
        }
        String scoreboard = args[0];
        try {
            duration = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, this.getMessages().getInvalidNumber(args[1]));
            return;
        }
        Scoreboard sb = feature.getRegisteredScoreboards().get(scoreboard);
        if (sb == null) {
            this.sendMessage(sender, this.getMessages().getScoreboardNotFound(scoreboard));
            return;
        }
        feature.announceScoreboard(sb.getName(), duration);
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        ArrayList<String> suggestions;
        block4: {
            ScoreboardManager s;
            block3: {
                s = (ScoreboardManager)TAB.getInstance().getFeatureManager().getFeature("ScoreBoard");
                if (s == null) {
                    return Collections.emptyList();
                }
                suggestions = new ArrayList<String>();
                if (arguments.length != 1) break block3;
                for (String bar : s.getRegisteredScoreboards().keySet()) {
                    if (!bar.toLowerCase().startsWith(arguments[0].toLowerCase())) continue;
                    suggestions.add(bar);
                }
                break block4;
            }
            if (arguments.length != 2 || s.getRegisteredScoreboards().get(arguments[0]) == null) break block4;
            for (String time : Arrays.asList("5", "10", "30", "60", "120")) {
                if (!time.startsWith(arguments[1])) continue;
                suggestions.add(time);
            }
        }
        return suggestions;
    }
}

