/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.paper_1_21_11;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import me.neznamy.tab.platforms.bukkit.provider.ComponentConverter;
import me.neznamy.tab.shared.chat.TabStyle;
import me.neznamy.tab.shared.chat.component.object.TabAtlasSprite;
import me.neznamy.tab.shared.chat.component.object.TabPlayerSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.NotNull;

public class PaperComponentConverter
extends ComponentConverter<Component> {
    @Override
    @NotNull
    public Component newTextComponent(@NotNull String text) {
        return Component.literal((String)text);
    }

    @Override
    @NotNull
    public Component newTranslatableComponent(@NotNull String key) {
        return Component.translatable((String)key);
    }

    @Override
    @NotNull
    public Component newKeybindComponent(@NotNull String keybind) {
        return Component.keybind((String)keybind);
    }

    @Override
    @NotNull
    public Component newObjectComponent(@NotNull TabAtlasSprite sprite) {
        return Component.object((ObjectInfo)new AtlasSprite(Identifier.parse((String)sprite.getAtlas()), Identifier.parse((String)sprite.getSprite())));
    }

    @Override
    @NotNull
    public Component newObjectComponent(@NotNull TabPlayerSprite sprite) {
        ResolvableProfile profile;
        if (sprite.getId() != null) {
            profile = ResolvableProfile.createUnresolved((UUID)sprite.getId());
        } else if (sprite.getName() != null) {
            profile = ResolvableProfile.createUnresolved((String)sprite.getName());
        } else if (sprite.getSkin() != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)"textures", (Object)new Property("textures", sprite.getSkin().getValue(), sprite.getSkin().getSignature()));
            profile = ResolvableProfile.createResolved((GameProfile)new GameProfile(this.NIL_UUID, "", new PropertyMap((Multimap)builder.build())));
        } else {
            throw new IllegalStateException("Player head component does not have id, name or skin set");
        }
        return Component.object((ObjectInfo)new PlayerSprite(profile, sprite.isShowHat()));
    }

    @Override
    public void applyStyle(@NotNull Component nmsComponent, @NotNull TabStyle modifier) {
        Style style = Style.EMPTY.withColor(modifier.getColor() == null ? null : TextColor.fromRgb((int)modifier.getColor().getRgb())).withBold(modifier.getBold()).withItalic(modifier.getItalic()).withUnderlined(modifier.getUnderlined()).withStrikethrough(modifier.getStrikethrough()).withObfuscated(modifier.getObfuscated()).withFont((FontDescription)(modifier.getFont() == null ? null : new FontDescription.Resource(Identifier.parse((String)modifier.getFont()))));
        if (modifier.getShadowColor() != null) {
            style = style.withShadowColor(modifier.getShadowColor().intValue());
        }
        ((MutableComponent)nmsComponent).setStyle(style);
    }

    @Override
    public void addSibling(@NotNull Component parent, @NotNull Component child) {
        ((MutableComponent)parent).append(child);
    }
}

