/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.neoforge;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.neoforge.NeoForgeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeTabList
extends TrackedTabList<NeoForgeTabPlayer> {
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> addPlayer = EnumSet.allOf(ClientboundPlayerInfoUpdatePacket.Action.class);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateDisplayName = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateLatency = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateGameMode = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateListed = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateListOrder = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateHat = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_HAT);
    private static final Field entries = ReflectionUtils.getOnlyField(ClientboundPlayerInfoUpdatePacket.class, List.class);

    public NeoForgeTabList(@NotNull NeoForgeTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoRemovePacket(Collections.singletonList(entry)));
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable TabComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateDisplayName, entry, "", null, false, 0, 0, displayName, 0, false);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateLatency, entry, "", null, false, latency, 0, null, 0, false);
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateGameMode, entry, "", null, false, 0, gameMode, null, 0, false);
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateListed, entry, "", null, listed, 0, 0, null, 0, false);
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateListOrder, entry, "", null, false, 0, 0, null, listOrder, false);
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(updateHat, entry, "", null, false, 0, 0, null, 0, showHat);
    }

    @Override
    public void addEntry0(@NonNull TabList.Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket(addPlayer, entry.getUniqueId(), entry.getName(), entry.getSkin(), entry.isListed(), entry.getLatency(), entry.getGameMode(), entry.getDisplayName(), entry.getListOrder(), entry.isShowHat());
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundTabListPacket((Component)header.convert(), (Component)footer.convert()));
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return true;
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        Collection properties = ((NeoForgeTabPlayer)this.player).getPlayer().getGameProfile().properties().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        Property property = (Property)properties.iterator().next();
        return new TabList.Skin(property.value(), property.signature());
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof ClientboundTabListPacket) {
            ClientboundTabListPacket tablist = (ClientboundTabListPacket)packet;
            if (this.header == null || this.footer == null) {
                return packet;
            }
            if (tablist.header() != this.header.convert() || tablist.footer() != this.footer.convert()) {
                return new ClientboundTabListPacket((Component)this.header.convert(), (Component)this.footer.convert());
            }
        }
        if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket info = (ClientboundPlayerInfoUpdatePacket)packet;
            EnumSet actions = info.actions();
            ArrayList<ClientboundPlayerInfoUpdatePacket.Entry> updatedList = new ArrayList<ClientboundPlayerInfoUpdatePacket.Entry>();
            boolean rewritePacket = false;
            for (ClientboundPlayerInfoUpdatePacket.Entry nmsData : info.entries()) {
                TabComponent forcedDisplayName;
                boolean rewriteEntry = false;
                Component displayName = nmsData.displayName();
                int gameMode = nmsData.gameMode().getId();
                int latency = nmsData.latency();
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME) && (forcedDisplayName = this.getForcedDisplayNames().get(nmsData.profileId())) != null && forcedDisplayName.convert() != displayName) {
                    displayName = (Component)forcedDisplayName.convert();
                    rewritePacket = true;
                    rewriteEntry = true;
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE) && this.getBlockedSpectators().contains(nmsData.profileId()) && gameMode == 3) {
                    gameMode = 0;
                    rewritePacket = true;
                    rewriteEntry = true;
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY) && NeoForgeTabList.getForcedLatency() != null) {
                    latency = NeoForgeTabList.getForcedLatency();
                    rewritePacket = true;
                    rewriteEntry = true;
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER)) {
                    TAB.getInstance().getFeatureManager().onEntryAdd(this.player, nmsData.profileId(), nmsData.profile().name());
                }
                updatedList.add(rewriteEntry ? new ClientboundPlayerInfoUpdatePacket.Entry(nmsData.profileId(), nmsData.profile(), nmsData.listed(), latency, GameType.byId((int)gameMode), displayName, nmsData.showHat(), nmsData.listOrder(), nmsData.chatSession()) : nmsData);
            }
            if (rewritePacket) {
                ClientboundPlayerInfoUpdatePacket newPacket = new ClientboundPlayerInfoUpdatePacket(actions, Collections.emptyList());
                entries.set(newPacket, updatedList);
                return newPacket;
            }
        }
        return packet;
    }

    private void sendPacket(@NonNull EnumSet<ClientboundPlayerInfoUpdatePacket.Action> action, @NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable TabComponent displayName, int listOrder, boolean showHat) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        ClientboundPlayerInfoUpdatePacket packet = new ClientboundPlayerInfoUpdatePacket(action, Collections.emptyList());
        entries.set(packet, Collections.singletonList(new ClientboundPlayerInfoUpdatePacket.Entry(id, action.contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER) ? this.createProfile(id, name, skin) : null, listed, latency, GameType.byId((int)gameMode), displayName == null ? null : (Component)displayName.convert(), showHat, listOrder, null)));
        this.sendPacket((Packet<?>)packet);
    }

    @NotNull
    private GameProfile createProfile(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (skin != null) {
            builder.put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return new GameProfile(id, name, new PropertyMap((Multimap)builder.build()));
    }

    private void sendPacket(@NotNull Packet<?> packet) {
        ((NeoForgeTabPlayer)this.player).getPlayer().connection.send(packet);
    }
}

