/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.forge;

import java.util.Collections;
import java.util.List;
import me.neznamy.tab.platforms.forge.ForgeCommand;
import me.neznamy.tab.platforms.forge.hook.LuckPermsAPIHook;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ForgeTabCommand
extends ForgeCommand {
    public ForgeTabCommand(@NotNull String commandName) {
        super(commandName);
    }

    @Override
    public int execute(@NotNull CommandSourceStack source, @NotNull String[] args) {
        if (TAB.getInstance().isPluginDisabled()) {
            boolean hasReloadPermission = LuckPermsAPIHook.hasPermission(source, "tab.reload");
            boolean hasAdminPermission = LuckPermsAPIHook.hasPermission(source, "tab.admin");
            for (String message : TAB.getInstance().getDisabledCommand().execute(args, hasReloadPermission, hasAdminPermission)) {
                source.sendSystemMessage((Component)TabComponent.fromColoredText(message).convert());
            }
        } else if (source.getEntity() == null) {
            TAB.getInstance().getCommand().execute(null, args);
        } else {
            TabPlayer player = TAB.getInstance().getPlayer(source.getEntity().getUUID());
            if (player != null) {
                TAB.getInstance().getCommand().execute(player, args);
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public List<String> complete(@NotNull CommandSourceStack sender, @NotNull String[] args) {
        TabPlayer player = null;
        if (sender.getEntity() != null && (player = TAB.getInstance().getPlayer(sender.getEntity().getUUID())) == null) {
            return Collections.emptyList();
        }
        return TAB.getInstance().getCommand().complete(player, args);
    }
}

