/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.platform.TabList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeeTabList17
extends BungeeTabList {
    @NotNull
    private final Map<UUID, String> userNames = new HashMap<UUID, String>();
    @NotNull
    private final Map<UUID, TabComponent> displayNames = new HashMap<UUID, TabComponent>();

    public BungeeTabList17(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.removeUuid(entry);
        this.update(PlayerListItem.Action.REMOVE_PLAYER, this.createItem(null, this.displayNames.get(entry), 0));
        this.userNames.remove(entry);
        this.displayNames.remove(entry);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable TabComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.update(PlayerListItem.Action.REMOVE_PLAYER, this.createItem(null, this.displayNames.get(entry), 0));
        this.addEntry0(new TabList.Entry(entry, this.userNames.get(entry), null, false, 0, 0, displayName, 0, false));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.update(PlayerListItem.Action.UPDATE_LATENCY, this.createItem(null, this.displayNames.get(entry), latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry0(@NonNull TabList.Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.addUuid(entry.getUniqueId());
        this.update(PlayerListItem.Action.ADD_PLAYER, this.createItem(entry.getName(), entry.getDisplayName() == null ? new TabTextComponent(entry.getName()) : entry.getDisplayName(), entry.getLatency()));
        this.userNames.put(entry.getUniqueId(), entry.getName());
        this.displayNames.put(entry.getUniqueId(), entry.getDisplayName());
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
    }

    @Override
    @NotNull
    public BaseComponent toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        String displayNameString = component.toLegacyText();
        if (displayNameString.length() > 16) {
            displayNameString = displayNameString.substring(0, 16);
        }
        return ((BungeeTabPlayer)this.player).getPlatform().transformComponent(new TabTextComponent(displayNameString), ((BungeeTabPlayer)this.player).getVersion());
    }

    private void update(@NonNull PlayerListItem.Action action, @NonNull PlayerListItem.Item item) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PlayerListItem packet = new PlayerListItem();
        packet.setAction(action);
        packet.setItems(new PlayerListItem.Item[]{item});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)packet);
    }

    @NotNull
    private PlayerListItem.Item createItem(@Nullable String username, @Nullable TabComponent displayName, int latency) {
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUsername(username);
        item.setPing(Integer.valueOf(latency));
        if (displayName != null) {
            item.setDisplayName(this.toComponent(displayName));
        }
        return item;
    }
}

