/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.Collection;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.data.Property;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.tab.ServerUnique;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BungeeTabList
extends TrackedTabList<BungeeTabPlayer> {
    private final Collection<UUID> uuids;

    protected BungeeTabList(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.uuids = (Collection)ReflectionUtils.getField(ServerUnique.class, "uuids").get(((UserConnection)player.getPlayer()).getTabListHandler());
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).getPlayer().setTabHeader(this.toComponent(header), this.toComponent(footer));
    }

    @NotNull
    public PlayerListItem.Item item(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUuid(id);
        return item;
    }

    @NotNull
    public PlayerListItem.Item entryToItem(@NonNull TabList.Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry.getUniqueId());
        item.setUsername(entry.getName());
        item.setDisplayName(entry.getDisplayName() == null ? null : this.toComponent(entry.getDisplayName()));
        item.setGamemode(Integer.valueOf(entry.getGameMode()));
        item.setListed(Boolean.valueOf(entry.isListed()));
        item.setPing(Integer.valueOf(entry.getLatency()));
        if (entry.getSkin() != null) {
            item.setProperties(new Property[]{new Property("textures", entry.getSkin().getValue(), entry.getSkin().getSignature())});
        } else {
            item.setProperties(new Property[0]);
        }
        item.setListOrder(Integer.valueOf(entry.getListOrder()));
        item.setShowHat(Boolean.valueOf(entry.isShowHat()));
        return item;
    }

    public void addUuid(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.uuids.add(id);
    }

    public void removeUuid(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.uuids.remove(id);
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        block13: {
            block12: {
                if (packet == null) {
                    throw new NullPointerException("packet is marked non-null but is null");
                }
                if (packet instanceof PlayerListHeaderFooter) {
                    PlayerListHeaderFooter tablist = (PlayerListHeaderFooter)packet;
                    if (this.header == null || this.footer == null) {
                        return packet;
                    }
                    BaseComponent headerComponent = ((BungeeTabPlayer)this.player).getPlatform().transformComponent(this.header, ((BungeeTabPlayer)this.player).getVersion());
                    BaseComponent footerComponent = ((BungeeTabPlayer)this.player).getPlatform().transformComponent(this.footer, ((BungeeTabPlayer)this.player).getVersion());
                    if (tablist.getHeader() != headerComponent || tablist.getFooter() != footerComponent) {
                        tablist.setHeader(headerComponent);
                        tablist.setFooter(footerComponent);
                    }
                }
                if (!(packet instanceof PlayerListItem)) break block12;
                PlayerListItem listItem = (PlayerListItem)packet;
                for (PlayerListItem.Item item : listItem.getItems()) {
                    TabComponent forcedDisplayName;
                    if ((listItem.getAction() == PlayerListItem.Action.UPDATE_DISPLAY_NAME || listItem.getAction() == PlayerListItem.Action.ADD_PLAYER) && (forcedDisplayName = this.getForcedDisplayNames().get(item.getUuid())) != null) {
                        item.setDisplayName(this.toComponent(forcedDisplayName));
                    }
                    if ((listItem.getAction() == PlayerListItem.Action.UPDATE_GAMEMODE || listItem.getAction() == PlayerListItem.Action.ADD_PLAYER) && this.getBlockedSpectators().contains(item.getUuid()) && item.getGamemode() == 3) {
                        item.setGamemode(Integer.valueOf(0));
                    }
                    if ((listItem.getAction() == PlayerListItem.Action.UPDATE_LATENCY || listItem.getAction() == PlayerListItem.Action.ADD_PLAYER) && BungeeTabList.getForcedLatency() != null) {
                        item.setPing(BungeeTabList.getForcedLatency());
                    }
                    if (listItem.getAction() != PlayerListItem.Action.ADD_PLAYER) continue;
                    TAB.getInstance().getFeatureManager().onEntryAdd(this.player, item.getUuid(), item.getUsername());
                }
                break block13;
            }
            if (!(packet instanceof PlayerListItemUpdate)) break block13;
            PlayerListItemUpdate update = (PlayerListItemUpdate)packet;
            for (PlayerListItem.Item item : update.getItems()) {
                TabComponent forcedDisplayName;
                if (update.getActions().contains(PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME) && (forcedDisplayName = this.getForcedDisplayNames().get(item.getUuid())) != null) {
                    item.setDisplayName(this.toComponent(forcedDisplayName));
                }
                if (update.getActions().contains(PlayerListItemUpdate.Action.UPDATE_GAMEMODE) && this.getBlockedSpectators().contains(item.getUuid()) && item.getGamemode() == 3) {
                    item.setGamemode(Integer.valueOf(0));
                }
                if (update.getActions().contains(PlayerListItemUpdate.Action.UPDATE_LATENCY) && BungeeTabList.getForcedLatency() != null) {
                    item.setPing(BungeeTabList.getForcedLatency());
                }
                if (!update.getActions().contains(PlayerListItemUpdate.Action.ADD_PLAYER)) continue;
                TAB.getInstance().getFeatureManager().onEntryAdd(this.player, item.getUuid(), item.getUsername());
            }
        }
        return packet;
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.uuids.contains(entry);
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        LoginResult loginResult = ((InitialHandler)((BungeeTabPlayer)this.player).getPlayer().getPendingConnection()).getLoginProfile();
        if (loginResult == null) {
            return null;
        }
        Property[] properties = loginResult.getProperties();
        if (properties == null) {
            return null;
        }
        for (Property property : properties) {
            if (!property.getName().equals("textures")) continue;
            return new TabList.Skin(property.getValue(), property.getSignature());
        }
        return null;
    }

    @NotNull
    protected BaseComponent toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return ((BungeeTabPlayer)this.player).getPlatform().transformComponent(component, ((BungeeTabPlayer)this.player).getVersion());
    }
}

