/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import me.neznamy.tab.libs.org.bstats.bungeecord.Metrics;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.bungeecord.BungeeBossBar;
import me.neznamy.tab.platforms.bungeecord.BungeeEventListener;
import me.neznamy.tab.platforms.bungeecord.BungeeScoreboard;
import me.neznamy.tab.platforms.bungeecord.BungeeTAB;
import me.neznamy.tab.platforms.bungeecord.BungeeTabCommand;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.features.BungeeRedisSupport;
import me.neznamy.tab.platforms.bungeecord.hook.BungeePremiumVanishHook;
import me.neznamy.tab.platforms.bungeecord.injection.BungeePipelineInjector;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList1193;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList17;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList18;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabStyle;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.chat.component.TabKeybindComponent;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.chat.component.TabTranslatableComponent;
import me.neznamy.tab.shared.chat.component.object.ObjectInfo;
import me.neznamy.tab.shared.chat.component.object.TabAtlasSprite;
import me.neznamy.tab.shared.chat.component.object.TabObjectComponent;
import me.neznamy.tab.shared.chat.component.object.TabPlayerSprite;
import me.neznamy.tab.shared.data.Server;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.proxy.ProxyPlayer;
import me.neznamy.tab.shared.features.proxy.ProxySupport;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.impl.DummyBossBar;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.util.PerformanceUtil;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ObjectComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.objects.ChatObject;
import net.md_5.bungee.api.chat.objects.PlayerObject;
import net.md_5.bungee.api.chat.objects.SpriteObject;
import net.md_5.bungee.api.chat.player.Profile;
import net.md_5.bungee.api.chat.player.Property;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeePlatform
extends ProxyPlatform {
    @NotNull
    private final BungeeTAB plugin;
    private final List<Command> customCommands = new ArrayList<Command>();

    public BungeePlatform(@NotNull BungeeTAB plugin) {
        this.plugin = plugin;
        if (ProxyServer.getInstance().getPluginManager().getPlugin("PremiumVanish") != null) {
            new BungeePremiumVanishHook(this).register();
        }
    }

    @Override
    public void loadPlayers() {
        for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
            TAB.getInstance().addPlayer(new BungeeTabPlayer(this, p));
        }
    }

    @Override
    public void registerPlaceholders() {
        super.registerPlaceholders();
        for (String serverName : ProxyServer.getInstance().getConfig().getServers().keySet()) {
            Server server = Server.byName(serverName);
            TAB.getInstance().getPlaceholderManager().registerInternalServerPlaceholder("%online_" + serverName + "%", 1000, () -> {
                int count = 0;
                for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                    if (player.server != server || player.isVanished()) continue;
                    ++count;
                }
                ProxySupport proxySupport = (ProxySupport)TAB.getInstance().getFeatureManager().getFeature("ProxySupport");
                if (proxySupport != null) {
                    for (ProxyPlayer player : proxySupport.getProxyPlayers().values()) {
                        if (player.server != server || player.isVanished()) continue;
                        ++count;
                    }
                }
                return PerformanceUtil.toString(count);
            });
        }
    }

    @Override
    @Nullable
    public ProxySupport getProxySupport(@NotNull String plugin) {
        if (plugin.equalsIgnoreCase("RedisBungee") && ReflectionUtils.classExists("com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI") && RedisBungeeAPI.getRedisBungeeApi() != null) {
            return new BungeeRedisSupport(this.plugin);
        }
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        this.plugin.getLogger().info(message.toLegacyText());
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        this.plugin.getLogger().warning("\u00a7c" + message.toLegacyText());
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[BungeeCord] " + this.plugin.getProxy().getName() + " - " + this.plugin.getProxy().getVersion();
    }

    @Override
    public void registerListener() {
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)this.plugin, (Listener)new BungeeEventListener());
    }

    @Override
    public void registerCommand() {
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this.plugin, (Command)new BungeeTabCommand(this.getCommand()));
    }

    @Override
    public void startMetrics() {
        new Metrics(this.plugin, 10535).addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return new BungeePipelineInjector();
    }

    @Override
    public void registerChannel() {
        ProxyServer.getInstance().registerChannel("tab:bridge-6");
    }

    @NotNull
    public @NotNull BaseComponent @NotNull [] convertComponent(@NotNull TabComponent component) {
        return new BaseComponent[]{this.createComponent(component, ProtocolVersion.V1_21_9), this.createComponent(component, ProtocolVersion.V1_16), this.createComponent(component, ProtocolVersion.V1_8)};
    }

    @NotNull
    public BaseComponent transformComponent(@NotNull TabComponent component, @NotNull ProtocolVersion version) {
        return this.pickCorrectComponent((BaseComponent[])component.convert(), version);
    }

    @NotNull
    public BaseComponent pickCorrectComponent(@NotNull BaseComponent[] components, @NotNull ProtocolVersion version) {
        if (version.getNetworkId() >= ProtocolVersion.V1_21_9.getNetworkId()) {
            return components[0];
        }
        if (version.getNetworkId() >= ProtocolVersion.V1_16.getNetworkId()) {
            return components[1];
        }
        return components[2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BaseComponent createComponent(@NotNull TabComponent component, @NotNull ProtocolVersion version) {
        TextComponent bComponent;
        if (component instanceof TabTextComponent) {
            bComponent = new TextComponent(((TabTextComponent)component).getText());
        } else if (component instanceof TabTranslatableComponent) {
            bComponent = new TranslatableComponent(((TabTranslatableComponent)component).getKey(), new Object[0]);
        } else if (component instanceof TabKeybindComponent) {
            bComponent = new KeybindComponent(((TabKeybindComponent)component).getKeybind());
        } else {
            if (!(component instanceof TabObjectComponent)) throw new IllegalStateException("Unexpected component type: " + component.getClass().getName());
            if (version.getNetworkId() >= ProtocolVersion.V1_21_9.getNetworkId()) {
                ObjectInfo info = ((TabObjectComponent)component).getContents();
                if (info instanceof TabAtlasSprite) {
                    bComponent = new ObjectComponent((ChatObject)new SpriteObject(((TabAtlasSprite)info).getAtlas(), ((TabAtlasSprite)info).getSprite()));
                } else {
                    Property[] propertyArray;
                    if (!(info instanceof TabPlayerSprite)) throw new IllegalStateException("Unexpected object component type: " + info.getClass().getName());
                    String string = ((TabPlayerSprite)info).getName();
                    UUID uUID = ((TabPlayerSprite)info).getId();
                    if (((TabPlayerSprite)info).getSkin() == null) {
                        propertyArray = new Property[]{};
                    } else {
                        Property[] propertyArray2 = new Property[1];
                        propertyArray = propertyArray2;
                        propertyArray2[0] = new Property("textures", ((TabPlayerSprite)info).getSkin().getValue(), ((TabPlayerSprite)info).getSkin().getSignature());
                    }
                    bComponent = new ObjectComponent((ChatObject)new PlayerObject(new Profile(string, uUID, propertyArray), Boolean.valueOf(((TabPlayerSprite)info).isShowHat())));
                }
            } else {
                bComponent = new TextComponent(component.toLegacyText());
            }
        }
        TabStyle modifier = component.getModifier();
        if (modifier.getColor() != null) {
            if (version.getMinorVersion() >= 16) {
                bComponent.setColor(ChatColor.of((String)("#" + modifier.getColor().getHexCode())));
            } else {
                bComponent.setColor(ChatColor.of((String)modifier.getColor().getLegacyColor().name()));
            }
        }
        bComponent.setShadowColor(modifier.getShadowColor() == null ? null : new Color(modifier.getShadowColor() >> 16 & 0xFF, modifier.getShadowColor() >> 8 & 0xFF, (int)(modifier.getShadowColor() & 0xFF), modifier.getShadowColor() >> 24 & 0xFF));
        bComponent.setBold(modifier.getBold());
        bComponent.setItalic(modifier.getItalic());
        bComponent.setObfuscated(modifier.getObfuscated());
        bComponent.setStrikethrough(modifier.getStrikethrough());
        bComponent.setUnderlined(modifier.getUnderlined());
        bComponent.setFont(modifier.getFont());
        for (TabComponent extra : component.getExtra()) {
            bComponent.addExtra(this.createComponent(extra, version));
        }
        return bComponent;
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new BungeeScoreboard((BungeeTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        if (player.getVersion().getMinorVersion() >= 9) {
            return new BungeeBossBar((BungeeTabPlayer)player);
        }
        return new DummyBossBar();
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        if (player.getVersionId() >= ProtocolVersion.V1_19_3.getNetworkId()) {
            return new BungeeTabList1193((BungeeTabPlayer)player);
        }
        if (player.getVersionId() >= ProtocolVersion.V1_8.getNetworkId()) {
            return new BungeeTabList18((BungeeTabPlayer)player);
        }
        return new BungeeTabList17((BungeeTabPlayer)player);
    }

    @Override
    public boolean supportsScoreboards() {
        return true;
    }

    @Override
    @NotNull
    public String getCommand() {
        return "btab";
    }

    @Override
    public void registerCustomCommand(@NotNull String commandName, final @NotNull Consumer<TabPlayer> function) {
        Command cmd = new Command(commandName){

            public void execute(CommandSender commandSender, String[] strings) {
                if (commandSender instanceof ConsoleCommandSender) {
                    commandSender.sendMessage(BungeePlatform.this.createComponent(TabComponent.fromColoredText(TAB.getInstance().getConfiguration().getMessages().getCommandOnlyFromGame()), ProtocolVersion.values()[1]));
                    return;
                }
                TabPlayer p = TAB.getInstance().getPlayer(((ProxiedPlayer)commandSender).getUniqueId());
                if (p == null) {
                    return;
                }
                function.accept(p);
            }
        };
        this.customCommands.add(cmd);
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this.plugin, cmd);
    }

    @Override
    public void unregisterAllCustomCommands() {
        for (Command cmd : this.customCommands) {
            ProxyServer.getInstance().getPluginManager().unregisterCommand(cmd);
        }
    }
}

