/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.v1_7_R3;

import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import net.minecraft.server.v1_7_R3.IScoreboardCriteria;
import net.minecraft.server.v1_7_R3.Packet;
import net.minecraft.server.v1_7_R3.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_7_R3.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_7_R3.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_7_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_7_R3.Scoreboard;
import net.minecraft.server.v1_7_R3.ScoreboardObjective;
import net.minecraft.server.v1_7_R3.ScoreboardScore;
import net.minecraft.server.v1_7_R3.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_7_R3.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;

public class NMSPacketScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static final Scoreboard dummyScoreboard = new Scoreboard();

    public NMSPacketScoreboard(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = new ScoreboardObjective(dummyScoreboard, objective.getName(), IScoreboardCriteria.b);
        obj.setDisplayName(this.maybeCut(objective.getTitle().toLegacyText(), 32));
        objective.setPlatformObjective(obj);
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective(obj, 0));
    }

    @Override
    public void setDisplaySlot(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardDisplayObjective(objective.getDisplaySlot().ordinal(), (ScoreboardObjective)objective.getPlatformObjective()));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective.getPlatformObjective(), 1));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = (ScoreboardObjective)objective.getPlatformObjective();
        obj.setDisplayName(this.maybeCut(objective.getTitle().toLegacyText(), 32));
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective(obj, 2));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        ScoreboardScore s = new ScoreboardScore(dummyScoreboard, (ScoreboardObjective)score.getObjective().getPlatformObjective(), score.getHolder());
        s.setScore(score.getValue());
        this.sendPacket((Packet)new PacketPlayOutScoreboardScore(s, 0));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardScore(score.getHolder()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new ScoreboardTeam(dummyScoreboard, name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.getPlayerNameSet().addAll(team.getPlayers());
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam(t, 0));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam((ScoreboardTeam)team.getPlatformTeam(), 1));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam((ScoreboardTeam)team.getPlatformTeam(), 2));
    }

    private void updateTeamProperties(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        t.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        t.setPrefix(this.maybeCut(team.getPrefix().toLegacyText(), 16));
        t.setSuffix(this.maybeCut(team.getSuffix().toLegacyText(), 16));
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return packet;
    }

    private void sendPacket(@NotNull Packet packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().playerConnection.sendPacket(packet);
    }

    @NotNull
    private String maybeCut(@NonNull String string, int length) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (((BukkitTabPlayer)this.player).getVersion().getMinorVersion() < 13 || TAB.getInstance().getConfiguration().getConfig().isPacketEventsCompensation()) {
            return NMSPacketScoreboard.cutTo(string, length);
        }
        return string;
    }
}

