/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.v1_18_R2;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;

public class NMSPacketScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static final ScoreboardTeamBase.EnumNameTagVisibility[] visibilities = ScoreboardTeamBase.EnumNameTagVisibility.values();
    private static final ScoreboardTeamBase.EnumTeamPush[] collisions = ScoreboardTeamBase.EnumTeamPush.values();
    private static final Scoreboard dummyScoreboard = new Scoreboard();
    private static final Field TeamPacket_PLAYERS = ReflectionUtils.getOnlyField(PacketPlayOutScoreboardTeam.class, Collection.class);

    public NMSPacketScoreboard(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = new ScoreboardObjective(dummyScoreboard, objective.getName(), IScoreboardCriteria.a, (IChatBaseComponent)objective.getTitle().convert(), IScoreboardCriteria.EnumScoreboardHealthDisplay.values()[objective.getHealthDisplay().ordinal()]);
        objective.setPlatformObjective(obj);
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardObjective(obj, 0));
    }

    @Override
    public void setDisplaySlot(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardDisplayObjective(objective.getDisplaySlot().ordinal(), (ScoreboardObjective)objective.getPlatformObjective()));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective.getPlatformObjective(), 1));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = (ScoreboardObjective)objective.getPlatformObjective();
        obj.a((IChatBaseComponent)objective.getTitle().convert());
        obj.a(IScoreboardCriteria.EnumScoreboardHealthDisplay.valueOf((String)objective.getHealthDisplay().name()));
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardObjective(obj, 2));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, score.getObjective().getName(), score.getHolder(), score.getValue()));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, score.getObjective().getName(), score.getHolder(), score.getValue()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new ScoreboardTeam(dummyScoreboard, name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.g().addAll(team.getPlayers());
        this.sendPacket((Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)t, (boolean)true));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)((ScoreboardTeam)team.getPlatformTeam())));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        this.sendPacket((Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)((ScoreboardTeam)team.getPlatformTeam()), (boolean)false));
    }

    private void updateTeamProperties(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.a((team.getOptions() & 1) != 0);
        t.b((team.getOptions() & 2) != 0);
        t.a(visibilities[team.getVisibility().ordinal()]);
        t.a(collisions[team.getCollision().ordinal()]);
        t.b((IChatBaseComponent)team.getPrefix().convert());
        t.c((IChatBaseComponent)team.getSuffix().convert());
        t.a(EnumChatFormat.valueOf((String)team.getColor().name()));
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        int action;
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof PacketPlayOutScoreboardDisplayObjective) {
            TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, ((PacketPlayOutScoreboardDisplayObjective)packet).b(), ((PacketPlayOutScoreboardDisplayObjective)packet).c());
        }
        if (packet instanceof PacketPlayOutScoreboardObjective) {
            TAB.getInstance().getFeatureManager().onObjective(this.player, ((PacketPlayOutScoreboardObjective)packet).d(), ((PacketPlayOutScoreboardObjective)packet).b());
        }
        if (packet instanceof PacketPlayOutScoreboardTeam && (action = this.getMethod((PacketPlayOutScoreboardTeam)packet)) != 2) {
            List<String> players = ((PacketPlayOutScoreboardTeam)packet).e();
            if (players == null) {
                players = Collections.emptyList();
            }
            TeamPacket_PLAYERS.set(packet, this.onTeamPacket(action, ((PacketPlayOutScoreboardTeam)packet).d(), players));
        }
        return packet;
    }

    private int getMethod(@NonNull PacketPlayOutScoreboardTeam team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (team.c() == PacketPlayOutScoreboardTeam.a.a) {
            return 0;
        }
        if (team.c() == PacketPlayOutScoreboardTeam.a.b) {
            return 1;
        }
        if (team.b() == PacketPlayOutScoreboardTeam.a.a) {
            return 3;
        }
        if (team.b() == PacketPlayOutScoreboardTeam.a.b) {
            return 4;
        }
        return 2;
    }

    private void sendPacket(@NotNull Packet<?> packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().b.a(packet);
    }
}

