/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import java.util.List;
import java.util.Map;
import me.neznamy.tab.platforms.bukkit.platform.BukkitPlatform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PerWorldPlayerList
extends TabFeature
implements Listener,
Loadable,
UnLoadable {
    @NotNull
    private final BukkitPlatform platform;
    @NotNull
    private final PerWorldPlayerListConfiguration configuration;

    public PerWorldPlayerList(@NotNull JavaPlugin plugin, @NotNull BukkitPlatform platform, @NotNull PerWorldPlayerListConfiguration configuration) {
        this.configuration = configuration;
        this.platform = platform;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void load() {
        for (Player player : this.platform.getOnlinePlayers()) {
            this.checkPlayer(player);
        }
    }

    @Override
    public void unload() {
        for (Player player : this.platform.getOnlinePlayers()) {
            for (Player player2 : this.platform.getOnlinePlayers()) {
                player.showPlayer(player2);
            }
        }
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        long time = System.nanoTime();
        this.checkPlayer(e.getPlayer());
        TAB.getInstance().getCPUManager().addTime(this.getFeatureName(), "Player Join", System.nanoTime() - time);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        long time = System.nanoTime();
        this.checkPlayer(e.getPlayer());
        TAB.getInstance().getCPUManager().addTime(this.getFeatureName(), "World Switch", System.nanoTime() - time);
    }

    private void checkPlayer(@NotNull Player p) {
        for (Player player : this.platform.getOnlinePlayers()) {
            if (player == p) continue;
            if (!this.shouldSee(p, player) && p.canSee(player)) {
                p.hidePlayer(player);
            }
            if (this.shouldSee(p, player) && !p.canSee(player)) {
                p.showPlayer(player);
            }
            if (!this.shouldSee(player, p) && player.canSee(p)) {
                player.hidePlayer(p);
            }
            if (!this.shouldSee(player, p) || player.canSee(p)) continue;
            player.showPlayer(p);
        }
    }

    private boolean shouldSee(@NotNull Player viewer, @NotNull Player target) {
        if (target == viewer) {
            return true;
        }
        if (this.configuration.isAllowBypassPermission() && viewer.hasPermission("tab.bypass") || this.configuration.getIgnoredWorlds().contains(viewer.getWorld().getName())) {
            return true;
        }
        String viewerWorldGroup = viewer.getWorld().getName() + "-default";
        String targetWorldGroup = target.getWorld().getName() + "-default";
        for (Map.Entry<String, List<String>> group : this.configuration.getSharedWorlds().entrySet()) {
            if (group.getValue() == null) continue;
            if (group.getValue().contains(viewer.getWorld().getName())) {
                viewerWorldGroup = group.getKey();
            }
            if (!group.getValue().contains(target.getWorld().getName())) continue;
            targetWorldGroup = group.getKey();
        }
        return viewerWorldGroup.equals(targetWorldGroup);
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Per world PlayerList";
    }
}

