/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.redis.clients.jedis.args;

import java.util.Arrays;
import me.neznamy.tab.libs.redis.clients.jedis.Protocol;
import me.neznamy.tab.libs.redis.clients.jedis.args.Rawable;
import me.neznamy.tab.libs.redis.clients.jedis.util.SafeEncoder;

public final class RawableFactory {
    public static Rawable from(boolean b) {
        return RawableFactory.from(Protocol.toByteArray(b));
    }

    public static Rawable from(int i) {
        return RawableFactory.from(Protocol.toByteArray(i));
    }

    public static Rawable from(long l) {
        return RawableFactory.from(Protocol.toByteArray(l));
    }

    public static Rawable from(double d) {
        return RawableFactory.from(Protocol.toByteArray(d));
    }

    public static Rawable from(byte[] binary) {
        return new Raw(binary);
    }

    public static Rawable from(String string) {
        return new RawString(string);
    }

    private RawableFactory() {
        throw new InstantiationError();
    }

    public static class RawString
    extends Raw {
        public RawString(String str) {
            super(SafeEncoder.encode(str));
        }
    }

    public static class Raw
    implements Rawable {
        private final byte[] raw;

        public Raw(byte[] raw) {
            this.raw = Arrays.copyOf(raw, raw.length);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.raw, ((Raw)o).raw);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.raw);
        }
    }
}

