/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.saicone.delivery4j.util;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public interface DelayedExecutor<T> {
    public static final DelayedExecutor<Thread> JAVA = new DelayedExecutor<Thread>(){

        @Override
        @NotNull
        public Thread execute(@NotNull Runnable command) {
            Thread thread = new Thread(command);
            thread.start();
            return thread;
        }

        @Override
        @NotNull
        public Thread execute(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(unit.toMillis(delay));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!Thread.interrupted()) {
                    command.run();
                }
            });
            thread.start();
            return thread;
        }

        @Override
        @NotNull
        public Thread execute(@NotNull Runnable command, long delay, long period, @NotNull TimeUnit unit) {
            Thread thread = new Thread(() -> {
                if (delay > 0L) {
                    try {
                        Thread.sleep(unit.toMillis(delay));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                while (!Thread.interrupted()) {
                    command.run();
                    try {
                        Thread.sleep(unit.toMillis(period));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            thread.start();
            return thread;
        }

        @Override
        public void cancel(@NotNull Thread thread) {
            thread.interrupt();
        }
    };

    @NotNull
    public T execute(@NotNull Runnable var1);

    @NotNull
    public T execute(@NotNull Runnable var1, long var2, @NotNull TimeUnit var4);

    @NotNull
    public T execute(@NotNull Runnable var1, long var2, long var4, @NotNull TimeUnit var6);

    public void cancel(@NotNull T var1);

    @NotNull
    default public Executor asExecutor() {
        return this::execute;
    }
}

