/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.saicone.delivery4j;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import me.neznamy.tab.libs.com.saicone.delivery4j.ChannelConsumer;
import me.neznamy.tab.libs.com.saicone.delivery4j.util.ByteCodec;
import me.neznamy.tab.libs.com.saicone.delivery4j.util.DelayedExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class Broker {
    private ChannelConsumer<byte[]> consumer = (channel, data) -> {};
    private ByteCodec<String> codec = ByteCodec.BASE64;
    private DelayedExecutor<?> executor = DelayedExecutor.JAVA;
    private Logger logger = Logger.of(this.getClass());
    private final Set<String> subscribedChannels = new HashSet<String>();
    private boolean enabled = false;

    protected void onStart() {
    }

    protected void onClose() {
    }

    protected void onSubscribe(String ... channels) {
    }

    protected void onUnsubscribe(String ... channels) {
    }

    protected abstract void onSend(@NotNull String var1, byte[] var2) throws IOException;

    protected void onReceive(@NotNull String channel, byte[] data) throws IOException {
    }

    @NotNull
    public ChannelConsumer<byte[]> getConsumer() {
        return this.consumer;
    }

    @NotNull
    public ByteCodec<String> getCodec() {
        return this.codec;
    }

    @NotNull
    public DelayedExecutor<Object> getExecutor() {
        return this.executor;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Set<String> getSubscribedChannels() {
        return this.subscribedChannels;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setConsumer(@NotNull ChannelConsumer<byte[]> consumer) {
        this.consumer = consumer;
    }

    public void setCodec(@NotNull ByteCodec<String> codec) {
        this.codec = codec;
    }

    public void setExecutor(@NotNull DelayedExecutor<?> executor) {
        this.executor = executor;
    }

    public void setLogger(@NotNull Logger logger) {
        this.logger = logger;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
        this.close();
        this.onStart();
    }

    public void close() {
        if (this.isEnabled()) {
            this.setEnabled(false);
            this.onClose();
        }
    }

    public void clear() {
        this.getSubscribedChannels().clear();
    }

    public boolean subscribe(String ... channels) {
        HashSet<String> list = new HashSet<String>();
        for (String channel : channels) {
            if (!this.getSubscribedChannels().add(channel)) continue;
            list.add(channel);
        }
        if (list.isEmpty()) {
            return false;
        }
        this.onSubscribe(list.toArray(new String[0]));
        return true;
    }

    public boolean unsubscribe(String ... channels) {
        HashSet<String> list = new HashSet<String>();
        for (String channel : channels) {
            if (!this.getSubscribedChannels().remove(channel)) continue;
            list.add(channel);
        }
        if (list.isEmpty()) {
            return false;
        }
        this.onUnsubscribe(list.toArray(new String[0]));
        return true;
    }

    public void send(@NotNull String channel, byte[] data) throws IOException {
        this.onSend(channel, data);
    }

    public void receive(@NotNull String channel, byte[] data) throws IOException {
        this.getConsumer().accept(channel, data);
        this.onReceive(channel, data);
    }

    public static interface Logger {
        public static final boolean DEBUG = "true".equals(System.getProperty("saicone.delivery4j.debug"));

        @NotNull
        public static Logger of(final @NotNull Class<?> clazz) {
            try {
                Class.forName("org.apache.logging.log4j.Logger");
                return Class.forName("me.neznamy.tab.libs.com.saicone.delivery4j.log.Log4jLogger").asSubclass(Logger.class).getDeclaredConstructor(Class.class).newInstance(clazz);
            }
            catch (Throwable throwable) {
                try {
                    Class.forName("org.slf4j.Logger");
                    return Class.forName("me.neznamy.tab.libs.com.saicone.delivery4j.log.Slf4jLogger").asSubclass(Logger.class).getDeclaredConstructor(Class.class).newInstance(clazz);
                }
                catch (Throwable throwable2) {
                    return new Logger(){
                        private final java.util.logging.Logger logger;
                        {
                            this.logger = java.util.logging.Logger.getLogger(clazz.getName());
                        }

                        private void log(int level, @NotNull Consumer<Level> consumer) {
                            switch (level) {
                                case 1: {
                                    consumer.accept(Level.SEVERE);
                                    break;
                                }
                                case 2: {
                                    consumer.accept(Level.WARNING);
                                    break;
                                }
                                case 3: {
                                    consumer.accept(Level.INFO);
                                    break;
                                }
                                default: {
                                    if (!DEBUG) break;
                                    consumer.accept(Level.INFO);
                                }
                            }
                        }

                        @Override
                        public void log(int level, @NotNull String msg) {
                            this.log(level, (Level lvl) -> this.logger.log((Level)lvl, msg));
                        }

                        @Override
                        public void log(int level, @NotNull String msg, @NotNull Throwable throwable) {
                            this.log(level, (Level lvl) -> this.logger.log((Level)lvl, msg, throwable));
                        }

                        @Override
                        public void log(int level, @NotNull Supplier<String> msg) {
                            this.log(level, (Level lvl) -> this.logger.log((Level)lvl, msg));
                        }

                        @Override
                        public void log(int level, @NotNull Supplier<String> msg, @NotNull Throwable throwable) {
                            this.log(level, (Level lvl) -> this.logger.log((Level)lvl, throwable, msg));
                        }
                    };
                }
            }
        }

        public void log(int var1, @NotNull String var2);

        public void log(int var1, @NotNull String var2, @NotNull Throwable var3);

        default public void log(int level, @NotNull Supplier<String> msg) {
            this.log(level, msg.get());
        }

        default public void log(int level, @NotNull Supplier<String> msg, @NotNull Throwable throwable) {
            this.log(level, msg.get(), throwable);
        }
    }
}

