/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery;

import java.util.Objects;
import java.util.function.BiPredicate;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.BackoffPolicy;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RecordedBinding;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RecordedEntity;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RecordedExchange;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RecordedQueue;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RetryContext;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RetryHandler;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.recovery.RetryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryHandler
implements RetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRetryHandler.class);
    protected final BiPredicate<? super RecordedQueue, Exception> queueRecoveryRetryCondition;
    protected final BiPredicate<? super RecordedExchange, Exception> exchangeRecoveryRetryCondition;
    protected final BiPredicate<? super RecordedBinding, Exception> bindingRecoveryRetryCondition;
    protected final BiPredicate<? super RecordedConsumer, Exception> consumerRecoveryRetryCondition;
    protected final RetryOperation<?> queueRecoveryRetryOperation;
    protected final RetryOperation<?> exchangeRecoveryRetryOperation;
    protected final RetryOperation<?> bindingRecoveryRetryOperation;
    protected final RetryOperation<?> consumerRecoveryRetryOperation;
    protected final int retryAttempts;
    protected final BackoffPolicy backoffPolicy;

    public DefaultRetryHandler(BiPredicate<? super RecordedQueue, Exception> queueRecoveryRetryCondition, BiPredicate<? super RecordedExchange, Exception> exchangeRecoveryRetryCondition, BiPredicate<? super RecordedBinding, Exception> bindingRecoveryRetryCondition, BiPredicate<? super RecordedConsumer, Exception> consumerRecoveryRetryCondition, RetryOperation<?> queueRecoveryRetryOperation, RetryOperation<?> exchangeRecoveryRetryOperation, RetryOperation<?> bindingRecoveryRetryOperation, RetryOperation<?> consumerRecoveryRetryOperation, int retryAttempts, BackoffPolicy backoffPolicy) {
        this.queueRecoveryRetryCondition = queueRecoveryRetryCondition;
        this.exchangeRecoveryRetryCondition = exchangeRecoveryRetryCondition;
        this.bindingRecoveryRetryCondition = bindingRecoveryRetryCondition;
        this.consumerRecoveryRetryCondition = consumerRecoveryRetryCondition;
        this.queueRecoveryRetryOperation = queueRecoveryRetryOperation;
        this.exchangeRecoveryRetryOperation = exchangeRecoveryRetryOperation;
        this.bindingRecoveryRetryOperation = bindingRecoveryRetryOperation;
        this.consumerRecoveryRetryOperation = consumerRecoveryRetryOperation;
        this.backoffPolicy = backoffPolicy;
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("Number of retry attempts must be greater than 0");
        }
        this.retryAttempts = retryAttempts;
    }

    @Override
    public RetryResult retryQueueRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.queueRecoveryRetryCondition, this.queueRecoveryRetryOperation, context.queue(), context);
    }

    @Override
    public RetryResult retryExchangeRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.exchangeRecoveryRetryCondition, this.exchangeRecoveryRetryOperation, context.exchange(), context);
    }

    @Override
    public RetryResult retryBindingRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.bindingRecoveryRetryCondition, this.bindingRecoveryRetryOperation, context.binding(), context);
    }

    @Override
    public RetryResult retryConsumerRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.consumerRecoveryRetryCondition, this.consumerRecoveryRetryOperation, context.consumer(), context);
    }

    protected RetryResult doRetry(BiPredicate<RecordedEntity, Exception> condition, RetryOperation<?> operation, RecordedEntity entity, RetryContext context) throws Exception {
        Exception exception = context.exception();
        for (int attempts = 0; attempts < this.retryAttempts; ++attempts) {
            if (condition.test(entity, exception)) {
                this.log(entity, exception, attempts);
                this.backoffPolicy.backoff(attempts + 1);
                try {
                    Object result = operation.call(context);
                    return new RetryResult(entity, result == null ? null : result.toString());
                }
                catch (Exception e) {
                    exception = e;
                    continue;
                }
            }
            throw exception;
        }
        throw exception;
    }

    protected void log(RecordedEntity entity, Exception exception, int attempts) {
        LOGGER.info("Error while recovering {}, retrying with {} more attempt(s).", new Object[]{entity, this.retryAttempts - attempts, exception});
    }

    public static interface RetryOperation<T> {
        public T call(RetryContext var1) throws Exception;

        default public <V> RetryOperation<V> andThen(RetryOperation<V> after) {
            Objects.requireNonNull(after);
            return context -> {
                this.call(context);
                return after.call(context);
            };
        }
    }
}

