/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client.impl;

import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.libs.com.rabbitmq.client.Command;
import me.neznamy.tab.libs.com.rabbitmq.client.Method;
import me.neznamy.tab.libs.com.rabbitmq.client.ShutdownSignalException;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.AMQChannel;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.AMQCommand;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.RpcWrapper;

public class CompletableFutureRpcWrapper
implements RpcWrapper {
    private final Method request;
    private final CompletableFuture<Command> completableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> completableFuture) {
        this.request = method;
        this.completableFuture = completableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand command) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
    }

    @Override
    public void complete(AMQCommand command) {
        this.completableFuture.complete(command);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        this.completableFuture.completeExceptionally(signal);
    }
}

