/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client;

import javax.net.ssl.SSLParameters;
import me.neznamy.tab.libs.com.rabbitmq.client.SocketConfigurators;
import me.neznamy.tab.libs.com.rabbitmq.client.SslEngineConfigurator;

public abstract class SslEngineConfigurators {
    public static final SslEngineConfigurator DEFAULT = sslEngine -> {};
    public static final SslEngineConfigurator ENABLE_HOSTNAME_VERIFICATION = sslEngine -> {
        SSLParameters sslParameters = SocketConfigurators.enableHostnameVerification(sslEngine.getSSLParameters());
        sslEngine.setSSLParameters(sslParameters);
    };

    public static SslEngineConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static SslEngineConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SslEngineConfigurator configurator = channel -> {};

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SslEngineConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SslEngineConfigurator build() {
            return this.configurator;
        }
    }
}

