/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client;

import me.neznamy.tab.libs.com.rabbitmq.client.SocketChannelConfigurator;
import me.neznamy.tab.libs.com.rabbitmq.client.SocketConfigurators;

public abstract class SocketChannelConfigurators {
    public static final SocketChannelConfigurator DISABLE_NAGLE_ALGORITHM;
    public static final SocketChannelConfigurator DEFAULT;

    public static SocketChannelConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static SocketChannelConfigurator disableNagleAlgorithm() {
        return DISABLE_NAGLE_ALGORITHM;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT = DISABLE_NAGLE_ALGORITHM = socketChannel -> SocketConfigurators.DISABLE_NAGLE_ALGORITHM.configure(socketChannel.socket());
    }

    public static class Builder {
        private SocketChannelConfigurator configurator = channel -> {};

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder disableNagleAlgorithm() {
            this.configurator = this.configurator.andThen(DISABLE_NAGLE_ALGORITHM);
            return this;
        }

        public Builder add(SocketChannelConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SocketChannelConfigurator build() {
            return this.configurator;
        }
    }
}

