/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import me.neznamy.tab.libs.com.rabbitmq.client.ConnectionFactory;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.AMQConnection;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.nio.NioParams;

public class ConnectionFactoryConfigurator {
    public static final String DEFAULT_PREFIX = "rabbitmq.";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VIRTUAL_HOST = "virtual.host";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String CONNECTION_CHANNEL_MAX = "connection.channel.max";
    public static final String CONNECTION_FRAME_MAX = "connection.frame.max";
    public static final String CONNECTION_HEARTBEAT = "connection.heartbeat";
    public static final String CONNECTION_TIMEOUT = "connection.timeout";
    public static final String HANDSHAKE_TIMEOUT = "handshake.timeout";
    public static final String SHUTDOWN_TIMEOUT = "shutdown.timeout";
    public static final String CLIENT_PROPERTIES_PREFIX = "client.properties.";
    public static final String CONNECTION_RECOVERY_ENABLED = "connection.recovery.enabled";
    public static final String TOPOLOGY_RECOVERY_ENABLED = "topology.recovery.enabled";
    public static final String CONNECTION_RECOVERY_INTERVAL = "connection.recovery.interval";
    public static final String CHANNEL_RPC_TIMEOUT = "channel.rpc.timeout";
    public static final String CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE = "channel.should.check.rpc.response.type";
    public static final String USE_NIO = "use.nio";
    public static final String NIO_READ_BYTE_BUFFER_SIZE = "nio.read.byte.buffer.size";
    public static final String NIO_WRITE_BYTE_BUFFER_SIZE = "nio.write.byte.buffer.size";
    public static final String NIO_NB_IO_THREADS = "nio.nb.io.threads";
    public static final String NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS = "nio.write.enqueuing.timeout.in.ms";
    public static final String NIO_WRITE_QUEUE_CAPACITY = "nio.write.queue.capacity";
    public static final String SSL_ALGORITHM = "ssl.algorithm";
    public static final String SSL_ENABLED = "ssl.enabled";
    public static final String SSL_KEY_STORE = "ssl.key.store";
    public static final String SSL_KEY_STORE_PASSWORD = "ssl.key.store.password";
    public static final String SSL_KEY_STORE_TYPE = "ssl.key.store.type";
    public static final String SSL_KEY_STORE_ALGORITHM = "ssl.key.store.algorithm";
    public static final String SSL_TRUST_STORE = "ssl.trust.store";
    public static final String SSL_TRUST_STORE_PASSWORD = "ssl.trust.store.password";
    public static final String SSL_TRUST_STORE_TYPE = "ssl.trust.store.type";
    public static final String SSL_TRUST_STORE_ALGORITHM = "ssl.trust.store.algorithm";
    public static final String SSL_VALIDATE_SERVER_CERTIFICATE = "ssl.validate.server.certificate";
    public static final String SSL_VERIFY_HOSTNAME = "ssl.verify.hostname";
    private static final Map<String, List<String>> ALIASES = new ConcurrentHashMap<String, List<String>>(){
        {
            this.put(ConnectionFactoryConfigurator.SSL_KEY_STORE, Arrays.asList("ssl.key-store"));
            this.put(ConnectionFactoryConfigurator.SSL_KEY_STORE_PASSWORD, Arrays.asList("ssl.key-store-password"));
            this.put(ConnectionFactoryConfigurator.SSL_KEY_STORE_TYPE, Arrays.asList("ssl.key-store-type"));
            this.put(ConnectionFactoryConfigurator.SSL_KEY_STORE_ALGORITHM, Arrays.asList("ssl.key-store-algorithm"));
            this.put(ConnectionFactoryConfigurator.SSL_TRUST_STORE, Arrays.asList("ssl.trust-store"));
            this.put(ConnectionFactoryConfigurator.SSL_TRUST_STORE_PASSWORD, Arrays.asList("ssl.trust-store-password"));
            this.put(ConnectionFactoryConfigurator.SSL_TRUST_STORE_TYPE, Arrays.asList("ssl.trust-store-type"));
            this.put(ConnectionFactoryConfigurator.SSL_TRUST_STORE_ALGORITHM, Arrays.asList("ssl.trust-store-algorithm"));
            this.put(ConnectionFactoryConfigurator.SSL_VALIDATE_SERVER_CERTIFICATE, Arrays.asList("ssl.validate-server-certificate"));
            this.put(ConnectionFactoryConfigurator.SSL_VERIFY_HOSTNAME, Arrays.asList("ssl.verify-hostname"));
        }
    };

    public static void load(ConnectionFactory cf, String propertyFileLocation, String prefix) throws IOException {
        if (propertyFileLocation == null || propertyFileLocation.isEmpty()) {
            throw new IllegalArgumentException("Property file argument cannot be null or empty");
        }
        Properties properties = new Properties();
        try (InputStream in = ConnectionFactoryConfigurator.loadResource(propertyFileLocation);){
            properties.load(in);
        }
        ConnectionFactoryConfigurator.load(cf, (Map<String, String>)properties, prefix);
    }

    private static InputStream loadResource(String location) throws FileNotFoundException {
        if (location.startsWith("classpath:")) {
            return ConnectionFactoryConfigurator.class.getResourceAsStream(location.substring("classpath:".length()));
        }
        return new FileInputStream(location);
    }

    public static void load(ConnectionFactory cf, Map<String, String> properties, String prefix) {
        String useSsl;
        String useNio;
        String channelShouldCheckRpcResponseType;
        String channelRpcTimeout;
        String networkRecoveryInterval;
        String topologyRecovery;
        String shutdownTimeout;
        String handshakeTimeout;
        String connectionTimeout;
        String requestedHeartbeat;
        String requestedFrameMax;
        String requestedChannelMax;
        String port;
        String host;
        String vhost;
        String password;
        String username;
        String uri = properties.get((prefix = prefix == null ? "" : prefix) + "uri");
        if (uri != null) {
            try {
                cf.setUri(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
            catch (KeyManagementException e) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + uri, e);
            }
        }
        if ((username = ConnectionFactoryConfigurator.lookUp(USERNAME, properties, prefix)) != null) {
            cf.setUsername(username);
        }
        if ((password = ConnectionFactoryConfigurator.lookUp(PASSWORD, properties, prefix)) != null) {
            cf.setPassword(password);
        }
        if ((vhost = ConnectionFactoryConfigurator.lookUp(VIRTUAL_HOST, properties, prefix)) != null) {
            cf.setVirtualHost(vhost);
        }
        if ((host = ConnectionFactoryConfigurator.lookUp(HOST, properties, prefix)) != null) {
            cf.setHost(host);
        }
        if ((port = ConnectionFactoryConfigurator.lookUp(PORT, properties, prefix)) != null) {
            cf.setPort(Integer.valueOf(port));
        }
        if ((requestedChannelMax = ConnectionFactoryConfigurator.lookUp(CONNECTION_CHANNEL_MAX, properties, prefix)) != null) {
            cf.setRequestedChannelMax(Integer.valueOf(requestedChannelMax));
        }
        if ((requestedFrameMax = ConnectionFactoryConfigurator.lookUp(CONNECTION_FRAME_MAX, properties, prefix)) != null) {
            cf.setRequestedFrameMax(Integer.valueOf(requestedFrameMax));
        }
        if ((requestedHeartbeat = ConnectionFactoryConfigurator.lookUp(CONNECTION_HEARTBEAT, properties, prefix)) != null) {
            cf.setRequestedHeartbeat(Integer.valueOf(requestedHeartbeat));
        }
        if ((connectionTimeout = ConnectionFactoryConfigurator.lookUp(CONNECTION_TIMEOUT, properties, prefix)) != null) {
            cf.setConnectionTimeout(Integer.valueOf(connectionTimeout));
        }
        if ((handshakeTimeout = ConnectionFactoryConfigurator.lookUp(HANDSHAKE_TIMEOUT, properties, prefix)) != null) {
            cf.setHandshakeTimeout(Integer.valueOf(handshakeTimeout));
        }
        if ((shutdownTimeout = ConnectionFactoryConfigurator.lookUp(SHUTDOWN_TIMEOUT, properties, prefix)) != null) {
            cf.setShutdownTimeout(Integer.valueOf(shutdownTimeout));
        }
        HashMap<String, Object> clientProperties = new HashMap<String, Object>();
        Map<String, Object> defaultClientProperties = AMQConnection.defaultClientProperties();
        clientProperties.putAll(defaultClientProperties);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(prefix + CLIENT_PROPERTIES_PREFIX)) continue;
            String clientPropertyKey = entry.getKey().substring((prefix + CLIENT_PROPERTIES_PREFIX).length());
            if (defaultClientProperties.containsKey(clientPropertyKey) && (entry.getValue() == null || entry.getValue().trim().isEmpty())) {
                clientProperties.remove(clientPropertyKey);
                continue;
            }
            clientProperties.put(clientPropertyKey, entry.getValue());
        }
        cf.setClientProperties(clientProperties);
        String automaticRecovery = ConnectionFactoryConfigurator.lookUp(CONNECTION_RECOVERY_ENABLED, properties, prefix);
        if (automaticRecovery != null) {
            cf.setAutomaticRecoveryEnabled(Boolean.valueOf(automaticRecovery));
        }
        if ((topologyRecovery = ConnectionFactoryConfigurator.lookUp(TOPOLOGY_RECOVERY_ENABLED, properties, prefix)) != null) {
            cf.setTopologyRecoveryEnabled(Boolean.valueOf(topologyRecovery));
        }
        if ((networkRecoveryInterval = ConnectionFactoryConfigurator.lookUp(CONNECTION_RECOVERY_INTERVAL, properties, prefix)) != null) {
            cf.setNetworkRecoveryInterval(Long.valueOf(networkRecoveryInterval));
        }
        if ((channelRpcTimeout = ConnectionFactoryConfigurator.lookUp(CHANNEL_RPC_TIMEOUT, properties, prefix)) != null) {
            cf.setChannelRpcTimeout(Integer.valueOf(channelRpcTimeout));
        }
        if ((channelShouldCheckRpcResponseType = ConnectionFactoryConfigurator.lookUp(CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE, properties, prefix)) != null) {
            cf.setChannelShouldCheckRpcResponseType(Boolean.valueOf(channelShouldCheckRpcResponseType));
        }
        if ((useNio = ConnectionFactoryConfigurator.lookUp(USE_NIO, properties, prefix)) != null && Boolean.valueOf(useNio).booleanValue()) {
            String writeQueueCapacity;
            String writeEnqueuingTime;
            String nbIoThreads;
            String writeByteBufferSize;
            cf.useNio();
            NioParams nioParams = new NioParams();
            String readByteBufferSize = ConnectionFactoryConfigurator.lookUp(NIO_READ_BYTE_BUFFER_SIZE, properties, prefix);
            if (readByteBufferSize != null) {
                nioParams.setReadByteBufferSize(Integer.valueOf(readByteBufferSize));
            }
            if ((writeByteBufferSize = ConnectionFactoryConfigurator.lookUp(NIO_WRITE_BYTE_BUFFER_SIZE, properties, prefix)) != null) {
                nioParams.setWriteByteBufferSize(Integer.valueOf(writeByteBufferSize));
            }
            if ((nbIoThreads = ConnectionFactoryConfigurator.lookUp(NIO_NB_IO_THREADS, properties, prefix)) != null) {
                nioParams.setNbIoThreads(Integer.valueOf(nbIoThreads));
            }
            if ((writeEnqueuingTime = ConnectionFactoryConfigurator.lookUp(NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS, properties, prefix)) != null) {
                nioParams.setWriteEnqueuingTimeoutInMs(Integer.valueOf(writeEnqueuingTime));
            }
            if ((writeQueueCapacity = ConnectionFactoryConfigurator.lookUp(NIO_WRITE_QUEUE_CAPACITY, properties, prefix)) != null) {
                nioParams.setWriteQueueCapacity(Integer.valueOf(writeQueueCapacity));
            }
            cf.setNioParams(nioParams);
        }
        if ((useSsl = ConnectionFactoryConfigurator.lookUp(SSL_ENABLED, properties, prefix)) != null && Boolean.valueOf(useSsl).booleanValue()) {
            ConnectionFactoryConfigurator.setUpSsl(cf, properties, prefix);
        }
    }

    private static void setUpSsl(ConnectionFactory cf, Map<String, String> properties, String prefix) {
        String algorithm = ConnectionFactoryConfigurator.lookUp(SSL_ALGORITHM, properties, prefix);
        String keyStoreLocation = ConnectionFactoryConfigurator.lookUp(SSL_KEY_STORE, properties, prefix);
        String keyStorePassword = ConnectionFactoryConfigurator.lookUp(SSL_KEY_STORE_PASSWORD, properties, prefix);
        String keyStoreType = ConnectionFactoryConfigurator.lookUp(SSL_KEY_STORE_TYPE, properties, prefix, "PKCS12");
        String keyStoreAlgorithm = ConnectionFactoryConfigurator.lookUp(SSL_KEY_STORE_ALGORITHM, properties, prefix, "SunX509");
        String trustStoreLocation = ConnectionFactoryConfigurator.lookUp(SSL_TRUST_STORE, properties, prefix);
        String trustStorePassword = ConnectionFactoryConfigurator.lookUp(SSL_TRUST_STORE_PASSWORD, properties, prefix);
        String trustStoreType = ConnectionFactoryConfigurator.lookUp(SSL_TRUST_STORE_TYPE, properties, prefix, "JKS");
        String trustStoreAlgorithm = ConnectionFactoryConfigurator.lookUp(SSL_TRUST_STORE_ALGORITHM, properties, prefix, "SunX509");
        String validateServerCertificate = ConnectionFactoryConfigurator.lookUp(SSL_VALIDATE_SERVER_CERTIFICATE, properties, prefix);
        String verifyHostname = ConnectionFactoryConfigurator.lookUp(SSL_VERIFY_HOSTNAME, properties, prefix);
        try {
            algorithm = algorithm == null ? ConnectionFactory.computeDefaultTlsProtocol(SSLContext.getDefault().getSupportedSSLParameters().getProtocols()) : algorithm;
            boolean enableHostnameVerification = verifyHostname == null ? Boolean.FALSE : Boolean.valueOf(verifyHostname);
            if (keyStoreLocation == null && trustStoreLocation == null) {
                ConnectionFactoryConfigurator.setUpBasicSsl(cf, validateServerCertificate == null ? Boolean.FALSE : Boolean.valueOf(validateServerCertificate), enableHostnameVerification, algorithm);
            } else {
                KeyManager[] keyManagers = ConnectionFactoryConfigurator.configureKeyManagers(keyStoreLocation, keyStorePassword, keyStoreType, keyStoreAlgorithm);
                TrustManager[] trustManagers = ConnectionFactoryConfigurator.configureTrustManagers(trustStoreLocation, trustStorePassword, trustStoreType, trustStoreAlgorithm);
                SSLContext sslContext = SSLContext.getInstance(algorithm);
                sslContext.init(keyManagers, trustManagers, null);
                cf.useSslProtocol(sslContext);
                if (enableHostnameVerification) {
                    cf.enableHostnameVerification();
                }
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IllegalStateException("Error while configuring TLS", e);
        }
    }

    private static KeyManager[] configureKeyManagers(String keystore, String keystorePassword, String keystoreType, String keystoreAlgorithm) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        char[] keyPassphrase = null;
        if (keystorePassword != null) {
            keyPassphrase = keystorePassword.toCharArray();
        }
        KeyManager[] keyManagers = null;
        if (keystore != null) {
            KeyStore ks = KeyStore.getInstance(keystoreType);
            try (InputStream in = ConnectionFactoryConfigurator.loadResource(keystore);){
                ks.load(in, keyPassphrase);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keystoreAlgorithm);
            kmf.init(ks, keyPassphrase);
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    private static TrustManager[] configureTrustManagers(String truststore, String truststorePassword, String truststoreType, String truststoreAlgorithm) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        char[] trustPassphrase = null;
        if (truststorePassword != null) {
            trustPassphrase = truststorePassword.toCharArray();
        }
        TrustManager[] trustManagers = null;
        if (truststore != null) {
            KeyStore tks = KeyStore.getInstance(truststoreType);
            try (InputStream in = ConnectionFactoryConfigurator.loadResource(truststore);){
                tks.load(in, trustPassphrase);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(truststoreAlgorithm);
            tmf.init(tks);
            trustManagers = tmf.getTrustManagers();
        }
        return trustManagers;
    }

    private static void setUpBasicSsl(ConnectionFactory cf, boolean validateServerCertificate, boolean verifyHostname, String sslAlgorithm) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        if (validateServerCertificate) {
            ConnectionFactoryConfigurator.useDefaultTrustStore(cf, sslAlgorithm, verifyHostname);
        } else if (sslAlgorithm == null) {
            cf.useSslProtocol();
        } else {
            cf.useSslProtocol(sslAlgorithm);
        }
    }

    private static void useDefaultTrustStore(ConnectionFactory cf, String sslAlgorithm, boolean verifyHostname) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance(sslAlgorithm);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        cf.useSslProtocol(sslContext);
        if (verifyHostname) {
            cf.enableHostnameVerification();
        }
    }

    public static void load(ConnectionFactory connectionFactory, String propertyFileLocation) throws IOException {
        ConnectionFactoryConfigurator.load(connectionFactory, propertyFileLocation, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties, String prefix) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, prefix);
    }

    public static void load(ConnectionFactory connectionFactory, Map<String, String> properties) {
        ConnectionFactoryConfigurator.load(connectionFactory, properties, DEFAULT_PREFIX);
    }

    public static String lookUp(String key, Map<String, String> properties, String prefix) {
        return ConnectionFactoryConfigurator.lookUp(key, properties, prefix, null);
    }

    public static String lookUp(String key, Map<String, String> properties, String prefix, String defaultValue) {
        String value = properties.get(prefix + key);
        if (value == null) {
            value = ALIASES.getOrDefault(key, Collections.emptyList()).stream().map(alias -> (String)properties.get(prefix + alias)).filter(v -> v != null).findFirst().orElse(defaultValue);
        }
        return value;
    }
}

