/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;

public class DisguiseMethods {
    private HashMap<Class<? extends FlagWatcher>, List<WatcherMethod>> watcherMethods = new HashMap();
    private HashMap<Class<? extends Disguise>, List<WatcherMethod>> disguiseMethods = new HashMap();
    private ArrayList<WatcherMethod> methods = new ArrayList();

    public ArrayList<WatcherMethod> getMethods(Class clazz) {
        ArrayList<WatcherMethod> arrayList = new ArrayList<WatcherMethod>();
        if (this.watcherMethods.containsKey(clazz)) {
            arrayList.addAll((Collection<WatcherMethod>)this.watcherMethods.get(clazz));
        }
        if (clazz != FlagWatcher.class) {
            arrayList.addAll(this.getMethods(clazz.getSuperclass()));
        }
        return arrayList;
    }

    public DisguiseMethods() {
        this.loadMethods();
    }

    /*
     * WARNING - void declaration
     */
    private void loadMethods() {
        try (InputStream inputStream = LibsDisguises.getInstance().getResource("ANTI_PIRACY_ENCRYPTION");){
            void var7_17;
            Class<Object> clazz2;
            Class<Object> clazz3;
            String[] stringArray = new String(ReflectionManager.readFuzzyFully(inputStream), StandardCharsets.UTF_8).split("\n");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(FlagWatcher.class.getSimpleName(), FlagWatcher.class);
            block29: for (DisguiseType disguiseType : DisguiseType.values()) {
                void var8_18;
                if (disguiseType.getWatcherClass() == null) continue;
                Class<? extends FlagWatcher> clazz4 = disguiseType.getWatcherClass();
                while (!hashMap.containsKey(var8_18.getSimpleName())) {
                    hashMap.put(var8_18.getSimpleName(), var8_18);
                    if (var8_18 == FlagWatcher.class) continue block29;
                    Class clazz5 = ReflectionManager.getSuperClass((Class)var8_18);
                }
            }
            for (String string : stringArray) {
                WatcherInfo watcherInfo = (WatcherInfo)new Gson().fromJson(string, WatcherInfo.class);
                if (!watcherInfo.isSupported() || watcherInfo.isDeprecated() && watcherInfo.getAdded() != 0 && watcherInfo.getRemoved() < 0 || (clazz3 = (Class<Boolean>)hashMap.get(watcherInfo.getWatcher())) == null) continue;
                clazz2 = DisguiseMethods.parseType(watcherInfo.getParam());
                Class<?> clazz6 = DisguiseMethods.parseType(watcherInfo.getReturnType());
                Class[] classArray = watcherInfo.getParam();
                MethodType methodType = clazz2 == null || clazz2 == Void.TYPE ? MethodType.methodType(clazz6) : MethodType.methodType(clazz6, clazz2);
                MethodHandle methodHandle = MethodHandles.publicLookup().findVirtual(clazz3, watcherInfo.getMethod(), methodType);
                WatcherMethod watcherMethod = new WatcherMethod((Class<? extends FlagWatcher>)clazz3, methodHandle, watcherInfo.getMethod(), clazz6, clazz2, watcherInfo.isRandomDefault(), watcherInfo.isDeprecated() && watcherInfo.getAdded() == 0);
                this.methods.add(watcherMethod);
                if (watcherMethod.getName().startsWith("get") || watcherMethod.getName().startsWith("has") || clazz2 == null || clazz2 == Void.TYPE || ParamInfoManager.getParamInfo(watcherMethod) == null) continue;
                this.watcherMethods.computeIfAbsent(clazz3, clazz -> new ArrayList()).add(watcherMethod);
            }
            PlayerDisguise playerDisguise = new PlayerDisguise("");
            String[] stringArray2 = new String[]{"setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires", "setNotifyBar", "setBossBarColor", "setBossBarStyle", "setTallDisguisesVisible", "setDynamicName", "setSoundGroup", "setDisguiseName", "setDeadmau5Ears"};
            int n = stringArray2.length;
            boolean bl = false;
            while (var7_17 < n) {
                String string = stringArray2[var7_17];
                try {
                    clazz3 = Boolean.TYPE;
                    clazz2 = Disguise.class;
                    boolean bl2 = false;
                    switch (string) {
                        case "setExpires": {
                            clazz3 = Long.TYPE;
                            break;
                        }
                        case "setNotifyBar": {
                            clazz3 = DisguiseConfig.NotifyBar.class;
                            break;
                        }
                        case "setBossBarColor": {
                            clazz3 = BarColor.class;
                            break;
                        }
                        case "setBossBarStyle": {
                            clazz3 = BarStyle.class;
                            break;
                        }
                        case "setDisguiseName": {
                            bl2 = true;
                        }
                        case "setSoundGroup": {
                            clazz3 = String.class;
                            break;
                        }
                        case "setDeadmau5Ears": {
                            clazz2 = PlayerDisguise.class;
                            break;
                        }
                    }
                    for (Class clazz7 : new Class[]{Void.TYPE, clazz2}) {
                        try {
                            WatcherMethod watcherMethod = new WatcherMethod(clazz2, MethodHandles.publicLookup().findVirtual(clazz2, string, MethodType.methodType(clazz7, clazz3)), string, null, clazz3, bl2, false);
                            this.methods.add(watcherMethod);
                            this.watcherMethods.computeIfAbsent(clazz2 == Disguise.class ? FlagWatcher.class : PlayerWatcher.class, clazz -> new ArrayList()).add(watcherMethod);
                            String string2 = (clazz3 == Boolean.TYPE ? "is" : "get") + string.substring(3);
                            WatcherMethod watcherMethod2 = new WatcherMethod(clazz2, MethodHandles.publicLookup().findVirtual(clazz2, string2, MethodType.methodType(clazz3)), string2, clazz3, null, bl2, false);
                            this.methods.add(watcherMethod2);
                            break;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (clazz7 != clazz2) continue;
                            noSuchMethodException.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++var7_17;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Class<?> parseType(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            return Class.forName(string);
        }
        switch (string) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "[I": {
                return int[].class;
            }
            case "[Z": {
                return boolean[].class;
            }
        }
        throw new IllegalArgumentException("Class not found: " + string);
    }

    public ArrayList<WatcherMethod> getMethods() {
        return this.methods;
    }
}

