/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.LDGithub;
import me.libraryaddict.disguise.utilities.updates.LDJenkins;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final long started = System.currentTimeMillis();
    private PluginInformation lastDownload;
    private final AtomicBoolean downloading = new AtomicBoolean(false);
    private DisguiseUpdate update;
    private final LDGithub githubUpdater = new LDGithub(this);
    private final LDJenkins jenkinsUpdater = new LDJenkins();
    private String[] updateMessage = new String[0];
    private boolean goSilent;

    public boolean isServerLatestVersion() {
        return this.isOnLatestUpdate(false);
    }

    public boolean isOnLatestUpdate(boolean bl) {
        boolean bl2;
        if (this.getUpdate() == null) {
            return false;
        }
        boolean bl3 = bl && this.getLastDownload() != null ? !this.getLastDownload().getVersion().contains("-SNAPSHOT") : (bl2 = LibsDisguises.getInstance().isReleaseBuild());
        if (this.getUpdate().isReleaseBuild() != bl2) {
            return false;
        }
        String string = this.getUpdate().isReleaseBuild() ? (this.lastDownload != null && bl ? this.lastDownload.getVersion() : LibsDisguises.getInstance().getDescription().getVersion()) : (this.lastDownload != null && bl ? this.lastDownload.getBuildNumber() : LibsDisguises.getInstance().getBuildNo());
        return this.getUpdate() != null && this.getUpdate().getVersion().equals(string);
    }

    public boolean isDownloading() {
        return this.downloading.get();
    }

    public boolean isOldUpdate() {
        return this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L)));
    }

    public boolean isUsingReleaseBuilds() {
        DisguiseConfig.UpdatesBranch updatesBranch = DisguiseConfig.getUpdatesBranch();
        return updatesBranch == DisguiseConfig.UpdatesBranch.RELEASES || updatesBranch == DisguiseConfig.UpdatesBranch.SAME_BUILDS && DisguiseConfig.isUsingReleaseBuild();
    }

    public void notifyUpdate(CommandSender commandSender) {
        if (this.isGoSilent() || !DisguiseConfig.isNotifyUpdate() || !commandSender.hasPermission("libsdisguises.update")) {
            return;
        }
        if (this.updateMessage == null || this.updateMessage.length == 0) {
            return;
        }
        if (commandSender instanceof Player) {
            commandSender.sendMessage(this.updateMessage);
        } else {
            for (String string : this.updateMessage) {
                DisguiseUtilities.getLogger().info(string);
            }
        }
    }

    public void doAutoUpdateCheck() {
        try {
            DisguiseUpdate disguiseUpdate = this.getUpdate();
            this.updateMessage = new String[0];
            boolean bl = this.isGoSilent();
            this.doUpdateCheck();
            if (this.isOnLatestUpdate(true) || disguiseUpdate != null && disguiseUpdate.getVersion().equals(this.getUpdate().getVersion())) {
                return;
            }
            this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            if (this.isGoSilent() ? !bl : DisguiseConfig.isAutoUpdate()) {
                this.grabJarDownload(this.getUpdate().getDownload());
                this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            }
            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.notifyUpdate((CommandSender)player);
                }
            });
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning(String.format("Failed to check for update: %s", exception.getMessage()));
        }
    }

    public PluginInformation doUpdate() {
        if (this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(6L)))) {
            this.doUpdateCheck();
        }
        if (this.getUpdate() == null) {
            return null;
        }
        return this.grabJarDownload(this.getUpdate().getDownload());
    }

    public LibsMsg doUpdateCheck() {
        DisguiseConfig.setLastUpdateRequest(System.currentTimeMillis());
        DisguiseConfig.saveInternalConfig();
        this.downloading.set(true);
        try {
            this.update = null;
            this.update = this.isUsingReleaseBuilds() ? this.githubUpdater.getLatestRelease() : this.jenkinsUpdater.getLatestSnapshot();
        }
        finally {
            this.downloading.set(false);
        }
        if (this.getUpdate() == null) {
            return LibsMsg.UPDATE_FAILED;
        }
        if (this.getUpdate().isReleaseBuild()) {
            String string = LibsDisguises.getInstance().getDescription().getVersion();
            if (LibsDisguises.getInstance().isReleaseBuild() && !this.isNewerVersion(string, this.getUpdate().getVersion())) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY.get(string, this.getUpdate().getVersion()), LibsMsg.UPDATE_HOW.get(new Object[0])};
        } else {
            if (!this.getUpdate().getVersion().matches("[0-9]+")) {
                return LibsMsg.UPDATE_FAILED;
            }
            int n = Integer.parseInt(this.getUpdate().getVersion());
            if (n <= LibsDisguises.getInstance().getBuildNumber()) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            String string = LibsDisguises.getInstance().getBuildNo();
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY_SNAPSHOT.get((string.matches("[0-9]+") ? "#" : "") + string, n), LibsMsg.UPDATE_HOW.get(new Object[0])};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginInformation grabJarDownload(String string) {
        this.downloading.set(true);
        File file = new File(Bukkit.getUpdateFolderFile(), LibsDisguises.getInstance().getFile().getName());
        if (!this.isGoSilent()) {
            DisguiseUtilities.getLogger().info("Now downloading build of Lib's Disguises from " + string + " to " + file.getName());
        }
        if (file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDefaultUseCaches(false);
            try (Object object = httpURLConnection.getInputStream();){
                Files.copy((InputStream)object, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (!this.isGoSilent()) {
                DisguiseUtilities.getLogger().info("Download success!");
            }
            this.lastDownload = object = LibsPremium.getInformation(file);
            this.updateMessage = new String[]{LibsMsg.UPDATE_SUCCESS.get(new Object[0]), LibsMsg.UPDATE_INFO.get(((PluginInformation)object).getVersion(), ((PluginInformation)object).getBuildNumber(), ((PluginInformation)object).getParsedBuildDate().toString(), ((PluginInformation)object).getSize() / 1024L)};
            Object object = object;
            return object;
        }
        catch (Exception exception) {
            file.delete();
            DisguiseUtilities.getLogger().warning("Failed to download snapshot build.");
            exception.printStackTrace();
        }
        finally {
            this.downloading.set(false);
        }
        return null;
    }

    private boolean isNewerVersion(String string, String string2) {
        int n;
        int n2;
        string = string.replaceAll("(v)|(-SNAPSHOT)", "");
        string2 = string2.replaceAll("(v)|(-SNAPSHOT)", "");
        if (this.started + TimeUnit.HOURS.toMillis(6L) > System.currentTimeMillis() && string.matches("[0-9]+(\\.[0-9]+)*") && string2.matches("[0-9]+(\\.[0-9]+)*") && (n2 = Integer.parseInt(string.replace(".", ""))) > (n = Integer.parseInt(string2.replace(".", ""))) && n + 3 > n2) {
            return false;
        }
        return !string.equals(string2);
    }

    public PluginInformation getLastDownload() {
        return this.lastDownload;
    }

    public DisguiseUpdate getUpdate() {
        return this.update;
    }

    public String[] getUpdateMessage() {
        return this.updateMessage;
    }

    public boolean isGoSilent() {
        return this.goSilent;
    }

    public void setGoSilent(boolean bl) {
        this.goSilent = bl;
    }
}

