/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.ChatColor;

public class LDJenkins {
    private UpdateChecker updateChecker;

    private String[] getBadUsers() {
        try {
            HashMap hashMap;
            URL uRL = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            httpURLConnection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                String string = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                hashMap = (HashMap)new Gson().fromJson(string, HashMap.class);
            }
            if (!hashMap.containsKey("body")) {
                return new String[0];
            }
            return ((String)hashMap.get("body")).split("(\\r|\\n)+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    private Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map map;
            String[] stringArray = this.getBadUsers();
            for (String object2 : stringArray) {
                if (LibsPremium.getPaidInformation() == null || !object2.equals(LibsPremium.getPaidInformation().getDownloadID()) && !object2.equals(LibsPremium.getPaidInformation().getUserID())) continue;
                LibsDisguises.getInstance().unregisterCommands(true);
            }
            DisguiseUtilities.getLogger().info("Now looking for update on Jenkins..");
            URL uRL = new URL("https://ci.md-5.net/job/LibsDisguises/api/json?tree=builds[changeSet[items[msg]],id,result]");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDefaultUseCaches(false);
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                String string = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                map = (Map)new Gson().fromJson(string, Map.class);
            }
            return map;
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Failed to check for a snapshot update on jenkins.");
            exception.printStackTrace();
            return null;
        }
    }

    public DisguiseUpdate getLatestSnapshot() {
        Map<String, Object> map = this.fetchLastSnapshotBuild();
        if (map == null || !map.containsKey("builds")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        for (Map map2 : (List)map.get("builds")) {
            String string2 = (String)map2.get("result");
            if ((string2 == null || string2.equalsIgnoreCase("null")) && string == null) {
                DisguiseUtilities.getLogger().info("Jenkins build is pending.. Sleeping and checking again in 10 seconds");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                return this.getLatestSnapshot();
            }
            Object v = ((Map)map2.get("changeSet")).get("items");
            boolean bl = false;
            if (v instanceof List) {
                for (Map map3 : (List)v) {
                    String string3 = (String)map3.get("msg");
                    if (string3 == null) continue;
                    arrayList.add("#" + map2.get("id") + ": " + ChatColor.YELLOW + string3);
                    bl = bl || string3.toLowerCase(Locale.ENGLISH).matches("(re)?.?release.? .*");
                }
            }
            if (!"SUCCESS".equalsIgnoreCase(string2)) continue;
            if (string == null) {
                string = (String)map2.get("id");
            }
            if (!bl) continue;
            break;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new JenkinsUpdate(string, arrayList.toArray(new String[0]));
    }

    private class JenkinsUpdate
    implements DisguiseUpdate {
        private final Date fetched = new Date();
        private final String version;
        private final String[] changelog;

        @Override
        public String getDownload() {
            return "https://ci.md-5.net/job/LibsDisguises/" + this.getVersion() + "/artifact/target/LibsDisguises.jar";
        }

        @Override
        public boolean isReleaseBuild() {
            return false;
        }

        public JenkinsUpdate(String string, String[] stringArray) {
            this.version = string;
            this.changelog = stringArray;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }
    }
}

