/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;

public class LDGithub {
    private UpdateChecker checker;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DisguiseUpdate getLatestRelease() {
        try {
            GithubData githubData;
            Object object;
            Object object2;
            String string = LibsDisguises.getInstance().getDescription().getVersion();
            if (!this.getChecker().isGoSilent()) {
                DisguiseUtilities.getLogger().info("Now looking for update on Github..");
            }
            URL uRL = new URL("https://api.github.com/repos/libraryaddict/LibsDisguises/releases/latest");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            httpURLConnection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            if (Objects.equals(string, DisguiseConfig.getLastPluginUpdateVersion()) && DisguiseConfig.getLastGithubUpdateETag() != null) {
                httpURLConnection.setRequestProperty("If-None-Match", DisguiseConfig.getLastGithubUpdateETag());
            }
            if (httpURLConnection.getResponseCode() == 304) {
                return null;
            }
            try {
                object2 = httpURLConnection.getInputStream();
                try {
                    object = new BufferedReader(new InputStreamReader((InputStream)object2, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    githubData = (GithubData)new Gson().fromJson((String)object, GithubData.class);
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
            }
            catch (IOException iOException) {
                try (InputStream inputStream = httpURLConnection.getErrorStream();){
                    String string2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    DisguiseUtilities.getLogger().severe("Error with Github! " + string2);
                    if (!string2.contains("rate limit")) return null;
                    if (DisguiseConfig.isHittingRateLimit()) return null;
                    DisguiseConfig.setHittingRateLimit(true);
                    DisguiseUtilities.getLogger().severe("Changed update checker to be every 36 hours due to rate limiting from this IP");
                    DisguiseUpdate disguiseUpdate = null;
                    return disguiseUpdate;
                }
                catch (Exception exception) {
                    DisguiseUtilities.getLogger().severe("Error when trying to read error stream! Inception!");
                    exception.printStackTrace();
                }
                return null;
            }
            object2 = null;
            for (GithubData.Asset asset : githubData.getAssets()) {
                if (!asset.getName().endsWith(".jar")) {
                    continue;
                }
                object2 = asset.getBrowser_download_url();
                break;
            }
            if (object2 == null) {
                throw new IllegalStateException("Download url is missing");
            }
            object = new GithubUpdate(githubData.getTag_name().replace("v", ""), githubData.getBody().split("(\\r|\\n)+"), (String)object2);
            if (!Objects.equals(((GithubUpdate)object).getVersion(), string)) return object;
            DisguiseConfig.setLastGithubUpdateETag(httpURLConnection.getHeaderField("ETag"));
            DisguiseConfig.setLastPluginUpdateVersion(string);
            DisguiseConfig.saveInternalConfig();
            return object;
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Failed to check for a release on Github");
            exception.printStackTrace();
            return null;
        }
    }

    public LDGithub(UpdateChecker updateChecker) {
        this.checker = updateChecker;
    }

    public UpdateChecker getChecker() {
        return this.checker;
    }

    private class GithubData {
        String name;
        String tag_name;
        String body;
        Date published_at;
        Asset[] assets;

        private GithubData() {
        }

        public String getName() {
            return this.name;
        }

        public String getTag_name() {
            return this.tag_name;
        }

        public String getBody() {
            return this.body;
        }

        public Date getPublished_at() {
            return this.published_at;
        }

        public Asset[] getAssets() {
            return this.assets;
        }

        class Asset {
            String browser_download_url;
            String name;
            String content_type;

            Asset() {
            }

            public String getBrowser_download_url() {
                return this.browser_download_url;
            }

            public String getName() {
                return this.name;
            }

            public String getContent_type() {
                return this.content_type;
            }
        }
    }

    private class GithubUpdate
    implements DisguiseUpdate {
        private String version;
        private String[] changelog;
        private String download;
        private final Date fetched = new Date();

        @Override
        public boolean isReleaseBuild() {
            return true;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }

        @Override
        public String getDownload() {
            return this.download;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        public GithubUpdate(String string, String[] stringArray, String string2) {
            this.version = string;
            this.changelog = stringArray;
            this.download = string2;
        }
    }
}

