/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.translations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateFiller;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public enum TranslateType {
    DISGUISES("disguises"),
    MESSAGES("messages"),
    DISGUISE_OPTIONS("disguise_options"),
    DISGUISE_OPTIONS_PARAMETERS("disguise_option_parameters");

    private File file;
    private LinkedHashMap<String, String> translated = new LinkedHashMap();
    private HashMap<String, Boolean> toDeDupe = new HashMap();
    private FileWriter writer;
    private int written;

    private TranslateType(String string2) {
        this.file = new File("plugins/LibsDisguises/Translations", string2 + ".yml");
    }

    public static void refreshTranslations() {
        for (TranslateType translateType : TranslateType.values()) {
            translateType.loadTranslations();
        }
        TranslateFiller.fillConfigs();
        if (!LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().severe("You must purchase the plugin to use translations!");
        }
    }

    protected void saveTranslations() {
        Iterator<Map.Entry<String, String>> iterator = this.translated.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().equals(entry.getValue())) continue;
            iterator.remove();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
                DisguiseUtilities.getLogger().info("Saved " + this.written + " translations that were not in " + this.getFile().getName());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deDupeMessages();
    }

    private void loadTranslations() {
        this.translated.clear();
        if (!this.getFile().exists()) {
            DisguiseUtilities.getLogger().info("Translations for " + this.name() + " missing! Saving..");
            return;
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.options().pathSeparator(Character.toChars(0)[0]);
        int n = 0;
        try {
            yamlConfiguration.load(this.getFile());
            for (String string : yamlConfiguration.getKeys(false)) {
                String string2 = yamlConfiguration.getString(string);
                if (string2 == null) {
                    DisguiseUtilities.getLogger().severe("Translation for " + this.name() + " has a null value for the key '" + string + "'");
                    continue;
                }
                this.toDeDupe.put(string, true);
                String string3 = DisguiseUtilities.translateAlternateColorCodes(string);
                this.translated.put(string3, DisguiseUtilities.translateAlternateColorCodes(string2));
                if (string3.equals(this.translated.get(string3))) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().info("Loaded " + this.translated.size() + " translations for " + this.name() + " with " + n + " changed");
        } else if (n > 0 && !DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().info("Translations are disabled in libsdisguises.yml, but you modified " + n + " messages in the translations for " + this.name() + ". Is this intended?");
        }
    }

    private File getFile() {
        return this.file;
    }

    public void save(String string) {
        if (this != MESSAGES) {
            throw new IllegalArgumentException("Can't set no comment for '" + string + "'");
        }
        this.save(string, null);
    }

    public void save(String string, String string2) {
        this.save(null, string, string2);
    }

    public void save(LibsMsg libsMsg, String string, String string2) {
        String string3;
        this.toDeDupe.put(StringEscapeUtils.escapeJava((String)string.replace("\u00a7", "&")), false);
        if (this.translated.containsKey(string)) {
            return;
        }
        String string4 = string;
        if (libsMsg != null && this.translated.containsKey(string3 = libsMsg.getVanillaFormat()) && !string3.equals(string) && !this.translated.get(string3).equals(string3)) {
            string4 = this.translated.get(string3);
            for (ChatColor chatColor : ChatColor.values()) {
                string4 = string4.replace("\u00a7" + chatColor.getChar(), "<" + chatColor.name().toLowerCase(Locale.ROOT) + ">");
            }
        }
        this.translated.put(string, string4);
        try {
            boolean bl = this.getFile().exists();
            if (!bl) {
                this.getFile().getParentFile().mkdirs();
                this.getFile().createNewFile();
            }
            if (this.writer == null) {
                this.writer = new FileWriter(this.getFile(), true);
                if (!bl) {
                    this.writer.write("# To use translations in Lib's Disguises, you must have the purchased plugin\n");
                    if (this == MESSAGES) {
                        this.writer.write("# %s is where text is inserted, look up printf format codes if you're interested\n");
                    }
                    this.writer.write("# To translate, follow this example 'Original Message': 'My New Message'\n# The Original Message is used as a yaml config key to get your new message!");
                    this.writer.write("\n# To use hex color codes, use <#hexcolor> where hexcolor is the 6 char code");
                }
            }
            ChatColor[] chatColorArray = StringEscapeUtils.escapeJava((String)string.replace("\u00a7", "&"));
            String string5 = StringEscapeUtils.escapeJava((String)string4.replace("\u00a7", "&"));
            this.writer.write("\n" + (string2 != null ? "# " + string2 + "\n" : "") + "\"" + (String)chatColorArray + "\": \"" + string5 + "\"\n");
            ++this.written;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deDupeMessages() {
        try {
            if (!this.getFile().exists()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(new String(Files.readAllBytes(this.getFile().toPath())).split("\r?\n")));
            int n = 0;
            int n2 = 0;
            for (Map.Entry<String, Boolean> entry : this.toDeDupe.entrySet()) {
                boolean bl;
                String string = entry.getKey();
                boolean bl2 = bl = entry.getValue().booleanValue();
                String string2 = "\"" + string + "\": \"" + string + "\"";
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).equals(string2)) continue;
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    arrayList.remove(i);
                    if (bl) {
                        ++n2;
                    } else {
                        ++n;
                    }
                    if (arrayList.get(--i).startsWith("# Reference: ")) {
                        arrayList.remove(i);
                    }
                    if (arrayList.size() <= i || !arrayList.get(i).isEmpty()) continue;
                    arrayList.remove(i);
                }
            }
            if (n + n2 > 0) {
                DisguiseUtilities.getLogger().info("Removed " + n + " duplicate and " + n2 + " outdated translations from " + this.getFile().getName() + ", this was likely caused by a previous issue in the plugin");
                Files.write(this.getFile().toPath(), StringUtils.join(arrayList, (String)"\n").getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.toDeDupe.clear();
        }
    }

    public String reverseGet(String string) {
        if (string == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return string;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        for (Map.Entry<String, String> entry : this.translated.entrySet()) {
            if (!Objects.equals(entry.getValue().toLowerCase(Locale.ENGLISH), string2)) continue;
            return entry.getKey();
        }
        return string;
    }

    public String get(LibsMsg libsMsg) {
        return this.get(libsMsg.getRaw());
    }

    public String get(String string) {
        if (string == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return string;
        }
        String string2 = this.translated.get(string);
        return string2 == null ? string : string2;
    }
}

