/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SoundManager {
    public void load() {
        SoundGroup.getGroups().clear();
        this.loadSounds();
        this.loadCustomSounds();
    }

    private void loadCustomSounds() {
        Object object;
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "configs/sounds.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            object = new File(LibsDisguises.getInstance().getDataFolder(), "sounds.yml");
            if (((File)object).exists()) {
                ((File)object).renameTo(file);
            } else {
                LibsDisguises.getInstance().saveResource("configs/sounds.yml", false);
            }
        }
        object = YamlConfiguration.loadConfiguration((File)file);
        for (String string : object.getKeys(false)) {
            if (!object.isConfigurationSection(string) || string.equals("GroupName")) continue;
            if (SoundGroup.getGroups().keySet().stream().anyMatch(string2 -> string2.equalsIgnoreCase(string))) {
                DisguiseUtilities.getLogger().warning("The SoundGroup " + string + " has already been registered!");
                continue;
            }
            SoundGroup soundGroup = new SoundGroup(string);
            ConfigurationSection configurationSection = object.getConfigurationSection(string);
            for (SoundGroup.SoundType soundType : SoundGroup.SoundType.values()) {
                List list;
                if (soundType == SoundGroup.SoundType.CANCEL || (list = configurationSection.getStringList(soundType.name().charAt(0) + soundType.name().substring(1).toLowerCase(Locale.ENGLISH))) == null || list.isEmpty()) continue;
                for (String string3 : list) {
                    if (!string3.matches(".+:.+")) {
                        SoundGroup soundGroup2 = SoundGroup.getGroup(string3);
                        if (soundGroup2 == null) {
                            DisguiseUtilities.getLogger().warning("Invalid sound '" + string3 + "'! Must be a minecraft:sound.name or SoundGroup name!");
                            continue;
                        }
                        Object[] objectArray = soundGroup2.getDisguiseSounds().get((Object)soundType);
                        if (objectArray == null) {
                            DisguiseUtilities.getLogger().warning("Sound group '" + string3 + "' does not contain a category for " + (Object)((Object)soundType) + "! Can't use as default in " + string);
                            continue;
                        }
                        for (Object object2 : objectArray) {
                            soundGroup.addSound(object2, soundType);
                        }
                        continue;
                    }
                    soundGroup.addSound(string3, soundType);
                }
            }
            DisguiseUtilities.getLogger().info("Loaded sound group '" + string + "'");
        }
    }

    private void loadSounds() {
        try (InputStream inputStream = LibsDisguises.getInstance().getResource("ANTI_PIRACY_SECRET_FILE");){
            String[] stringArray;
            for (String string : stringArray = new String(ReflectionManager.readFuzzyFully(inputStream), StandardCharsets.UTF_8).split("\n")) {
                String[] stringArray2 = string.split("/", -1);
                SoundGroup soundGroup = new SoundGroup(stringArray2[0]);
                int n = 0;
                for (SoundGroup.SoundType soundType : SoundGroup.SoundType.values()) {
                    String[] stringArray3;
                    String string2;
                    if ((string2 = stringArray2[++n]).isEmpty()) continue;
                    for (String string3 : stringArray3 = string2.split(",")) {
                        try {
                            Sound sound = Sound.valueOf((String)string3);
                            soundGroup.addSound(sound, soundType);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (IOException | NoClassDefFoundError throwable) {
            throwable.printStackTrace();
        }
    }
}

