/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Sound;

public class SoundGroup {
    private static final LinkedHashMap<String, SoundGroup> groups = new LinkedHashMap();
    private float damageSoundVolume = 1.0f;
    private final LinkedHashMap<Object, SoundType> disguiseSoundTypes = new LinkedHashMap();
    private final LinkedHashMap<SoundType, Object[]> disguiseSounds = new LinkedHashMap();
    private boolean customSounds;

    public SoundGroup(String string) {
        groups.put(string, this);
        try {
            DisguiseType.valueOf(string);
        }
        catch (Exception exception) {
            this.customSounds = true;
        }
    }

    public void addSound(Object object, SoundType soundType) {
        Object object2 = object;
        if (object instanceof Sound) {
            object = ReflectionManager.getCraftSound((Sound)object);
        } else if (object instanceof String) {
            object = ReflectionManager.createMinecraftKey((String)object);
        } else if (!object.getClass().getSimpleName().equals("SoundEffect")) {
            throw new IllegalArgumentException("Unexpected " + object.getClass());
        }
        if (object == null) {
            return;
        }
        this.disguiseSoundTypes.putIfAbsent(object, soundType);
        if (this.disguiseSounds.containsKey((Object)soundType)) {
            Object[] objectArray = this.disguiseSounds.get((Object)soundType);
            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
            objectArray[objectArray.length - 1] = object;
            this.disguiseSounds.put(soundType, objectArray);
        } else {
            this.disguiseSounds.put(soundType, new Object[]{object});
        }
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public void setDamageAndIdleSoundVolume(float f) {
        this.damageSoundVolume = f;
    }

    public Object getSound(SoundType soundType) {
        if (soundType == null) {
            return null;
        }
        if (this.customSounds) {
            return this.getRandomSound(soundType);
        }
        Object[] objectArray = this.disguiseSounds.get((Object)soundType);
        if (objectArray == null) {
            return null;
        }
        return objectArray[0];
    }

    private Object getRandomSound(SoundType soundType) {
        if (soundType == null) {
            return null;
        }
        Object[] objectArray = this.disguiseSounds.get((Object)soundType);
        if (objectArray == null) {
            return null;
        }
        return objectArray[RandomUtils.nextInt((int)objectArray.length)];
    }

    public SoundType getSound(Object object) {
        if (object == null) {
            return null;
        }
        return this.disguiseSoundTypes.get(object);
    }

    public SoundType getType(Object object, boolean bl) {
        if (object == null) {
            return SoundType.CANCEL;
        }
        SoundType soundType = this.getSound(object);
        if (soundType == SoundType.DEATH || bl && soundType == SoundType.HURT) {
            return null;
        }
        return soundType;
    }

    public boolean isCancelSound(String string) {
        return this.getSound(string) == SoundType.CANCEL;
    }

    public static SoundGroup getGroup(Disguise disguise) {
        SoundGroup soundGroup;
        if (disguise.getSoundGroup() != null && (soundGroup = SoundGroup.getGroup(disguise.getSoundGroup())) != null) {
            return soundGroup;
        }
        return SoundGroup.getGroup(disguise.getType().name());
    }

    public static SoundGroup getGroup(String string) {
        return groups.get(string);
    }

    public static LinkedHashMap<String, SoundGroup> getGroups() {
        return groups;
    }

    public LinkedHashMap<Object, SoundType> getDisguiseSoundTypes() {
        return this.disguiseSoundTypes;
    }

    public LinkedHashMap<SoundType, Object[]> getDisguiseSounds() {
        return this.disguiseSounds;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

