/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ItemFrameWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ModdedWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.ClassMappings;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager {
    private static final HashMap<String, Enum> soundCategories = new HashMap();
    private static String bukkitVersion;
    private static Method itemAsCraftCopyMethod;
    private static Method itemAsNmsCopyMethod;
    private static Method damageAndIdleSoundMethod;
    private static Constructor<?> boundingBoxConstructor;
    private static Method setBoundingBoxMethod;
    private static Field pingField;
    private static Field entityCountField;
    private static Field chunkMapField;
    private static Field chunkProviderField;
    private static Field entityTrackerField;
    private static Field trackedEntitiesField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Method ihmGet;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field trackerField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field entitiesField;
    private static NmsVersion version;
    private static Method itemAsBukkitMethod;
    private static Method soundEffectMethod;
    private static Method getServerMethod;
    private static Method getEnumArtMethod;
    private static Constructor blockPositionConstructor;
    private static Method enumDirectionMethod;
    private static Enum[] enumPlayerInfoAction;
    private static Constructor chatComponentConstructor;
    private static Constructor packetPlayOutConstructor;
    private static Enum[] enumGamemode;
    private static Method getNmsEntityMethod;
    private static Enum[] enumItemSlots;
    private static Method soundGetMethod;
    private static Method soundEffectGetMethod;
    private static Field soundEffectGetKey;
    private static Constructor vector3FConstructor;
    private static Method enumDirectionFrom;
    private static Constructor villagerDataConstructor;
    private static Method bukkitKeyToNms;
    private static Method registryBlocksGetMethod;
    private static Object villagerTypeRegistry;
    private static Object villagerProfessionRegistry;
    private static Constructor dataWatcherItemConstructor;
    private static Constructor vec3DConstructor;
    private static Method entityTypesAMethod;
    private static Class entityPoseClass;
    private static Method craftBlockDataGetState;
    private static Method getOldItemAsBlock;
    private static Method magicGetBlock;
    private static Method magicGetMaterial;
    private static Method getNmsItem;
    private static Method getBlockData;
    private static Method getBlockDataAsId;
    private static Method getNmsWorld;
    private static Method deserializedItemMeta;
    private static Method mobEffectList;
    private static Constructor mobEffectConstructor;
    private static Method boundingBoxMethod;
    private static Method bukkitEntityMethod;
    private static Method connectionEntityMethod;
    private static Field noDamageTicks;
    private static Method isInvul;
    private static Object genericDamage;
    private static Field playerConnection;
    private static Method incrementedInventoryStateId;
    private static Field playerInventoryContainer;
    private static ReflectionManagerAbstract nmsReflection;

    public static void init() {
        Class<?> clazz;
        try {
            if (NmsVersion.v1_14.isSupported()) {
                entityPoseClass = ReflectionManager.getNmsClass("EntityPose");
            }
            if ((nmsReflection = ReflectionManager.getReflectionManager(ReflectionManager.getVersion())) != null) {
                return;
            }
            boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
            entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
            mobEffectConstructor = ReflectionManager.getNmsConstructor("MobEffect", ReflectionManager.getNmsClass("MobEffectList"), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            mobEffectList = ReflectionManager.getNmsMethod("MobEffectList", "fromId", Integer.TYPE);
            boundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]);
            bukkitEntityMethod = ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]);
            clazz = ReflectionManager.getCraftClass("CraftItemStack");
            itemAsCraftCopyMethod = ReflectionManager.getCraftMethod(clazz, "asCraftCopy", ItemStack.class);
            itemAsNmsCopyMethod = ReflectionManager.getCraftMethod(clazz, "asNMSCopy", ItemStack.class);
            itemAsBukkitMethod = ReflectionManager.getCraftMethod(clazz, "asBukkitCopy", ReflectionManager.getNmsClass("ItemStack"));
            getServerMethod = ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]);
            getEnumArtMethod = ReflectionManager.getCraftMethod("CraftArt", "BukkitToNotch", Art.class);
            blockPositionConstructor = ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            enumDirectionMethod = ReflectionManager.getNmsMethod("EnumDirection", "fromType2", Integer.TYPE);
            enumPlayerInfoAction = (Enum[])ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction").getEnumConstants();
            chatComponentConstructor = ReflectionManager.getNmsConstructor("ChatComponentText", String.class);
            packetPlayOutConstructor = ReflectionManager.getNmsConstructor("PacketPlayOutPlayerInfo$PlayerInfoData", ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo"), GameProfile.class, Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent"));
            enumGamemode = (Enum[])ReflectionManager.getNmsClass("EnumGamemode").getEnumConstants();
            getNmsEntityMethod = ReflectionManager.getCraftMethod("CraftEntity", "getHandle", new Class[0]);
            enumItemSlots = (Enum[])ReflectionManager.getNmsClass("EnumItemSlot").getEnumConstants();
            Class<?> clazz2 = ReflectionManager.getCraftClass("CraftSound");
            try {
                soundGetMethod = clazz2.getMethod("getSound", Sound.class);
            }
            catch (Exception exception) {
                soundEffectGetMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", Sound.class);
                soundEffectGetKey = ReflectionManager.getNmsField("SoundEffect", "b");
            }
            soundEffectMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", String.class);
            vector3FConstructor = ReflectionManager.getNmsConstructor("Vector3f", Float.TYPE, Float.TYPE, Float.TYPE);
            enumDirectionFrom = ReflectionManager.getNmsMethod("EnumDirection", "fromType1", Integer.TYPE);
            getBlockData = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "getBlockData", new Class[0]);
            if (NmsVersion.v1_13.isSupported()) {
                craftBlockDataGetState = ReflectionManager.getCraftMethod("CraftBlockData", "getState", new Class[0]);
                magicGetBlock = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getBlock", Material.class);
                magicGetMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Block"));
                entityTypesAMethod = ReflectionManager.getNmsMethod("EntityTypes", "a", String.class);
                if (NmsVersion.v1_14.isSupported()) {
                    registryBlocksGetMethod = ReflectionManager.getNmsMethod("RegistryBlocks", "get", ReflectionManager.getNmsClass("MinecraftKey"));
                    villagerDataConstructor = ReflectionManager.getNmsConstructor("VillagerData", ReflectionManager.getNmsClass("VillagerType"), ReflectionManager.getNmsClass("VillagerProfession"), Integer.TYPE);
                    villagerProfessionRegistry = ReflectionManager.getNmsField("IRegistry", "VILLAGER_PROFESSION").get(null);
                    villagerTypeRegistry = ReflectionManager.getNmsField("IRegistry", "VILLAGER_TYPE").get(null);
                } else {
                    registryBlocksGetMethod = ReflectionManager.getNmsMethod("RegistryBlocks", "getOrDefault", ReflectionManager.getNmsClass("MinecraftKey"));
                }
            }
            bukkitKeyToNms = ReflectionManager.getCraftMethod("CraftNamespacedKey", "toMinecraft", NamespacedKey.class);
            dataWatcherItemConstructor = ReflectionManager.getNmsConstructor("DataWatcher$Item", ReflectionManager.getNmsClass("DataWatcherObject"), Object.class);
            vec3DConstructor = ReflectionManager.getNmsConstructor("Vec3D", Double.TYPE, Double.TYPE, Double.TYPE);
            getOldItemAsBlock = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "asBlock", ReflectionManager.getNmsClass("Item"));
            getNmsItem = ReflectionManager.getNmsMethod("ItemStack", "getItem", new Class[0]);
            getBlockDataAsId = ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData"));
            getNmsWorld = ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]);
            deserializedItemMeta = ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass("CraftMetaItem$SerializableMeta"), "deserialize", Map.class);
            noDamageTicks = ReflectionManager.getNmsField("Entity", "noDamageTicks");
            isInvul = ReflectionManager.getNmsMethod("Entity", "isInvulnerable", ReflectionManager.getNmsClass("DamageSource"));
            for (Field field : ReflectionManager.getNmsClass("DamageSource").getFields()) {
                Object object;
                if (!Modifier.isStatic(field.getModifiers()) || (object = field.get(null)) == null || !object.toString().contains("(generic)")) continue;
                genericDamage = object;
                break;
            }
            Method method = ReflectionManager.getNmsMethod("SoundCategory", "a", new Class[0]);
            for (Enum enum_ : (Enum[])ReflectionManager.getNmsClass("SoundCategory").getEnumConstants()) {
                soundCategories.put((String)method.invoke((Object)enum_, new Object[0]), enum_);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            clazz = ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityCow").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float f = ((Float)method.invoke((Object)clazz, new Object[0])).floatValue();
                if (((Float)method.invoke((Object)clazz, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethod(method.getName(), new Class[0]);
                damageAndIdleSoundMethod.setAccessible(true);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        if (NmsVersion.v1_14.isSupported()) {
            chunkMapField = ReflectionManager.getNmsField("ChunkProviderServer", "playerChunkMap");
            trackedEntitiesField = ReflectionManager.getNmsField("PlayerChunkMap", "trackedEntities");
            entityTrackerField = ReflectionManager.getNmsField("PlayerChunkMap$EntityTracker", "trackerEntry");
            chunkProviderField = NmsVersion.v1_16.isSupported() ? ReflectionManager.getNmsField("WorldServer", "chunkProvider") : ReflectionManager.getNmsField("World", "chunkProvider");
        } else {
            trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
            entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
            ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        }
    }

    public static boolean hasInvul(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.hasInvul(entity);
        }
        Object object = ReflectionManager.getNmsEntity(entity);
        try {
            if (entity instanceof LivingEntity) {
                return noDamageTicks.getInt(object) > 0;
            }
            return (Boolean)isInvul.invoke(object, genericDamage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static int getIncrementedStateId(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getIncrementedStateId(player);
        }
        try {
            Object object = playerInventoryContainer.get(ReflectionManager.getNmsEntity((Entity)player));
            return (Integer)incrementedInventoryStateId.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static boolean isSupported(AccessibleObject accessibleObject) {
        Annotation annotation;
        if (accessibleObject.isAnnotationPresent(NmsAddedIn.class) && !(annotation = accessibleObject.getAnnotation(NmsAddedIn.class)).value().isSupported()) {
            return false;
        }
        if (accessibleObject.isAnnotationPresent(NmsRemovedIn.class)) {
            annotation = accessibleObject.getAnnotation(NmsRemovedIn.class);
            return !annotation.value().isSupported();
        }
        return true;
    }

    public static boolean isSupported(Class clazz, String string) {
        try {
            for (Field accessibleObject : clazz.getFields()) {
                if (!accessibleObject.getName().equals(string)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(string)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(File file, String string) {
        try (JarFile jarFile = new JarFile(file);){
            String string2;
            block13: {
                JarEntry jarEntry = jarFile.getJarEntry(string);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    string2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static YamlConfiguration getPluginYAML(File file) {
        try {
            String string = ReflectionManager.getResourceAsString(file, "plugin.yml");
            if (string == null) {
                return null;
            }
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            yamlConfiguration.loadFromString(ReflectionManager.getResourceAsString(file, "plugin.yml"));
            return yamlConfiguration;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static YamlConfiguration getPluginYAMLEx(File file) {
        String string = ReflectionManager.getResourceAsString(file, "plugin.yml");
        if (string == null) {
            return null;
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.loadFromString(ReflectionManager.getResourceAsString(file, "plugin.yml"));
        return yamlConfiguration;
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean bl) {
        if (nmsReflection != null) {
            return nmsReflection.getNewEntityId(bl);
        }
        try {
            Number number = (Number)entityCountField.get(null);
            if (bl) {
                if (NmsVersion.v1_14.isSupported()) {
                    return ((AtomicInteger)number).incrementAndGet();
                }
                int n = number.intValue();
                entityCountField.set(null, n + 1);
                return n;
            }
            return number.intValue();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return -1;
        }
    }

    public static Object getPlayerConnectionOrPlayer(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getPlayerConnectionOrPlayer(player);
        }
        try {
            return ReflectionManager.getNmsEntity((Entity)player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Object createEntityInstance(DisguiseType disguiseType, String string) {
        if (nmsReflection != null) {
            return nmsReflection.createEntityInstance(string);
        }
        try {
            Object t;
            Class clazz = ReflectionManager.getNmsClass("Entity" + string);
            Object object = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (string.equals("Player")) {
                Object object2 = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                WrappedGameProfile wrappedGameProfile = ReflectionManager.getGameProfile(new UUID(0L, 0L), "Steve");
                Object t2 = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass(NmsVersion.v1_14.isSupported() ? "WorldServer" : "World")).newInstance(object);
                t = clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), wrappedGameProfile.getHandleType(), t2.getClass()).newInstance(object2, object, wrappedGameProfile.getHandle(), t2);
            } else {
                t = string.equals("EnderPearl") ? clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(object, ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow")) : (string.equals("FishingHook") ? (NmsVersion.v1_14.isSupported() ? clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityHuman"), ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"), object, 0, 0) : clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(object, ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"))) : (!NmsVersion.v1_14.isSupported() && string.equals("Potion") ? clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(object, 0.0, 0.0, 0.0, ReflectionManager.getNmsItem(new ItemStack(Material.SPLASH_POTION))) : (NmsVersion.v1_14.isSupported() ? clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityTypes"), ReflectionManager.getNmsClass("World")).newInstance(ReflectionManager.getEntityType(disguiseType.getEntityType()), object) : clazz.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(object))));
            }
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(t, 1, 1, 1);
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(t, 0, 0, 0);
            return t;
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Error while attempting to create entity instance for " + disguiseType.name());
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getMobEffectList(int n) {
        if (nmsReflection != null) {
            return nmsReflection.getMobEffectList(n);
        }
        try {
            return mobEffectList.invoke(null, n);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static Object createMobEffect(PotionEffect potionEffect) {
        return ReflectionManager.createMobEffect(potionEffect.getType().getId(), potionEffect.getDuration(), potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles());
    }

    public static Object createMobEffect(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (nmsReflection != null) {
            return nmsReflection.createMobEffect(n, n2, n3, bl, bl2);
        }
        try {
            return mobEffectConstructor.newInstance(ReflectionManager.getMobEffectList(n), n2, n3, bl, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        if (nmsReflection != null) {
            double d = nmsReflection.getXBoundingBox(entity);
            double d2 = nmsReflection.getYBoundingBox(entity);
            double d3 = nmsReflection.getZBoundingBox(entity);
            return new FakeBoundingBox(d, d2, d3);
        }
        try {
            Object object = boundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double d = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int n = 0;
            block10: for (Field field : object.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double") || Modifier.isStatic(field.getModifiers())) continue;
                switch (++n) {
                    case 1: {
                        d -= field.getDouble(object);
                        continue block10;
                    }
                    case 2: {
                        d4 -= field.getDouble(object);
                        continue block10;
                    }
                    case 3: {
                        d5 -= field.getDouble(object);
                        continue block10;
                    }
                    case 4: {
                        d += field.getDouble(object);
                        continue block10;
                    }
                    case 5: {
                        d4 += field.getDouble(object);
                        continue block10;
                    }
                    case 6: {
                        d5 += field.getDouble(object);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(d, d4, d5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerFromPlayerConnection(Object object) {
        if (nmsReflection != null) {
            return nmsReflection.getPlayerFromPlayerConnection(object);
        }
        try {
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object object) {
        if (nmsReflection != null) {
            return nmsReflection.getBukkitEntity(object);
        }
        try {
            return (Entity)bukkitEntityMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object object) {
        if (nmsReflection != null) {
            return nmsReflection.getBukkitItem(object);
        }
        try {
            return (ItemStack)itemAsBukkitMethod.invoke(null, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getCraftItem(ItemStack itemStack) {
        if (nmsReflection != null) {
            return nmsReflection.getCraftItem(itemStack);
        }
        try {
            return (ItemStack)itemAsCraftCopyMethod.invoke(null, itemStack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static NmsVersion getVersion() {
        if (version == null) {
            ReflectionManager.getBukkitVersion();
        }
        return version;
    }

    public static String getBukkitVersion() {
        if (bukkitVersion == null) {
            bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
            for (NmsVersion nmsVersion : NmsVersion.values()) {
                if (!ReflectionManager.getBukkitVersion().startsWith(nmsVersion.name())) continue;
                version = nmsVersion;
                break;
            }
        }
        return bukkitVersion;
    }

    public static Class<?> getCraftClass(String string) {
        try {
            return Class.forName(ReflectionManager.getLocation("org.bukkit.craftbukkit", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ReflectionManagerAbstract getReflectionManager(NmsVersion nmsVersion) {
        try {
            Class<?> clazz = Class.forName("me.libraryaddict.disguise.utilities.reflection." + nmsVersion.name() + ".ReflectionManager");
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (ReflectionManagerAbstract)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        return null;
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... classArray) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String string, Class<?> ... classArray) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(string), classArray);
    }

    public static Object getCraftSound(Sound sound) {
        if (nmsReflection != null) {
            return nmsReflection.getCraftSound(sound);
        }
        try {
            return soundEffectMethod.invoke(null, ReflectionManager.getSoundString(sound));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTrackerEntry(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTrackerEntry(entity);
        }
        Object object = ReflectionManager.getWorldServer(entity.getWorld());
        if (NmsVersion.v1_14.isSupported()) {
            Object object2 = chunkProviderField.get(object);
            Object object3 = chunkMapField.get(object2);
            Map map = (Map)trackedEntitiesField.get(object3);
            Object v = map.get(entity.getEntityId());
            if (v == null) {
                return null;
            }
            return entityTrackerField.get(v);
        }
        Object object4 = trackerField.get(object);
        Object object5 = entitiesField.get(object4);
        return ihmGet.invoke(object5, entity.getEntityId());
    }

    public static Object getMinecraftServer() {
        if (nmsReflection != null) {
            return nmsReflection.getMinecraftServer();
        }
        try {
            return getServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static String getEnumArt(Art art) {
        if (nmsReflection != null) {
            return nmsReflection.getEnumArt(art);
        }
        try {
            Object object = getEnumArtMethod.invoke(null, art);
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                return (String)field.get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Object getBlockPosition(int n, int n2, int n3) {
        if (nmsReflection != null) {
            return nmsReflection.getBlockPosition(n, n2, n3);
        }
        try {
            return blockPositionConstructor.newInstance(n, n2, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumDirection(int n) {
        if (nmsReflection != null) {
            return nmsReflection.getEnumDirection(n);
        }
        try {
            return (Enum)enumDirectionMethod.invoke(null, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumPlayerInfoAction(int n) {
        if (nmsReflection != null) {
            return nmsReflection.getEnumPlayerInfoAction(n);
        }
        try {
            return enumPlayerInfoAction[n];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInfoData(Object object, WrappedGameProfile wrappedGameProfile) {
        if (nmsReflection != null) {
            return nmsReflection.getPlayerInfoData(wrappedGameProfile);
        }
        try {
            Object t = chatComponentConstructor.newInstance(wrappedGameProfile.getName());
            return packetPlayOutConstructor.newInstance(object, wrappedGameProfile.getHandle(), 0, enumGamemode[1], t);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getGameProfile(Player player) {
        return WrappedGameProfile.fromPlayer((Player)player);
    }

    public static WrappedGameProfile getGameProfile(UUID uUID, String string) {
        return ReflectionManagerAbstract.getGameProfile(uUID == null ? ReflectionManager.getRandomUUID() : uUID, string);
    }

    public static WrappedGameProfile getClonedProfile(WrappedGameProfile wrappedGameProfile) {
        return ReflectionManager.getGameProfileWithThisSkin(null, wrappedGameProfile.getName(), wrappedGameProfile);
    }

    public static WrappedGameProfile getGameProfileWithThisSkin(UUID uUID, String string, WrappedGameProfile wrappedGameProfile) {
        try {
            WrappedGameProfile wrappedGameProfile2 = new WrappedGameProfile(uUID != null ? uUID : ReflectionManager.getRandomUUID(), string == null || string.length() < 17 ? string : string.substring(0, 16));
            if (wrappedGameProfile != null) {
                wrappedGameProfile2.getProperties().putAll(wrappedGameProfile.getProperties());
            }
            return wrappedGameProfile2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static UUID getRandomUUID() {
        UUID uUID = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uUID;
        }
        return new UUID(uUID.getMostSignificantBits() & 0xFFFFFFFFFFFFBFFFL | (long)DisguiseConfig.getUUIDGeneratedVersion() << 12, uUID.getLeastSignificantBits());
    }

    private static String getLocation(String string, String string2) {
        return ClassMappings.getClass(string, string2);
    }

    public static Class getNmsClass(String string) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String string) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... classArray) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String string, Class<?> ... classArray) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(string), classArray);
    }

    public static Object getNmsEntity(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.getNmsEntity(entity);
        }
        try {
            return getNmsEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String string, String string2) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(string), string2);
    }

    public static Object getNmsItem(ItemStack itemStack) {
        if (nmsReflection != null) {
            return nmsReflection.getNmsItem(itemStack);
        }
        try {
            return itemAsNmsCopyMethod.invoke(null, itemStack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Method getCraftMethod(String string, String string2, Class<?> ... classArray) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(string), string2, classArray);
    }

    public static Method getCraftMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String string, String string2, Class<?> ... classArray) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(string), string2, classArray);
    }

    public static double getPing(Player player) {
        if (nmsReflection != null) {
            return nmsReflection.getPing(player);
        }
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        if (nmsReflection != null) {
            return nmsReflection.getSize(entity);
        }
        try {
            if (NmsVersion.v1_14.isSupported()) {
                Object object = ReflectionManager.getNmsField("Entity", "size").get(ReflectionManager.getNmsEntity(entity));
                float f = ReflectionManager.getNmsField("EntitySize", "width").getFloat(object);
                float f2 = ReflectionManager.getNmsField("Entity", "headHeight").getFloat(ReflectionManager.getNmsEntity(entity));
                return new float[]{f, f2};
            }
            float f = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float f3 = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{f, f3};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getSkullBlob(WrappedGameProfile wrappedGameProfile) {
        if (nmsReflection != null) {
            return nmsReflection.getSkullBlob(wrappedGameProfile);
        }
        try {
            Object object = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                Object object2 = method.invoke(object, new Object[0]);
                return WrappedGameProfile.fromHandle((Object)object2.getClass().getDeclaredMethod("fillProfileProperties", wrappedGameProfile.getHandleType(), Boolean.TYPE).invoke(object2, wrappedGameProfile.getHandle(), true));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Float getSoundModifier(Object object) {
        if (nmsReflection != null) {
            return nmsReflection.getSoundModifier(object);
        }
        try {
            return (Float)damageAndIdleSoundMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WrappedGameProfile grabProfileAddUUID(String string) {
        try {
            Object object = ReflectionManager.getMinecraftServer();
            LibsProfileLookupCaller libsProfileLookupCaller = new LibsProfileLookupCaller();
            if (nmsReflection != null) {
                nmsReflection.injectCallback(string, libsProfileLookupCaller);
            } else {
                for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                    if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                    Object object2 = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                    Object object3 = method.invoke(object, new Object[0]);
                    method.getReturnType().getMethod("findProfilesByNames", String[].class, object2.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(object3, new String[]{string}, object2, libsProfileLookupCaller);
                    break;
                }
            }
            if (libsProfileLookupCaller.getGameProfile() != null) {
                return libsProfileLookupCaller.getGameProfile();
            }
            return ReflectionManager.getGameProfile(null, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox fakeBoundingBox) {
        if (nmsReflection != null) {
            nmsReflection.setBoundingBox(entity, fakeBoundingBox.getX(), fakeBoundingBox.getY(), fakeBoundingBox.getZ());
            return;
        }
        try {
            Location location = entity.getLocation();
            Object obj = boundingBoxConstructor.newInstance(location.getX() - fakeBoundingBox.getX() / 2.0, location.getY(), location.getZ() - fakeBoundingBox.getZ() / 2.0, location.getX() + fakeBoundingBox.getX() / 2.0, location.getY() + fakeBoundingBox.getY(), location.getZ() + fakeBoundingBox.getZ() / 2.0);
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Enum getSoundCategory(String string) {
        if (nmsReflection != null) {
            return nmsReflection.getSoundCategory(string);
        }
        return soundCategories.get(string);
    }

    public static Enum getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return ReflectionManager.getSoundCategory("player");
        }
        Class clazz = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getSoundCategory("hostile");
        }
        if (Ambient.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getSoundCategory("ambient");
        }
        return ReflectionManager.getSoundCategory("neutral");
    }

    public static Enum createEnumItemSlot(EquipmentSlot equipmentSlot) {
        if (nmsReflection != null) {
            return nmsReflection.createEnumItemSlot(equipmentSlot);
        }
        switch (equipmentSlot) {
            case HAND: {
                return enumItemSlots[0];
            }
            case OFF_HAND: {
                return enumItemSlots[1];
            }
            case FEET: {
                return enumItemSlots[2];
            }
            case LEGS: {
                return enumItemSlots[3];
            }
            case CHEST: {
                return enumItemSlots[4];
            }
            case HEAD: {
                return enumItemSlots[5];
            }
        }
        return null;
    }

    public static EquipmentSlot createEquipmentSlot(Object object) {
        try {
            Enum enum_ = (Enum)object;
            switch (enum_.name()) {
                case "MAINHAND": {
                    return EquipmentSlot.HAND;
                }
                case "OFFHAND": {
                    return EquipmentSlot.OFF_HAND;
                }
                case "FEET": {
                    return EquipmentSlot.FEET;
                }
                case "LEGS": {
                    return EquipmentSlot.LEGS;
                }
                case "CHEST": {
                    return EquipmentSlot.CHEST;
                }
                case "HEAD": {
                    return EquipmentSlot.HEAD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getEquipment(EquipmentSlot equipmentSlot, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        switch (equipmentSlot) {
            case HAND: {
                return ((LivingEntity)entity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)entity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)entity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)entity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)entity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)entity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static Object getSoundString(Sound sound) {
        if (nmsReflection != null) {
            return nmsReflection.getSoundString(sound);
        }
        try {
            if (soundGetMethod == null) {
                return soundEffectGetKey.get(soundEffectGetMethod.invoke(null, sound)).toString();
            }
            return soundGetMethod.invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClass(Class clazz) {
        if (VillagerData.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("VillagerData");
        }
        if (BlockPosition.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("BlockPosition");
        }
        if (WrappedBlockData.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("IBlockData");
        }
        if (ItemStack.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("ItemStack");
        }
        if (WrappedChatComponent.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("IChatBaseComponent");
        }
        if (Vector3F.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("Vector3f");
        }
        if (EulerAngle.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("Vector3f");
        }
        if (EnumWrappers.Direction.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("EnumDirection");
        }
        if (WrappedParticle.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("ParticleParam");
        }
        if (EntityPose.class.isAssignableFrom(clazz)) {
            return entityPoseClass;
        }
        if (NbtWrapper.class.isAssignableFrom(clazz)) {
            return ReflectionManager.getNmsClass("NBTTagCompound");
        }
        return clazz;
    }

    public static Object convertInvalidMeta(Object object) {
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            if (!optional.isPresent()) {
                return NmsVersion.v1_13.isSupported() ? object : com.google.common.base.Optional.absent();
            }
            if (nmsReflection != null) {
                return nmsReflection.convertOptional(optional.get());
            }
            Object object2 = optional.get();
            if (object2 instanceof BlockPosition) {
                BlockPosition blockPosition = (BlockPosition)object2;
                try {
                    Object t = blockPositionConstructor.newInstance(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
                    return NmsVersion.v1_13.isSupported() ? Optional.of(t) : com.google.common.base.Optional.of(t);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (object2 instanceof WrappedBlockData) {
                try {
                    Object object3 = ((WrappedBlockData)object2).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(object3) : com.google.common.base.Optional.of((Object)object3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (object2 instanceof ItemStack) {
                    if ((object2 = ReflectionManager.getNmsItem((ItemStack)object2)) == null) {
                        return NmsVersion.v1_13.isSupported() ? Optional.empty() : com.google.common.base.Optional.absent();
                    }
                    return Optional.of(object2);
                }
                if (object2 instanceof WrappedChatComponent) {
                    Object object4 = ((WrappedChatComponent)object2).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(object4) : com.google.common.base.Optional.of((Object)object4);
                }
                if (!NmsVersion.v1_13.isSupported()) {
                    return com.google.common.base.Optional.of(object2);
                }
            }
        } else if (object instanceof Vector3F) {
            Vector3F vector3F = (Vector3F)object;
            if (nmsReflection != null) {
                return nmsReflection.convertVec3(vector3F);
            }
            try {
                return vector3FConstructor.newInstance(Float.valueOf(vector3F.getX()), Float.valueOf(vector3F.getY()), Float.valueOf(vector3F.getZ()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            if (nmsReflection != null) {
                return nmsReflection.convertVec3(eulerAngle);
            }
            try {
                return vector3FConstructor.newInstance(Float.valueOf((float)eulerAngle.getX()), Float.valueOf((float)eulerAngle.getY()), Float.valueOf((float)eulerAngle.getZ()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof EnumWrappers.Direction) {
            if (nmsReflection != null) {
                return nmsReflection.convertDirection((EnumWrappers.Direction)object);
            }
            try {
                return enumDirectionFrom.invoke(null, ((EnumWrappers.Direction)object).ordinal());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof BlockPosition) {
            BlockPosition blockPosition = (BlockPosition)object;
            if (nmsReflection != null) {
                return nmsReflection.getBlockPosition(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
            }
            try {
                return blockPositionConstructor.newInstance(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (object instanceof ItemStack) {
                return ReflectionManager.getNmsItem((ItemStack)object);
            }
            if (object instanceof Double) {
                return Float.valueOf(((Double)object).floatValue());
            }
            if (object instanceof NbtWrapper) {
                return ((NbtWrapper)object).getHandle();
            }
            if (object instanceof WrappedParticle) {
                return ((WrappedParticle)object).getHandle();
            }
            if (object instanceof EntityPose) {
                return ReflectionManager.getNmsEntityPose((EntityPose)((Object)object));
            }
            if (object instanceof VillagerData) {
                return ReflectionManager.getNmsVillagerData((VillagerData)object);
            }
            if (object instanceof WrappedChatComponent) {
                return ((WrappedChatComponent)object).getHandle();
            }
        }
        return object;
    }

    public static Material getMaterial(String string) {
        if (nmsReflection != null) {
            return nmsReflection.getMaterial(string);
        }
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                Method method = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterialFromInternalName", String.class);
                Object object = method.getDeclaringClass().getField("INSTANCE").get(null);
                return (Material)method.invoke(object, string);
            }
            Object t = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(string);
            Object object = ReflectionManager.getNmsField("IRegistry", "ITEM").get(null);
            Method method = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("RegistryMaterials"), "get", t.getClass());
            Object object2 = method.invoke(object, t);
            if (object2 == null) {
                return null;
            }
            Method method2 = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Item"));
            return (Material)method2.invoke(null, object2);
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().severe("Error when trying to convert '" + string + "' into a Material");
            exception.printStackTrace();
            if (exception.getCause() != null) {
                exception.getCause().printStackTrace();
            }
            return null;
        }
    }

    public static String getItemName(Material material) {
        if (nmsReflection != null) {
            return nmsReflection.getItemName(material);
        }
        try {
            Object object = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getItem", Material.class).invoke(null, material);
            if (object == null) {
                return null;
            }
            Object object2 = NmsVersion.v1_13.isSupported() ? ReflectionManager.getNmsField("IRegistry", "ITEM").get(null) : ReflectionManager.getNmsField("Item", "REGISTRY").get(null);
            Method method = ReflectionManager.getNmsMethod(object2.getClass(), NmsVersion.v1_13.isSupported() ? "getKey" : "b", Object.class);
            Object object3 = method.invoke(object2, object);
            if (object3 == null) {
                return null;
            }
            return (String)ReflectionManager.getNmsMethod("MinecraftKey", "getKey", new Class[0]).invoke(object3, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getNmsVillagerData(VillagerData villagerData) {
        if (nmsReflection != null) {
            return nmsReflection.getNmsVillagerData(villagerData.getType(), villagerData.getProfession());
        }
        Object object = ReflectionManager.getVillagerType(villagerData.getType());
        Object object2 = ReflectionManager.getVillagerProfession(villagerData.getProfession());
        try {
            return villagerDataConstructor.newInstance(object, object2, villagerData.getLevel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getVillagerType(Villager.Type type) {
        if (nmsReflection != null) {
            return nmsReflection.getVillagerType(type);
        }
        try {
            Object object = bukkitKeyToNms.invoke(null, type.getKey());
            return registryBlocksGetMethod.invoke(villagerTypeRegistry, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (!NmsVersion.v1_14.isSupported() && clazz != clazz2 && clazz == OcelotWatcher.class) {
            clazz = TameableWatcher.class;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static Class getSuperClass(Class clazz) {
        if (clazz == FlagWatcher.class) {
            return null;
        }
        if (!NmsVersion.v1_14.isSupported() && clazz == OcelotWatcher.class) {
            return TameableWatcher.class;
        }
        return clazz.getSuperclass();
    }

    public static Object getVillagerProfession(Villager.Profession profession) {
        if (nmsReflection != null) {
            return nmsReflection.getVillagerProfession(profession);
        }
        try {
            Object object = bukkitKeyToNms.invoke(null, profession.getKey());
            return registryBlocksGetMethod.invoke(villagerProfessionRegistry, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getMinecraftVersion() {
        String string = Bukkit.getVersion();
        string = string.substring(string.lastIndexOf(" ") + 1, string.length() - 1);
        return string;
    }

    public static WrappedDataWatcher.WrappedDataWatcherObject createDataWatcherObject(MetaIndex metaIndex, Object object) {
        if (object == null) {
            return null;
        }
        return new WrappedDataWatcher.WrappedDataWatcherObject(metaIndex.getIndex(), metaIndex.getSerializer());
    }

    public static Object createDataWatcherItem(MetaIndex metaIndex, Object object) {
        WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject = ReflectionManager.createDataWatcherObject(metaIndex, object);
        if (nmsReflection != null) {
            return nmsReflection.createDataWatcherItem(wrappedDataWatcherObject, ReflectionManager.convertInvalidMeta(object));
        }
        try {
            return dataWatcherItemConstructor.newInstance(wrappedDataWatcherObject.getHandle(), ReflectionManager.convertInvalidMeta(object));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Object createSoundEffect(String string) {
        if (nmsReflection != null) {
            return nmsReflection.createSoundEffect(string);
        }
        try {
            return ReflectionManager.getNmsConstructor("SoundEffect", ReflectionManager.getNmsClass("MinecraftKey")).newInstance(ReflectionManager.createMinecraftKey(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object createMinecraftKey(String string) {
        if (nmsReflection != null) {
            return nmsReflection.createMinecraftKey(string);
        }
        try {
            return ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getVec3D(Vector vector) {
        if (nmsReflection != null) {
            return nmsReflection.getVec3D(vector);
        }
        try {
            return vec3DConstructor.newInstance(vector.getX(), vector.getY(), vector.getZ());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getEntityType(EntityType entityType) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityType(entityType);
        }
        try {
            Object object = entityTypesAMethod.invoke(null, entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName());
            if (NmsVersion.v1_14.isSupported()) {
                return ((Optional)object).orElse(null);
            }
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object registerEntityType(NamespacedKey namespacedKey) {
        if (nmsReflection != null) {
            return nmsReflection.registerEntityType(namespacedKey);
        }
        try {
            Object t = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(namespacedKey.toString());
            Class clazz = ReflectionManager.getNmsClass("IRegistry");
            Object object = clazz.getField("ENTITY_TYPE").get(null);
            Constructor<?> constructor = ReflectionManager.getNmsClass("EntityTypes").getConstructors()[0];
            Object obj = NmsVersion.v1_16.isSupported() ? constructor.newInstance(null, null, false, false, false, false, null, null, 0, 0) : constructor.newInstance(null, null, false, false, false, false, null);
            for (Field field : obj.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                field.setAccessible(true);
                field.set(obj, namespacedKey.toString());
                break;
            }
            clazz.getMethod("a", clazz, t.getClass(), Object.class).invoke(null, object, t, obj);
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + namespacedKey);
        }
    }

    public static int getEntityTypeId(Object object) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTypeId(object);
        }
        try {
            Class clazz = ReflectionManager.getNmsClass("IRegistry");
            Object object2 = clazz.getField("ENTITY_TYPE").get(null);
            return (Integer)object2.getClass().getMethod("a", Object.class).invoke(object2, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + object);
        }
    }

    public static int getEntityTypeId(EntityType entityType) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityTypeId(entityType);
        }
        try {
            if (NmsVersion.v1_13.isSupported()) {
                Object object = ReflectionManager.getEntityType(entityType);
                Class clazz = ReflectionManager.getNmsClass("IRegistry");
                Object object2 = clazz.getField("ENTITY_TYPE").get(null);
                return (Integer)object2.getClass().getMethod("a", Object.class).invoke(object2, object);
            }
            return entityType.getTypeId();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityType);
        }
    }

    public static Object getEntityType(NamespacedKey namespacedKey) {
        if (nmsReflection != null) {
            return nmsReflection.getEntityType(namespacedKey);
        }
        try {
            Class clazz = ReflectionManager.getNmsClass("IRegistry");
            Object object = clazz.getField("ENTITY_TYPE").get(null);
            Object t = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(namespacedKey.toString());
            return object.getClass().getMethod("a", t.getClass()).invoke(object, t);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("The entity " + namespacedKey + " is not registered!");
        }
    }

    public static Object getNmsEntityPose(EntityPose entityPose) {
        if (nmsReflection != null) {
            return nmsReflection.getNmsEntityPose(entityPose == EntityPose.SNEAKING && NmsVersion.v1_15.isSupported() ? "CROUCHING" : entityPose.name());
        }
        return Enum.valueOf(entityPoseClass, entityPose == EntityPose.SNEAKING && NmsVersion.v1_15.isSupported() ? "CROUCHING" : entityPose.name());
    }

    public static EntityPose getEntityPose(Object object) {
        String string = ((Enum)object).name();
        return EntityPose.valueOf(string.equals("CROUCHING") ? "SNEAKING" : string);
    }

    public static WrappedWatchableObject createWatchable(MetaIndex metaIndex, Object object) {
        Object object2 = ReflectionManager.createDataWatcherItem(metaIndex, object);
        if (object2 == null) {
            return null;
        }
        return new WrappedWatchableObject(object2);
    }

    public static int getCombinedIdByBlockData(BlockData blockData) {
        if (nmsReflection != null) {
            return nmsReflection.getCombinedIdByBlockData(blockData);
        }
        try {
            Object object = craftBlockDataGetState.invoke((Object)blockData, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        if (nmsReflection != null) {
            return nmsReflection.getCombinedIdByItemStack(itemStack);
        }
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                return itemStack.getType().ordinal() + (itemStack.getDurability() << 12);
            }
            Object object = magicGetBlock.invoke(null, itemStack.getType());
            Object object2 = getBlockData.invoke(object, new Object[0]);
            return (Integer)getBlockDataAsId.invoke(null, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static BlockData getBlockDataByCombinedId(int n) {
        if (nmsReflection != null) {
            return nmsReflection.getBlockDataByCombinedId(n);
        }
        try {
            Method method = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object object = method.invoke(null, n);
            Class clazz = ReflectionManager.getNmsClass("IBlockData");
            return (BlockData)ReflectionManager.getCraftMethod("CraftBlockData", "fromData", clazz).invoke(null, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemStackByCombinedId(int n) {
        if (nmsReflection != null) {
            return nmsReflection.getItemStackByCombinedId(n);
        }
        try {
            Method method = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object object = method.invoke(null, n);
            Class clazz = ReflectionManager.getNmsClass("IBlockData");
            Method method2 = ReflectionManager.getNmsMethod(NmsVersion.v1_16.isSupported() ? clazz.getSuperclass() : clazz, "getBlock", new Class[0]);
            Object object2 = method2.invoke(object, new Object[0]);
            if (NmsVersion.v1_13.isSupported()) {
                return new ItemStack((Material)magicGetMaterial.invoke(null, object2));
            }
            Method method3 = ReflectionManager.getNmsMethod("Block", "u", clazz);
            return ReflectionManager.getBukkitItem(method3.invoke(object2, object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(World world) {
        if (nmsReflection != null) {
            return nmsReflection.getWorldServer(world);
        }
        try {
            return getNmsWorld.invoke((Object)world, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static ItemMeta getDeserializedItemMeta(Map<String, Object> map) {
        if (nmsReflection != null) {
            return nmsReflection.getDeserializedItemMeta(map);
        }
        try {
            return (ItemMeta)deserializedItemMeta.invoke(null, map);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Class<? extends FlagWatcher> getFlagWatcher(DisguiseType disguiseType) {
        Class clazz;
        try {
            switch (disguiseType) {
                case MARKER: {
                    clazz = FlagWatcher.class;
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    clazz = ItemFrameWatcher.class;
                    break;
                }
                case ARROW: {
                    clazz = TippedArrowWatcher.class;
                    break;
                }
                case MODDED_LIVING: 
                case MODDED_MISC: {
                    clazz = ModdedWatcher.class;
                    break;
                }
                case COD: 
                case SALMON: {
                    clazz = FishWatcher.class;
                    break;
                }
                case SPECTRAL_ARROW: {
                    clazz = ArrowWatcher.class;
                    break;
                }
                case PRIMED_TNT: {
                    clazz = TNTWatcher.class;
                    break;
                }
                case MINECART_CHEST: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    clazz = MinecartWatcher.class;
                    break;
                }
                case SPIDER: 
                case CAVE_SPIDER: {
                    clazz = SpiderWatcher.class;
                    break;
                }
                case PIG_ZOMBIE: 
                case HUSK: 
                case DROWNED: 
                case ZOMBIFIED_PIGLIN: {
                    clazz = ZombieWatcher.class;
                    break;
                }
                case MAGMA_CUBE: {
                    clazz = SlimeWatcher.class;
                    break;
                }
                case ELDER_GUARDIAN: {
                    clazz = GuardianWatcher.class;
                    break;
                }
                case ILLUSIONER: 
                case EVOKER: {
                    clazz = IllagerWizardWatcher.class;
                    break;
                }
                case PUFFERFISH: {
                    clazz = PufferFishWatcher.class;
                    break;
                }
                default: {
                    clazz = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + ReflectionManager.toReadable(disguiseType.name()) + "Watcher");
                    break;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz2 = disguiseType.getEntityType().getEntityClass();
            if (clazz2 != null) {
                clazz = Tameable.class.isAssignableFrom(clazz2) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(clazz2) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(clazz2) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(clazz2) ? LivingWatcher.class : (Fish.class.isAssignableFrom(clazz2) ? FishWatcher.class : FlagWatcher.class))));
            }
            clazz = FlagWatcher.class;
        }
        return clazz;
    }

    public static void registerValues() {
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null) continue;
            Class<? extends FlagWatcher> clazz = ReflectionManager.getFlagWatcher(disguiseType);
            if (clazz == null) {
                DisguiseUtilities.getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                continue;
            }
            if (LibsPremium.isPremium().booleanValue() && (LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().isPremium() && !LibsPremium.getPaidInformation().isLegit() || LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isLegit())) {
                throw new IllegalStateException("Error while checking pi rate on startup! Please re-download the jar from SpigotMC before reporting this error!");
            }
            disguiseType.setWatcherClass(clazz);
            if (LibsDisguises.getInstance() == null || DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
            ReflectionManager.createNMSValues(disguiseType);
        }
    }

    public static byte[] readFuzzyFully(InputStream inputStream) {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(127 - byArray2[i]);
        }
        return byArray2;
    }

    private static void createNMSValues(DisguiseType disguiseType) {
        Object object;
        String string = ReflectionManager.toReadable(disguiseType.name());
        Class clazz = ReflectionManager.getNmsClassIgnoreErrors("Entity" + string);
        if (clazz == null || Modifier.isAbstract(clazz.getModifiers())) {
            object = ReflectionManager.splitReadable(disguiseType.name());
            ArrayUtils.reverse((Object[])object);
            string = StringUtils.join((Object[])object);
            clazz = ReflectionManager.getNmsClassIgnoreErrors("Entity" + string);
            if (clazz == null || Modifier.isAbstract(clazz.getModifiers())) {
                string = null;
            }
        }
        if (string == null) {
            switch (disguiseType) {
                case AXOLOTL: {
                    string = "Axolotl";
                    break;
                }
                case GOAT: {
                    string = "Goat";
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    string = "GlowItemFrame";
                    break;
                }
                case GLOW_SQUID: {
                    string = "GlowSquid";
                    break;
                }
                case MARKER: {
                    string = "Marker";
                    break;
                }
                case DONKEY: {
                    string = "HorseDonkey";
                    break;
                }
                case ARROW: {
                    string = "TippedArrow";
                    break;
                }
                case DROPPED_ITEM: {
                    string = "Item";
                    break;
                }
                case FIREBALL: {
                    string = "LargeFireball";
                    break;
                }
                case FIREWORK: {
                    string = "Fireworks";
                    break;
                }
                case GIANT: {
                    string = "GiantZombie";
                    break;
                }
                case HUSK: {
                    string = "ZombieHusk";
                    break;
                }
                case ILLUSIONER: {
                    string = "IllagerIllusioner";
                    break;
                }
                case LEASH_HITCH: {
                    string = "Leash";
                    break;
                }
                case MINECART: {
                    string = "MinecartRideable";
                    break;
                }
                case MINECART_COMMAND: {
                    string = "MinecartCommandBlock";
                    break;
                }
                case MINECART_TNT: {
                    string = "MinecartTNT";
                    break;
                }
                case MULE: {
                    string = "HorseMule";
                    break;
                }
                case PRIMED_TNT: {
                    string = "TNTPrimed";
                    break;
                }
                case PUFFERFISH: {
                    string = "PufferFish";
                    break;
                }
                case SPLASH_POTION: {
                    string = "Potion";
                    break;
                }
                case STRAY: {
                    string = "SkeletonStray";
                    break;
                }
                case TRIDENT: {
                    string = "ThrownTrident";
                    break;
                }
                case WANDERING_TRADER: {
                    string = "VillagerTrader";
                    break;
                }
                case TRADER_LLAMA: {
                    string = "LLamaTrader";
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    string = "PigZombie";
                    break;
                }
            }
        }
        try {
            Float f;
            if (disguiseType == DisguiseType.UNKNOWN || disguiseType.isCustom()) {
                object = new DisguiseValues(disguiseType, 0.0);
                ((DisguiseValues)object).setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                SoundGroup soundGroup = SoundGroup.getGroup(disguiseType.name());
                if (soundGroup != null) {
                    soundGroup.setDamageAndIdleSoundVolume(1.0f);
                }
                return;
            }
            if (string == null) {
                DisguiseUtilities.getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                return;
            }
            object = ReflectionManager.createEntityInstance(disguiseType, nmsReflection != null ? disguiseType.getEntityType().getKey().getKey() : string);
            if (object == null) {
                DisguiseUtilities.getLogger().warning("Entity not found! (" + string + ")");
                return;
            }
            disguiseType.setTypeId(ReflectionManager.getEntityTypeId(disguiseType.getEntityType()));
            Entity entity = ReflectionManager.getBukkitEntity(object);
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, entity instanceof Damageable ? ((Damageable)entity).getMaxHealth() : 0.0);
            WrappedDataWatcher wrappedDataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)entity);
            ArrayList<MetaIndex> arrayList = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
            boolean bl = false;
            for (WrappedWatchableObject object22 : wrappedDataWatcher.getWatchableObjects()) {
                MetaIndex metaIndex = MetaIndex.getMetaIndex(disguiseType.getWatcherClass(), object22.getIndex());
                if (metaIndex == null) {
                    DisguiseUtilities.getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + object22.getIndex());
                    DisguiseUtilities.getLogger().severe("Value: " + object22.getRawValue() + " (" + object22.getRawValue().getClass() + ") (" + object.getClass() + ") & " + disguiseType.getWatcherClass().getSimpleName());
                    continue;
                }
                arrayList.remove(metaIndex);
                Object object2 = ReflectionManager.convertInvalidMeta(metaIndex.getDefault());
                Object object3 = ReflectionManager.convertInvalidMeta(object22.getRawValue());
                if (object2.getClass() == object3.getClass()) continue;
                if (!bl) {
                    DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                    DisguiseUtilities.getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + string);
                    bl = true;
                }
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                DisguiseUtilities.getLogger().severe("Index: " + object22.getIndex() + " | " + metaIndex.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(metaIndex));
                Object y = metaIndex.getDefault();
                DisguiseUtilities.getLogger().severe("LibsDisguises: " + y + " (" + y.getClass() + ")");
                DisguiseUtilities.getLogger().severe("LibsDisguises Converted: " + object2 + " (" + object2.getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft: " + object22.getRawValue() + " (" + object22.getRawValue().getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft Converted: " + object3 + " (" + object3.getClass() + ")");
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
            }
            for (MetaIndex metaIndex : arrayList) {
                DisguiseUtilities.getLogger().severe((Object)((Object)disguiseType) + " has MetaIndex remaining! " + metaIndex.getFlagWatcher().getSimpleName() + " at index " + metaIndex.getIndex());
            }
            SoundGroup soundGroup = SoundGroup.getGroup(disguiseType.name());
            if (soundGroup != null && (f = ReflectionManager.getSoundModifier(object)) != null) {
                soundGroup.setDamageAndIdleSoundVolume(f.floatValue());
            }
            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(entity));
            if (entity instanceof Ageable) {
                ((Ageable)entity).setBaby();
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(entity));
            } else if (entity instanceof Zombie) {
                ((Zombie)entity).setBaby(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(entity));
            } else if (entity instanceof ArmorStand) {
                ((ArmorStand)entity).setSmall(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(entity));
            }
        }
        catch (FieldAccessException | IllegalArgumentException | SecurityException throwable) {
            DisguiseUtilities.getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
            DisguiseUtilities.getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
            DisguiseUtilities.getLogger().severe("Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
            throwable.printStackTrace();
        }
    }

    public static void setScore(final Scoreboard scoreboard, final String string, final int n) {
        if (!Bukkit.isPrimaryThread()) {
            new BukkitRunnable(){

                public void run() {
                    ReflectionManager.setScore(scoreboard, string, n);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
            return;
        }
        Set set = scoreboard.getObjectivesByCriteria("health");
        for (Objective objective : set) {
            Score score = objective.getScore(string);
            if (score.isScoreSet() && score.getScore() == n) continue;
            score.setScore(n);
        }
    }

    public static Map<String, Command> getCommands(CommandMap commandMap) {
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            return (Map)field.get(commandMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static SimpleCommandMap getCommandMap() {
        try {
            Field field = SimplePluginManager.class.getDeclaredField("commandMap");
            field.setAccessible(true);
            return (SimpleCommandMap)field.get(Bukkit.getPluginManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String[] splitReadable(String string) {
        String[] stringArray = string.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].charAt(0) + stringArray[i].substring(1).toLowerCase(Locale.ENGLISH);
        }
        return stringArray;
    }

    public static String toReadable(String string) {
        return ReflectionManager.toReadable(string, "");
    }

    public static String toReadable(String string, String string2) {
        return StringUtils.join((Object[])ReflectionManager.splitReadable(string), (String)string2);
    }
}

