/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class DisguisePermissions {
    private List<PermissionStorage> disguises = new ArrayList<PermissionStorage>();

    public DisguisePermissions(Permissible permissible, String string) {
        this.loadPermissions(permissible, string.toLowerCase(Locale.ENGLISH));
    }

    public boolean hasPermissions() {
        return !this.disguises.isEmpty();
    }

    public Collection<DisguisePerm> getAllowed() {
        ArrayList<DisguisePerm> arrayList = new ArrayList<DisguisePerm>();
        for (PermissionStorage permissionStorage : this.disguises) {
            if (arrayList.contains(permissionStorage.getDisguise())) continue;
            arrayList.add(permissionStorage.getDisguise());
        }
        arrayList.sort((disguisePerm, disguisePerm2) -> String.CASE_INSENSITIVE_ORDER.compare(disguisePerm.toReadable(), disguisePerm2.toReadable()));
        return arrayList;
    }

    private ParsedPermission parsePermission(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[2];
        HashMap<String, Boolean> hashMap = this.getOptions(string);
        DisguisePerm disguisePerm = DisguiseParser.getDisguisePerm(string2);
        if (disguisePerm != null) {
            return new ParsedPermission(new DisguisePerm[]{disguisePerm}, hashMap, 0, stringArray[1].equals("*"));
        }
        ArrayList<DisguisePerm> arrayList = new ArrayList<DisguisePerm>();
        int n = 0;
        for (DisguisePerm disguisePerm2 : DisguiseParser.getDisguisePerms()) {
            int n2 = this.getInheritance(disguisePerm2, string2);
            if (n2 < 0) continue;
            n = n2;
            arrayList.add(disguisePerm2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new ParsedPermission(arrayList.toArray(new DisguisePerm[0]), hashMap, (byte)n, stringArray[1].equals("*"));
    }

    private void loadPermissions(Permissible permissible, String string) {
        Object object;
        Object object2;
        Object object622;
        String string2 = "libsdisguises." + string + ".";
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (permissible.hasPermission("libsdisguises.*.*.*") || "802393".equals("12345")) {
            hashMap.put("libsdisguises.*.*.*", true);
        }
        for (Object object622 : permissible.getEffectivePermissions()) {
            String object5 = object622.getPermission().toLowerCase(Locale.ENGLISH);
            String[] stringArray = object5.split("\\.");
            if (stringArray.length < 3 || !stringArray[0].equals("libsdisguises") || !stringArray[1].equals("*") && !stringArray[1].equals(string) || hashMap.containsKey(object5) && object622.getValue()) continue;
            hashMap.put(object5, object622.getValue());
        }
        ArrayList arrayList = new ArrayList();
        object622 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (String)entry.getKey();
            if (((String)object2).split("\\.").length > 2 && ((String)object2).split("\\.")[2].equalsIgnoreCase("valid")) {
                ((ArrayList)object622).add(object2);
                continue;
            }
            ParsedPermission parsedPermission3 = this.parsePermission((String)entry.getKey());
            if (parsedPermission3 == null) continue;
            parsedPermission3.setNegated((Boolean)entry.getValue() == false);
            arrayList.add(parsedPermission3);
        }
        Iterator iterator = ((ArrayList)object622).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            object2 = this.getOptions(string3);
            String string4 = string3.split("\\.")[1];
            if (!string4.equals("*") && !string4.equalsIgnoreCase(string)) continue;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                object = (ParsedPermission)iterator2.next();
                ((ParsedPermission)object).options.putAll(object2);
            }
        }
        arrayList.sort((parsedPermission, parsedPermission2) -> {
            if (parsedPermission.isWildcardCommand() != parsedPermission2.isWildcardCommand()) {
                return Boolean.compare(parsedPermission2.isWildcardCommand(), parsedPermission.isWildcardCommand());
            }
            if (parsedPermission.getInheritance() == parsedPermission2.getInheritance()) {
                return Boolean.compare(parsedPermission.isNegated(), parsedPermission2.isNegated());
            }
            return parsedPermission2.getInheritance() - parsedPermission.getInheritance();
        });
        for (DisguisePerm disguisePerm : DisguiseParser.getDisguisePerms()) {
            boolean bl = true;
            object = new PermissionStorage(disguisePerm);
            byte by = -1;
            Iterator iterator3 = arrayList.iterator();
            while (iterator3.hasNext()) {
                ParsedPermission parsedPermission4 = (ParsedPermission)iterator3.next();
                if (!parsedPermission4.isDisguise(disguisePerm)) continue;
                if (parsedPermission4.isNegated() && parsedPermission4.options.isEmpty()) {
                    bl = true;
                    continue;
                }
                if (parsedPermission4.isNegated() && !parsedPermission4.options.containsValue(true)) continue;
                if (!parsedPermission4.isNegated()) {
                    if (bl) {
                        bl = false;
                    }
                    if (parsedPermission4.options.isEmpty() && !DisguiseConfig.isExplicitDisguisePermissions() && (((PermissionStorage)object).wildcardAllow || by != parsedPermission4.inheritance)) {
                        ((PermissionStorage)object).wildcardAllow = true;
                    } else if (!((PermissionStorage)object).permittedOptions.contains("*")) {
                        ((PermissionStorage)object).wildcardAllow = false;
                    }
                }
                for (Map.Entry entry : parsedPermission4.options.entrySet()) {
                    boolean bl2 = parsedPermission4.isNegated() ? !((Boolean)entry.getValue()).booleanValue() : (Boolean)entry.getValue();
                    ((PermissionStorage)object).permittedOptions.remove(entry.getKey());
                    ((PermissionStorage)object).negatedOptions.remove(entry.getKey());
                    if (((String)entry.getKey()).equals("*")) {
                        ((PermissionStorage)object).permittedOptions.clear();
                        ((PermissionStorage)object).negatedOptions.clear();
                        ((PermissionStorage)object).wildcardAllow = bl2;
                        if (!bl2) {
                            ((PermissionStorage)object).permittedOptions.add("nooptions");
                        }
                    }
                    if (bl2) {
                        ((PermissionStorage)object).permittedOptions.add((String)entry.getKey());
                        continue;
                    }
                    ((PermissionStorage)object).negatedOptions.add((String)entry.getKey());
                }
                if (parsedPermission4.options.isEmpty()) continue;
                by = parsedPermission4.inheritance;
            }
            if (bl) continue;
            if (DisguiseConfig.isDisabledInvisibility()) {
                ((PermissionStorage)object).permittedOptions.remove("setinvisible");
                ((PermissionStorage)object).negatedOptions.add("setinvisible");
            }
            if (permissible instanceof Player && !permissible.isOp() && !DisguiseConfig.isExplicitDisguisePermissions()) {
                ((PermissionStorage)object).permittedOptions.remove("setYModifier");
                ((PermissionStorage)object).negatedOptions.add("setYModifier");
            }
            this.disguises.add((PermissionStorage)object);
        }
    }

    private int getInheritance(DisguisePerm disguisePerm, String string) {
        DisguiseType disguiseType = disguisePerm.getType();
        if (string.equals("ageable")) {
            if (Ageable.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 1;
            }
        } else if (string.equals("monster") || string.equals("monsters")) {
            if (Monster.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 2;
            }
        } else if (string.equals("animal") || string.equals("animals")) {
            if (Animals.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 2;
            }
        } else if (string.equals("mob")) {
            if (disguiseType.isMob()) {
                return 3;
            }
        } else if (string.equals("misc")) {
            if (disguiseType.isMisc()) {
                return 3;
            }
        } else if (string.equals("custom")) {
            if (disguisePerm.isCustomDisguise()) {
                return 3;
            }
        } else if (string.equals("vanilla")) {
            if (!disguisePerm.isCustomDisguise()) {
                return 4;
            }
        } else if (string.equals("*")) {
            return 5;
        }
        return -1;
    }

    private HashMap<String, Boolean> getOptions(String string) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        String[] stringArray = string.split("\\.");
        for (int i = 3; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string2.startsWith("-");
            if (bl) {
                string2 = string2.substring(1);
            }
            if (string2.equals("baby")) {
                string2 = "setbaby";
            }
            hashMap.put(string2, !bl);
        }
        return hashMap;
    }

    public boolean isAllowedDisguise(DisguisePerm disguisePerm, Collection<String> collection) {
        PermissionStorage permissionStorage = this.getStorage(disguisePerm);
        if (permissionStorage == null) {
            return false;
        }
        if (!(permissionStorage.wildcardAllow || permissionStorage.permittedOptions.isEmpty() && !permissionStorage.negatedOptions.isEmpty() || collection.stream().allMatch(string -> permissionStorage.permittedOptions.contains(string.toLowerCase(Locale.ENGLISH))))) {
            return false;
        }
        return collection.stream().noneMatch(string -> permissionStorage.negatedOptions.contains(string.toLowerCase(Locale.ENGLISH)));
    }

    public boolean isAllowedDisguise(DisguisePerm disguisePerm) {
        return this.getStorage(disguisePerm) != null;
    }

    private PermissionStorage getStorage(DisguisePerm disguisePerm) {
        return this.disguises.stream().filter(permissionStorage -> permissionStorage.getDisguise().equals(disguisePerm)).findAny().orElse(null);
    }

    private class PermissionStorage {
        private DisguisePerm disguisePerm;
        private List<String> permittedOptions = new ArrayList<String>();
        private List<String> negatedOptions = new ArrayList<String>();
        private boolean wildcardAllow = false;

        public PermissionStorage(DisguisePerm disguisePerm) {
            this.disguisePerm = disguisePerm;
        }

        public DisguisePerm getDisguise() {
            return this.disguisePerm;
        }
    }

    private class ParsedPermission {
        private Vector<DisguisePerm> disguisePerm;
        private HashMap<String, Boolean> options;
        private boolean negated;
        private byte inheritance;
        private boolean wildcardCommand;

        public ParsedPermission(DisguisePerm[] disguisePermArray, HashMap<String, Boolean> hashMap, byte by, boolean bl) {
            this.disguisePerm = new Vector<DisguisePerm>(Arrays.asList(disguisePermArray));
            this.options = hashMap;
            this.inheritance = by;
            this.wildcardCommand = bl;
        }

        public boolean isWildcardCommand() {
            return this.wildcardCommand;
        }

        public boolean isDisguise(DisguisePerm disguisePerm) {
            return this.disguisePerm.contains(disguisePerm);
        }

        public boolean isNegated() {
            return this.negated;
        }

        public void setNegated(boolean bl) {
            this.negated = bl;
        }

        public byte getInheritance() {
            return this.inheritance;
        }
    }

    class DisguisePermitted {
        private boolean strictAllowed;
        private List<String> optionsAllowed;
        private List<String> optionsForbidden;

        public DisguisePermitted(List<String> list, List<String> list2, boolean bl) {
            this.strictAllowed = bl;
            this.optionsAllowed = list;
            this.optionsForbidden = list2;
        }

        public boolean isStrictAllowed() {
            return this.strictAllowed;
        }

        public List<String> getOptionsAllowed() {
            return this.optionsAllowed;
        }

        public List<String> getOptionsForbidden() {
            return this.optionsForbidden;
        }
    }
}

