/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.ModdedDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;

public class DisguiseParser {
    private static HashMap<WatcherMethod, Map.Entry<WatcherMethod, Object>> defaultWatcherValues = new HashMap();

    /*
     * WARNING - void declaration
     */
    public static void createDefaultMethods() {
        try {
            ArrayList<WatcherMethod> arrayList = ParamInfoManager.getDisguiseMethods().getMethods();
            for (DisguiseType disguiseType : DisguiseType.values()) {
                WatcherMethod[] watcherMethodArray;
                TargetedDisguise targetedDisguise;
                if (disguiseType.getEntityType() == null) continue;
                if (disguiseType.isMisc()) {
                    targetedDisguise = new MiscDisguise(disguiseType);
                } else if (disguiseType.isMob()) {
                    targetedDisguise = new MobDisguise(disguiseType);
                } else {
                    if (!disguiseType.isPlayer()) continue;
                    targetedDisguise = new PlayerDisguise("Foobar");
                }
                FlagWatcher flagWatcher = disguiseType.getWatcherClass().getConstructor(Disguise.class).newInstance(targetedDisguise);
                for (WatcherMethod watcherMethod : watcherMethodArray = ParamInfoManager.getDisguiseWatcherMethods(flagWatcher.getClass(), true)) {
                    if (watcherMethod.getName().equals("addPotionEffect") || watcherMethod.getName().equals("setSkin") && watcherMethod.getParam() == String.class || watcherMethod.getName().equals("setTarget") && watcherMethod.getParam() != Integer.TYPE || watcherMethod.getName().equals("setItemInMainHand") && watcherMethod.getParam() == Material.class || watcherMethod.getName().matches("setArmor") && watcherMethod.getParam() == ItemStack[].class) continue;
                    String string = watcherMethod.getName().substring(3);
                    string = string.equals("HasNectar") ? "hasNectar" : (string.equals("HasStung") ? "hasStung" : (watcherMethod.getParam().isAssignableFrom(Boolean.TYPE) ? "is" + string : "get" + string));
                    WatcherMethod object = null;
                    for (WatcherMethod watcherMethod2 : arrayList) {
                        if (watcherMethod2.getWatcherClass() != watcherMethod.getWatcherClass() || watcherMethod2.getParam() != null || !watcherMethod2.getName().equals(string)) continue;
                        object = watcherMethod2;
                        break;
                    }
                    if (object == null) {
                        DisguiseUtilities.getLogger().severe(String.format("No such method '%s' when looking for the companion of '%s' in '%s'", string, watcherMethod.getName(), watcherMethod.getWatcherClass().getSimpleName()));
                        continue;
                    }
                    if (object.getReturnType() != watcherMethod.getParam()) {
                        DisguiseUtilities.getLogger().severe(String.format("Invalid return type of '%s' when looking for the companion of '%s' in '%s'", string, watcherMethod.getName(), watcherMethod.getWatcherClass().getSimpleName()));
                        continue;
                    }
                    Object object3 = null;
                    if (!watcherMethod.isRandomDefault()) {
                        void var15_21;
                        FlagWatcher flagWatcher2 = flagWatcher;
                        if (!FlagWatcher.class.isAssignableFrom(object.getWatcherClass())) {
                            TargetedDisguise targetedDisguise2 = targetedDisguise;
                        }
                        object3 = object.getMethod().bindTo(var15_21).invoke();
                    }
                    DisguiseParser.addWatcherDefault(watcherMethod, object, object3);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static HashMap<WatcherMethod, Map.Entry<WatcherMethod, Object>> getMethodDefaults() {
        return defaultWatcherValues;
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseParser.parseToString(disguise, true);
    }

    public static String parseToString(Disguise disguise, boolean bl) {
        return DisguiseParser.parseToString(disguise, bl, false);
    }

    public static String parseToString(Disguise disguise, boolean bl, boolean bl2) {
        try {
            Object object;
            Object object2;
            Object object3;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(disguise.getType().name());
            if (disguise.isPlayerDisguise()) {
                stringBuilder.append(" ").append(DisguiseUtilities.quote(((PlayerDisguise)disguise).getName()));
            }
            WatcherMethod[] watcherMethodArray = ParamInfoManager.getDisguiseWatcherMethods(disguise.getType().getWatcherClass());
            for (int i = watcherMethodArray.length - 1; i >= 0; --i) {
                String string;
                object3 = watcherMethodArray[i];
                if (((WatcherMethod)object3).getName().equals("addPotionEffect")) {
                    object2 = MethodHandles.publicLookup().bind(disguise.getWatcher(), "getPotionEffects", MethodType.methodType(PotionEffectType[].class));
                    PotionEffectType[] potionEffectTypeArray = object2.invoke();
                    for (PotionEffectType potionEffectType : potionEffectTypeArray) {
                        if (potionEffectType == null) continue;
                        stringBuilder.append(" ").append(((WatcherMethod)object3).getName()).append(" ").append(potionEffectType.getName());
                    }
                    continue;
                }
                if (((WatcherMethod)object3).getName().equals("setNoGravity") || (object2 = defaultWatcherValues.get(object3)) == null) continue;
                Object object4 = ((WatcherMethod)object3).getWatcherClass().isInstance(disguise) ? disguise : disguise.getWatcher();
                object = ((WatcherMethod)object2.getKey()).getMethod().bindTo(object4).invoke();
                if ("".equals(object) && ((WatcherMethod)object3).getName().equals("setCustomName")) {
                    object = null;
                }
                if (((WatcherMethod)object3).getName().equals("setSkin") && !bl) {
                    PlayerDisguise playerDisguise = (PlayerDisguise)disguise;
                    object = playerDisguise.getName();
                    if (playerDisguise.getSkin() != null) {
                        object = playerDisguise.getSkin();
                    } else if (playerDisguise.getGameProfile() != null && playerDisguise.getGameProfile().getName() != null) {
                        object = playerDisguise.getGameProfile().getName();
                    }
                    if (object.equals(playerDisguise.getName())) {
                        continue;
                    }
                } else if (!((WatcherMethod)object3).isRandomDefault() && Objects.deepEquals(object2.getValue(), object)) continue;
                stringBuilder.append(" ").append(((WatcherMethod)object3).getName());
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) continue;
                if (object != null) {
                    string = ParamInfoManager.getParamInfo(object.getClass()).toString(object);
                    string = DisguiseUtilities.quote(string);
                } else {
                    string = "null";
                }
                stringBuilder.append(" ").append(string);
            }
            if (bl2) {
                HashMap<String, Object> hashMap = disguise.getCustomData();
                object3 = new LinkedHashMap();
                for (Map.Entry entry : hashMap.entrySet()) {
                    object = entry.getValue();
                    try {
                        if (object == null) {
                            ((HashMap)object3).put((String)entry.getKey(), "null");
                            continue;
                        }
                        String string = DisguiseUtilities.getGson().toJson(object);
                        ((HashMap)object3).put((String)entry.getKey(), object.getClass().getName() + ":" + string);
                    }
                    catch (Throwable throwable) {
                        DisguiseUtilities.getLogger().warning("Unable to properly serialize the metadata on a disguise, the metadata was saved under name '" + (String)entry.getKey() + "'");
                        if (throwable instanceof StackOverflowError) continue;
                        throwable.printStackTrace();
                    }
                }
                if (!((HashMap)object3).isEmpty()) {
                    object2 = DisguiseUtilities.getGson().toJson(object3);
                    stringBuilder.append(" ").append("setCustomData").append(" ").append(DisguiseUtilities.quote((String)object2));
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static void addWatcherDefault(WatcherMethod watcherMethod, WatcherMethod watcherMethod2, Object object) {
        if (defaultWatcherValues.containsKey(watcherMethod)) {
            Object object2 = defaultWatcherValues.get(watcherMethod).getValue();
            if (!Objects.deepEquals(object2, object)) {
                throw new IllegalStateException(String.format("%s has conflicting values in class %s! This means it expected the same value again but received a different value on a different disguise! %s is not the same as %s!", watcherMethod.toString(), watcherMethod.toString(), object, object2));
            }
            return;
        }
        AbstractMap.SimpleEntry<WatcherMethod, Object> simpleEntry = new AbstractMap.SimpleEntry<WatcherMethod, Object>(watcherMethod2, object);
        defaultWatcherValues.put(watcherMethod, simpleEntry);
    }

    private static void doCheck(CommandSender commandSender, DisguisePermissions disguisePermissions, DisguisePerm disguisePerm, Collection<String> collection) {
        if (!disguisePermissions.isAllowedDisguise(disguisePerm, collection)) {
            throw new DisguiseParseException(LibsMsg.D_PARSE_NOPERM, collection.stream().reduce((string, string2) -> string2).orElse(null));
        }
    }

    private static HashMap<String, HashMap<String, Boolean>> getDisguiseOptions(CommandSender commandSender, String string, DisguisePerm disguisePerm) {
        HashMap<String, HashMap<String, Boolean>> hashMap = new HashMap<String, HashMap<String, Boolean>>();
        for (PermissionAttachmentInfo permissionAttachmentInfo : commandSender.getEffectivePermissions()) {
            String[] stringArray;
            String string2 = permissionAttachmentInfo.getPermission().toLowerCase(Locale.ENGLISH);
            if (!string2.startsWith("libsdisguises.options.") || (stringArray = string2.split("\\.")).length < 4 || !stringArray[2].equalsIgnoreCase(string) && !stringArray[2].equalsIgnoreCase("*")) continue;
            boolean bl = false;
            for (String string3 : stringArray[3].split("/")) {
                if (!string3.equals("*") && !string3.replace("_", "").equalsIgnoreCase(disguisePerm.toReadable().replace(" ", ""))) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            HashMap hashMap2 = new HashMap();
            for (int i = 5; i < stringArray.length; ++i) {
                hashMap2.put(stringArray[i], permissionAttachmentInfo.getValue());
            }
            for (String string4 : stringArray[4].split("/")) {
                if (hashMap.containsKey(string4)) {
                    hashMap.get(string4).putAll(hashMap2);
                    continue;
                }
                hashMap.put(string4, hashMap2);
            }
        }
        return hashMap;
    }

    public static DisguisePerm getDisguisePerm(String string) {
        for (DisguisePerm disguisePerm : DisguiseParser.getDisguisePerms()) {
            if (!disguisePerm.toReadable().replaceAll("[ |_]", "").equalsIgnoreCase(string.replaceAll("[ |_]", ""))) continue;
            return disguisePerm;
        }
        if (string.equalsIgnoreCase("p")) {
            return DisguiseParser.getDisguisePerm(DisguiseType.PLAYER.toReadable());
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        ArrayList<DisguisePerm> arrayList = new ArrayList<DisguisePerm>();
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null || disguiseType.isCustom()) continue;
            arrayList.add(new DisguisePerm(disguiseType));
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            arrayList.add((DisguisePerm)entry.getKey());
        }
        arrayList.addAll(ModdedManager.getDisguiseTypes());
        return arrayList.toArray(new DisguisePerm[0]);
    }

    public static DisguisePermissions getPermissions(CommandSender commandSender, String string) {
        return new DisguisePermissions((Permissible)commandSender, string);
    }

    private static boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasPermissionOption(HashMap<String, HashMap<String, Boolean>> hashMap, String string, String string2) {
        if (!hashMap.containsKey(string = string.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        HashMap<String, Boolean> hashMap2 = hashMap.get(string);
        if (hashMap2.containsKey(string2 = string2.toLowerCase(Locale.ENGLISH))) {
            return hashMap2.get(string2);
        }
        return !hashMap2.containsValue(true);
    }

    public static String getName(CommandSender commandSender) {
        if (commandSender == null) {
            return "??";
        }
        if (commandSender instanceof Player) {
            return commandSender.getName();
        }
        if (commandSender instanceof Entity && ((Entity)commandSender).getCustomName() != null && ((Entity)commandSender).getCustomName().length() > 0) {
            return ((Entity)commandSender).getCustomName();
        }
        return commandSender.getName();
    }

    private static String getSkin(CommandSender commandSender) {
        WrappedGameProfile wrappedGameProfile;
        if (commandSender == null) {
            return "??";
        }
        if (commandSender instanceof Player && (wrappedGameProfile = ReflectionManager.getGameProfile((Player)commandSender)) != null) {
            return DisguiseUtilities.getGson().toJson((Object)wrappedGameProfile);
        }
        return "{}";
    }

    public static String[] parsePlaceholders(String[] stringArray, CommandSender commandSender, CommandSender commandSender2) {
        return DisguiseParser.parsePlaceholders(stringArray, DisguiseParser.getName(commandSender), DisguiseUtilities.getDisplayName(commandSender), DisguiseParser.getSkin(commandSender), DisguiseParser.getName(commandSender2), DisguiseUtilities.getDisplayName(commandSender2), DisguiseParser.getSkin(commandSender2), DisguiseParser.getEntityEquipment(commandSender), DisguiseParser.getEntityEquipment(commandSender2));
    }

    private static EntityEquipment getEntityEquipment(CommandSender commandSender) {
        return commandSender instanceof LivingEntity ? ((LivingEntity)commandSender).getEquipment() : null;
    }

    public static String[] parsePlaceholders(String[] stringArray, String string, String string2, String string3, String string4, EntityEquipment entityEquipment, EntityEquipment entityEquipment2) {
        return DisguiseParser.parsePlaceholders(stringArray, string, string, string2, string3, string3, string4, entityEquipment, entityEquipment2);
    }

    public static String[] parsePlaceholders(String[] stringArray, String string, String string2, String string3, String string4, String string5, String string6, EntityEquipment entityEquipment, EntityEquipment entityEquipment2) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            string7 = DisguiseParser.replace(string7, "%name%", string);
            string7 = DisguiseParser.replace(string7, "%displayname%", string2);
            string7 = DisguiseParser.replace(string7, "%skin%", string3);
            string7 = DisguiseParser.replace(string7, "%held-item%", entityEquipment == null ? null : entityEquipment.getItemInMainHand());
            string7 = DisguiseParser.replace(string7, "%offhand-item%", entityEquipment == null ? null : entityEquipment.getItemInOffHand());
            string7 = DisguiseParser.replace(string7, "%armor%", entityEquipment == null ? null : entityEquipment.getArmorContents());
            string7 = DisguiseParser.replace(string7, "%helmet%", entityEquipment == null ? null : entityEquipment.getHelmet());
            string7 = DisguiseParser.replace(string7, "%chestplate%", entityEquipment == null ? null : entityEquipment.getChestplate());
            string7 = DisguiseParser.replace(string7, "%leggings%", entityEquipment == null ? null : entityEquipment.getLeggings());
            string7 = DisguiseParser.replace(string7, "%boots%", entityEquipment == null ? null : entityEquipment.getBoots());
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!string7.contains("%" + player.getName() + "-")) continue;
                String string8 = player.getName();
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-name%", string8);
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-displayname%", DisguiseUtilities.getDisplayName((CommandSender)player));
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-skin%", DisguiseParser.getSkin((CommandSender)player));
                EntityEquipment entityEquipment3 = player.getEquipment();
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-held-item%", entityEquipment3 == null ? null : entityEquipment3.getItemInMainHand());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-offhand-item%", entityEquipment3 == null ? null : entityEquipment3.getItemInOffHand());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-armor%", entityEquipment3 == null ? null : entityEquipment3.getArmorContents());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-helmet%", entityEquipment3 == null ? null : entityEquipment3.getHelmet());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-chestplate%", entityEquipment3 == null ? null : entityEquipment3.getChestplate());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-leggings%", entityEquipment3 == null ? null : entityEquipment3.getLeggings());
                string7 = DisguiseParser.replace(string7, "%" + string8 + "-boots%", entityEquipment3 == null ? null : entityEquipment3.getBoots());
            }
            string7 = DisguiseParser.replace(string7, "%target-name%", string4);
            string7 = DisguiseParser.replace(string7, "%target-displayname%", string5);
            string7 = DisguiseParser.replace(string7, "%target-skin%", string6);
            string7 = DisguiseParser.replace(string7, "%target-held-item%", entityEquipment2 == null ? null : entityEquipment2.getItemInMainHand());
            string7 = DisguiseParser.replace(string7, "%target-offhand-item%", entityEquipment2 == null ? null : entityEquipment2.getItemInOffHand());
            string7 = DisguiseParser.replace(string7, "%target-armor%", entityEquipment2 == null ? null : entityEquipment2.getArmorContents());
            string7 = DisguiseParser.replace(string7, "%target-helmet%", entityEquipment2 == null ? null : entityEquipment2.getHelmet());
            string7 = DisguiseParser.replace(string7, "%target-chestplate%", entityEquipment2 == null ? null : entityEquipment2.getChestplate());
            string7 = DisguiseParser.replace(string7, "%target-leggings%", entityEquipment2 == null ? null : entityEquipment2.getLeggings());
            stringArray[i] = string7 = DisguiseParser.replace(string7, "%target-boots%", entityEquipment2 == null ? null : entityEquipment2.getBoots());
        }
        return stringArray;
    }

    private static String replace(String string, String string2, Object object) {
        if (!string.contains(string2)) {
            return string;
        }
        String string3 = object != null ? ParamInfoManager.toString(object) : "null";
        return string.replace(string2, string3);
    }

    public static long parseStringToTime(String string) {
        if (!(string = string.toLowerCase(Locale.ENGLISH)).matches("([0-9]+[a-z]+)+")) {
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME_SEQUENCE, string);
        }
        String[] stringArray = string.split("((?<=[a-zA-Z])(?=[0-9]))|((?<=[0-9])(?=[a-zA-Z]))");
        long l = 0L;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i + 1];
            long l2 = Long.parseLong(stringArray[i]);
            if (string2.equals("s") || string2.equals("sec") || string2.equals("secs") || string2.equals("seconds")) {
                l += l2;
                continue;
            }
            if (string2.equals("m") || string2.equals("min") || string2.equals("minute") || string2.equals("minutes")) {
                l += TimeUnit.MINUTES.toSeconds(l2);
                continue;
            }
            if (string2.equals("h") || string2.equals("hour") || string2.equals("hours")) {
                l += TimeUnit.HOURS.toSeconds(l2);
                continue;
            }
            if (string2.equals("d") || string2.equals("day") || string2.equals("days")) {
                l += TimeUnit.DAYS.toSeconds(l2);
                continue;
            }
            if (string2.equals("w") || string2.equals("week") || string2.equals("weeks")) {
                l += TimeUnit.DAYS.toSeconds(l2) * 7L;
                continue;
            }
            if (string2.equals("mon") || string2.equals("month") || string2.equals("months")) {
                l += TimeUnit.DAYS.toSeconds(l2) * 31L;
                continue;
            }
            if (string2.equals("y") || string2.equals("year") || string2.equals("years")) {
                l += TimeUnit.DAYS.toSeconds(l2) * 365L;
                continue;
            }
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME, string2);
        }
        return l;
    }

    public static Disguise parseTestDisguise(CommandSender commandSender, String string, String[] stringArray, DisguisePermissions disguisePermissions) {
        stringArray = Arrays.copyOf(stringArray, stringArray.length);
        String string2 = "{\"id\":\"a149f81bf7844f8987c554afdd4db533\",\"name\":\"libraryaddict\",\"properties\":[]}";
        stringArray = DisguiseParser.parsePlaceholders(stringArray, "libraryaddict", string2, "libraryaddict", string2, null, null);
        return DisguiseParser.parseDisguise(commandSender, null, string, stringArray, disguisePermissions);
    }

    public static void modifyDisguise(Disguise disguise, Entity entity, String[] stringArray) {
        if (entity != null) {
            stringArray = DisguiseParser.parsePlaceholders(stringArray, (CommandSender)entity, (CommandSender)entity);
        }
        DisguiseParser.callMethods((CommandSender)Bukkit.getConsoleSender(), disguise, new DisguisePermissions((Permissible)Bukkit.getConsoleSender(), "disguise"), new DisguisePerm(disguise.getType()), new ArrayList<String>(), stringArray, "Disguise");
    }

    public static void modifyDisguise(Disguise disguise, String[] stringArray) {
        DisguiseParser.modifyDisguise(disguise, null, stringArray);
    }

    public static void modifyDisguise(Disguise disguise, String string) {
        DisguiseParser.modifyDisguise(disguise, DisguiseUtilities.split(string));
    }

    public static void modifyDisguise(Disguise disguise, Entity entity, String string) {
        DisguiseParser.modifyDisguise(disguise, entity, DisguiseUtilities.split(string));
    }

    public static Disguise parseDisguise(String string) {
        return DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), null, string);
    }

    public static Disguise parseDisguise(CommandSender commandSender, Entity entity, String string) {
        return DisguiseParser.parseDisguise(commandSender, entity, "disguise", DisguiseUtilities.split(string), new DisguisePermissions((Permissible)Bukkit.getConsoleSender(), "disguise"));
    }

    public static Disguise parseDisguise(CommandSender commandSender, Entity entity, String string, String[] stringArray, DisguisePermissions disguisePermissions) {
        Object object;
        String string2;
        DisguisePerm disguisePerm;
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("DisguiseParser should not be called async!");
        }
        if (commandSender instanceof Player) {
            DisguiseUtilities.setCommandsUsed();
        }
        if (!disguisePermissions.hasPermissions()) {
            throw new DisguiseParseException(LibsMsg.NO_PERM, new String[0]);
        }
        if (stringArray.length == 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_ARGS, new String[0]);
        }
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        Disguise disguise = null;
        boolean bl = false;
        if (stringArray[0].startsWith("@")) {
            if (commandSender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(stringArray[0].toLowerCase(Locale.ENGLISH));
                if (disguise == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_REF, stringArray[0]);
                }
            } else {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_REF, new String[0]);
            }
            disguisePerm = new DisguisePerm(disguise.getType());
            string2 = disguise.getDisguiseName();
            bl = disguise.isCustomDisguiseName();
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
        } else {
            disguisePerm = DisguiseParser.getDisguisePerm(stringArray[0]);
            if (disguisePerm == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_DISG_NO_EXIST, stringArray[0]);
            }
            string2 = disguisePerm.toReadable();
            if (disguisePerm.getType().isCustom()) {
                object = ModdedManager.getModdedEntity(disguisePerm.toReadable());
                if (object == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
                }
                disguise = new ModdedDisguise((ModdedEntity)object);
                bl = true;
            }
            if ((object = DisguiseConfig.getRawCustomDisguise(stringArray[0])) != null) {
                stringArray = DisguiseUtilities.split((String)object.getValue());
                string2 = ((DisguisePerm)object.getKey()).toReadable();
                bl = true;
            }
            stringArray = DisguiseParser.parsePlaceholders(stringArray, (CommandSender)(commandSender == null ? entity : commandSender), (CommandSender)entity);
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
            HashMap<String, HashMap<String, Boolean>> hashMap = DisguiseParser.getDisguiseOptions(commandSender, string, disguisePerm);
            if (disguise == null) {
                if (disguisePerm.isPlayer()) {
                    if (stringArray.length == 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_SUPPLY_PLAYER, new String[0]);
                    }
                    if (!(DisguiseParser.hasPermissionOption(hashMap, "setname", stringArray[1].toLowerCase(Locale.ENGLISH)) || stringArray[1].equalsIgnoreCase(commandSender.getName()) && DisguiseParser.hasPermissionOption(hashMap, "setname", "themselves"))) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_NAME, new String[0]);
                    }
                    stringArray[1] = stringArray[1].replace("\\_", " ");
                    if (DisguiseConfig.isArmorstandsName() && !commandSender.hasPermission("libsdisguises.multiname")) {
                        stringArray[1] = DisguiseUtilities.quoteNewLine(stringArray[1]);
                    }
                    disguise = new PlayerDisguise(DisguiseUtilities.translateAlternateColorCodes(stringArray[1]));
                    if (!bl) {
                        string2 = ((PlayerDisguise)disguise).getName();
                    }
                    ++n;
                } else if (disguisePerm.isMob()) {
                    if (stringArray.length > 1) {
                        boolean bl2 = true;
                        if (stringArray[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("baby")) || stringArray[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"))) {
                            arrayList.add("setbaby");
                            DisguiseParser.doCheck(commandSender, disguisePermissions, disguisePerm, arrayList);
                            bl2 = stringArray[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"));
                            ++n;
                            disguise = new MobDisguise(disguisePerm.getType(), bl2);
                        } else {
                            disguise = new MobDisguise(disguisePerm.getType());
                        }
                    } else {
                        disguise = new MobDisguise(disguisePerm.getType());
                    }
                } else if (disguisePerm.isMisc()) {
                    ItemStack itemStack = new ItemStack(Material.STONE);
                    Object object2 = null;
                    int n2 = -1;
                    if (stringArray.length > 1) {
                        switch (disguisePerm.getType()) {
                            case FALLING_BLOCK: 
                            case DROPPED_ITEM: {
                                String string3;
                                try {
                                    if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                                        if (NmsVersion.v1_13.isSupported() && stringArray[1].contains("[")) {
                                            ParamInfo paramInfo = ParamInfoManager.getParamInfo(BlockData.class);
                                            object2 = paramInfo.fromString(new ArrayList<String>(Collections.singletonList(stringArray[1])));
                                        } else {
                                            ParamInfoItemBlock paramInfoItemBlock = ParamInfoManager.getParamInfoItemBlock();
                                            itemStack = (ItemStack)paramInfoItemBlock.fromString(new ArrayList<String>(Collections.singletonList(stringArray[1])));
                                        }
                                    } else {
                                        ParamInfo paramInfo = ParamInfoManager.getParamInfo(ItemStack.class);
                                        itemStack = (ItemStack)paramInfo.fromString(new ArrayList<String>(Collections.singletonList(stringArray[1])));
                                    }
                                }
                                catch (Exception exception) {
                                    break;
                                }
                                String string4 = disguisePerm.getType() == DisguiseType.FALLING_BLOCK ? "setblock" : "setitemstack";
                                arrayList.add(string4);
                                DisguiseParser.doCheck(commandSender, disguisePermissions, disguisePerm, arrayList);
                                String string5 = string3 = itemStack == null ? "null" : itemStack.getType().name().toLowerCase(Locale.ENGLISH);
                                if (!DisguiseParser.hasPermissionOption(hashMap, string4, string3)) {
                                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, string3, disguisePerm.toReadable());
                                }
                                ++n;
                                break;
                            }
                            case PAINTING: 
                            case SPLASH_POTION: {
                                if (!DisguiseParser.isInteger(stringArray[1])) break;
                                n2 = Integer.parseInt(stringArray[1]);
                                ++n;
                                String string6 = disguisePerm.getType() == DisguiseType.PAINTING ? "setpainting" : "setpotionid";
                                arrayList.add(string6);
                                DisguiseParser.doCheck(commandSender, disguisePermissions, disguisePerm, arrayList);
                                if (DisguiseParser.hasPermissionOption(hashMap, string6, n2 + "")) break;
                                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, n2 + "", disguisePerm.toReadable());
                            }
                        }
                    }
                    if (disguisePerm.getType() == DisguiseType.DROPPED_ITEM || disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                        disguise = new MiscDisguise(disguisePerm.getType(), itemStack);
                        if (object2 != null && disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                            ((FallingBlockWatcher)disguise.getWatcher()).setBlockData((BlockData)object2);
                        }
                        if (!bl) {
                            string2 = disguise.getDisguiseName();
                        }
                    } else {
                        disguise = new MiscDisguise(disguisePerm.getType(), n2);
                    }
                }
            }
        }
        disguise.setDisguiseName(string2);
        disguise.setCustomDisguiseName(bl);
        object = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, object, 0, stringArray.length - n);
        DisguiseParser.callMethods(commandSender, disguise, disguisePermissions, disguisePerm, arrayList, object, string);
        if (commandSender instanceof Player && entity instanceof Player && "802393".equals("1592") && ThreadLocalRandom.current().nextBoolean()) {
            ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            ((TargetedDisguise)disguise).addPlayer((Player)commandSender);
        }
        return disguise;
    }

    public static void callMethods(CommandSender commandSender, Disguise disguise, DisguisePermissions disguisePermissions, DisguisePerm disguisePerm, Collection<String> collection, String[] stringArray, String string) {
        WatcherMethod[] watcherMethodArray = ParamInfoManager.getDisguiseWatcherMethods(disguise.getWatcher().getClass(), true);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        HashMap<String, HashMap<String, Boolean>> hashMap = DisguiseParser.getDisguiseOptions(commandSender, string, disguisePerm);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string2 = (String)arrayList.remove(0);
            String string3 = TranslateType.DISGUISE_OPTIONS.reverseGet(string2);
            WatcherMethod object3 = null;
            Object object4 = null;
            DisguiseParseException disguiseParseException = null;
            if (!arrayList.isEmpty() && string2.equalsIgnoreCase("setCustomData") && (commandSender == null || commandSender.isOp())) {
                ++i;
                object2 = (String)arrayList.remove(0);
                Map map = (Map)DisguiseUtilities.getGson().fromJson((String)object2, LinkedHashMap.class);
                for (Map.Entry entry : map.entrySet()) {
                    object = (String)entry.getValue();
                    if (!((String)object).contains(":")) {
                        disguise.addCustomData((String)entry.getKey(), null);
                        continue;
                    }
                    String disguiseParseException2 = ((String)object).substring(0, ((String)object).indexOf(":"));
                    object = ((String)object).substring(disguiseParseException2.length() + 1);
                    disguise.addCustomData((String)entry.getKey(), DisguiseUtilities.getGson().fromJson((String)object, DisguiseMethods.parseType(disguiseParseException2)));
                }
                continue;
            }
            for (WatcherMethod watcherMethod : watcherMethodArray) {
                if (!watcherMethod.getName().equalsIgnoreCase(string3)) continue;
                object = ParamInfoManager.getParamInfo(watcherMethod);
                try {
                    int exception = arrayList.size();
                    if (exception < ((ParamInfo)object).getMinArguments()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_OPTION_VALUE, TranslateType.DISGUISE_OPTIONS.reverseGet(watcherMethod.getName()));
                    }
                    object4 = ((ParamInfo)object).fromString(arrayList);
                    if (object4 == null && !((ParamInfo)object).canReturnNull()) {
                        throw new IllegalStateException();
                    }
                    i += exception - arrayList.size();
                    object3 = watcherMethod;
                    break;
                }
                catch (DisguiseParseException disguiseParseException2) {
                    disguiseParseException = disguiseParseException2;
                }
                catch (Exception exception) {
                    disguiseParseException = new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, ((ParamInfo)object).getDescriptiveName(), arrayList.isEmpty() ? null : (String)arrayList.get(0), TranslateType.DISGUISE_OPTIONS.reverseGet(watcherMethod.getName()));
                }
            }
            if (object3 == null) {
                if (disguiseParseException != null) {
                    throw disguiseParseException;
                }
                throw new DisguiseParseException(LibsMsg.PARSE_OPTION_NA, string2);
            }
            if (!collection.contains(object3.getName().toLowerCase(Locale.ENGLISH))) {
                collection.add(object3.getName().toLowerCase(Locale.ENGLISH));
            }
            DisguiseParser.doCheck(commandSender, disguisePermissions, disguisePerm, collection);
            if (!hashMap.isEmpty()) {
                object2 = ParamInfoManager.toString(object4);
                if (!DisguiseParser.hasPermissionOption(hashMap, object3.getName(), (String)object2)) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, new String[]{object2, disguisePerm.toReadable()});
                }
            }
            if (DisguiseConfig.isArmorstandsName() && (object3.getName().equals("setName") && disguise.isPlayerDisguise() || DisguiseConfig.isOverrideCustomNames() && object3.getName().equals("setCustomName")) && !commandSender.hasPermission("libsdisguises.multiname")) {
                object4 = DisguiseUtilities.quoteNewLine((String)object4);
            }
            object2 = object3.getMethod();
            object2 = FlagWatcher.class.isAssignableFrom(object3.getWatcherClass()) ? ((MethodHandle)object2).bindTo(disguise.getWatcher()) : ((MethodHandle)object2).bindTo(disguise);
            object2.invoke(object4);
        }
    }
}

