/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedParticle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public class ParamInfoParticle
extends ParamInfoEnum {
    private Material[] materials;

    public ParamInfoParticle(Class clazz, String string, String string2, Enum[] enumArray, Material[] materialArray) {
        super(clazz, string, string2, enumArray);
        this.materials = materialArray;
    }

    @Override
    public Set<String> getEnums(String string) {
        Set<String> set = this.getValues().keySet();
        if (string.isEmpty()) {
            return set;
        }
        set = new HashSet<String>(set);
        string = string.toUpperCase(Locale.ENGLISH);
        for (Particle particle : new Particle[]{Particle.BLOCK_CRACK, Particle.BLOCK_DUST, Particle.ITEM_CRACK}) {
            for (Material material : this.materials) {
                String string2;
                if (particle != Particle.ITEM_CRACK && !material.isBlock() || !(string2 = particle.name() + ":" + material.name()).startsWith(string)) continue;
                set.add(string2);
            }
        }
        return set;
    }

    @Override
    public String toString(Object object) {
        WrappedParticle wrappedParticle = (WrappedParticle)object;
        Object object2 = wrappedParticle.getData();
        String string = wrappedParticle.getParticle().name();
        if (object2 != null) {
            if (object2 instanceof ItemStack) {
                string = string + "," + ((ItemStack)object2).getType().name();
            } else if (object2 instanceof WrappedBlockData) {
                string = string + "," + ((WrappedBlockData)object2).getType().name();
            } else if (object2 instanceof Particle.DustOptions) {
                string = string + "," + ParamInfoManager.getParamInfo(Color.class).toString(((Particle.DustOptions)object2).getColor());
                if (((Particle.DustOptions)object2).getSize() != 1.0f) {
                    string = string + "," + ((Particle.DustOptions)object2).getSize();
                }
            }
        }
        return string;
    }

    @Override
    public Object fromString(String string) {
        String[] stringArray = string.split("[:,]");
        Particle particle = (Particle)super.fromString(stringArray[0]);
        if (particle == null) {
            return null;
        }
        ItemStack itemStack = null;
        switch (particle) {
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: {
                Material material;
                if (stringArray.length != 2 || (material = Material.getMaterial((String)stringArray[1])) == null || !material.isBlock()) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, particle.name(), string);
                }
                itemStack = WrappedBlockData.createData((Material)material);
                break;
            }
            case ITEM_CRACK: {
                if (stringArray.length != 1) {
                    itemStack = ParamInfoItemStack.parseToItemstack(Arrays.copyOfRange(stringArray, 1, stringArray.length));
                }
                if (itemStack != null) break;
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_ITEM, particle.name(), string);
            }
            case REDSTONE: {
                float f;
                if (stringArray.length < 2 || stringArray.length > 5) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                }
                Color color = ((ParamInfoColor)ParamInfoManager.getParamInfo(Color.class)).parseToColor(StringUtils.join((Object[])Arrays.copyOfRange(stringArray, 1, stringArray.length - stringArray.length % 2), (String)","));
                if (color == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                }
                if (stringArray.length % 2 == 0) {
                    f = 1.0f;
                } else {
                    if (!stringArray[stringArray.length - 1].matches("[0-9.]+")) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                    }
                    f = Math.max(0.2f, Float.parseFloat(stringArray[stringArray.length - 1]));
                }
                itemStack = new Particle.DustOptions(color, f);
            }
        }
        if (itemStack == null && stringArray.length > 1) {
            return null;
        }
        return WrappedParticle.create((Particle)particle, itemStack);
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

