/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ParamInfoItemStack
extends ParamInfoEnum {
    public ParamInfoItemStack(Class clazz, String string, String string2, String string3, Enum[] enumArray) {
        super(clazz, string, string2, string3, enumArray);
        if (this instanceof ParamInfoItemBlock) {
            return;
        }
        this.setOtherValues("null", "%held-item%", "%offhand-item%", "%helmet%", "%chestplate%", "%leggings%", "%boots%");
    }

    @Override
    public boolean canTranslateValues() {
        return false;
    }

    @Override
    public boolean canReturnNull() {
        return true;
    }

    @Override
    public Object fromString(String string) {
        return ParamInfoItemStack.parseToItemstack(string);
    }

    @Override
    public String toString(Object object) {
        ItemStack itemStack = (ItemStack)object;
        ItemStack itemStack2 = new ItemStack(itemStack.getType(), itemStack.getAmount());
        if (itemStack.containsEnchantment(Enchantment.DURABILITY)) {
            itemStack2.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        if (itemStack2.isSimilar(itemStack)) {
            String string = itemStack.getType().name();
            if (itemStack.getAmount() != 1) {
                string = string + ":" + itemStack.getAmount();
            }
            if (itemStack.containsEnchantment(Enchantment.DURABILITY)) {
                string = string + ":" + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow");
            }
            return string;
        }
        if (!MinecraftReflection.isCraftItemStack((Object)itemStack) && itemStack.hasItemMeta()) {
            itemStack = ReflectionManager.getCraftItem(itemStack);
        }
        String string = ReflectionManager.getItemName(itemStack.getType());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (NmsVersion.v1_13.isSupported() && itemStack.hasItemMeta()) {
            arrayList.add(string + DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)itemStack)));
        } else {
            arrayList.add(string);
        }
        if (itemStack.getAmount() != 1) {
            arrayList.add(String.valueOf(itemStack.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (itemStack.getDurability() != 0) {
                arrayList.add(String.valueOf(itemStack.getDurability()));
            }
            if (itemStack.hasItemMeta()) {
                arrayList.add(DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)itemStack)));
            }
        }
        return StringUtils.join(arrayList, (String)"-");
    }

    protected static ItemStack parseToItemstack(String string) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            try {
                return (ItemStack)DisguiseUtilities.getGson().fromJson(string, ItemStack.class);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        }
        if (!string.matches("[a-zA-Z0-9_:,]+")) {
            String[] stringArray;
            if (string.matches("^[^{]+?[ -]\\{[.].+?}$")) {
                stringArray = string.substring(0, string.indexOf("{") - 1).split("[ -]");
                stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
                stringArray[stringArray.length - 1] = string.substring(string.indexOf("{"));
            } else if (string.matches("^[^{ -]+?\\{.+?}([ -][0-9]+)?$")) {
                stringArray = new String[string.endsWith("}") ? 2 : 3];
                stringArray[0] = string.substring(0, string.indexOf("{"));
                stringArray[string.endsWith((String)"}") ? 1 : 2] = string.substring(string.indexOf("{"), string.lastIndexOf("}") + 1);
                if (!string.endsWith("}")) {
                    stringArray[1] = string.substring(string.lastIndexOf(" ") + 1);
                }
            } else {
                stringArray = string.split("[ -]");
            }
            Material material = ReflectionManager.getMaterial(stringArray[0].toLowerCase(Locale.ENGLISH));
            if (material == null) {
                material = Material.getMaterial((String)stringArray[0].toUpperCase(Locale.ENGLISH));
            }
            if (material == null || material == Material.AIR && !stringArray[0].equalsIgnoreCase("air")) {
                throw new IllegalArgumentException();
            }
            int n = stringArray.length > 1 && stringArray[1].matches("[0-9]+") ? Integer.parseInt(stringArray[1]) : 1;
            ItemStack itemStack = !NmsVersion.v1_13.isSupported() && stringArray.length > 2 && stringArray[2].matches("[0-9]+") ? new ItemStack(material, n, Short.parseShort(stringArray[2])) : new ItemStack(material, n);
            if (stringArray[stringArray.length - 1].contains("{")) {
                Bukkit.getUnsafe().modifyItemStack(itemStack, stringArray[stringArray.length - 1]);
            }
            return itemStack;
        }
        return ParamInfoItemStack.parseToItemstack(string.split("[:,]"));
    }

    protected static ItemStack parseToItemstack(String[] stringArray) {
        if (stringArray[0].isEmpty() || stringArray[0].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("null"))) {
            return null;
        }
        Material material = Material.getMaterial((String)stringArray[0].toUpperCase(Locale.ENGLISH));
        if (material == null || material == Material.AIR && !stringArray[0].equalsIgnoreCase("air")) {
            throw new IllegalArgumentException();
        }
        Integer n = null;
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!bl && string.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow"))) {
                bl = true;
                continue;
            }
            if (string.matches("\\d+") && n == null) {
                n = Integer.parseInt(string);
                continue;
            }
            throw new IllegalArgumentException();
        }
        ItemStack itemStack = new ItemStack(material, n == null ? 1 : n);
        if (bl) {
            itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        return itemStack;
    }

    @Override
    public boolean isParam(Class clazz) {
        return this.getParamClass().isAssignableFrom(clazz);
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

