/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import java.util.Arrays;
import java.util.Locale;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ParamInfoItemBlock
extends ParamInfoItemStack {
    public ParamInfoItemBlock(Class clazz, String string, String string2, String string3, Material[] materialArray) {
        super(clazz, string, string2, string3, (Enum[])Arrays.stream(materialArray).filter(material -> {
            switch (material) {
                case CHEST: 
                case TRAPPED_CHEST: {
                    return false;
                }
            }
            if (!material.isBlock()) {
                return false;
            }
            if (NmsVersion.v1_13.isSupported()) {
                return true;
            }
            switch (material) {
                case CAKE: 
                case FLOWER_POT: 
                case CAULDRON: 
                case BREWING_STAND: {
                    return false;
                }
            }
            return true;
        }).toArray(Material[]::new));
    }

    @Override
    public Object fromString(String string) {
        String[] stringArray = string.split("[:, -]", -1);
        if (stringArray.length > (NmsVersion.v1_13.isSupported() ? 1 : 3)) {
            throw new IllegalArgumentException();
        }
        Material material = ReflectionManager.getMaterial(stringArray[0].toLowerCase(Locale.ENGLISH));
        if (material == null || material == Material.AIR) {
            material = Material.getMaterial((String)stringArray[0].toUpperCase(Locale.ENGLISH));
        }
        if (material == null || material == Material.AIR && !stringArray[0].equalsIgnoreCase("air")) {
            throw new IllegalArgumentException();
        }
        ItemStack itemStack = !NmsVersion.v1_13.isSupported() && stringArray.length > 1 && stringArray[stringArray.length - 1].matches("[0-9]+") ? new ItemStack(material, 1, Short.parseShort(stringArray[stringArray.length - 1])) : new ItemStack(material, 1);
        if (!itemStack.getType().isBlock()) {
            throw new IllegalArgumentException();
        }
        return itemStack;
    }

    @Override
    public boolean isCustomValues() {
        return false;
    }
}

