/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class ParamInfoBlockData
extends ParamInfo {
    private Material[] materials;

    public ParamInfoBlockData(Class clazz, String string, String string2, Material[] materialArray) {
        super(clazz, string, "BlockData[State=Something]", string2);
        this.materials = (Material[])Arrays.stream(materialArray).filter(material -> {
            switch (material) {
                case CHEST: 
                case TRAPPED_CHEST: {
                    return false;
                }
            }
            if (!material.isBlock()) {
                return false;
            }
            if (NmsVersion.v1_13.isSupported()) {
                return true;
            }
            switch (material) {
                case CAKE: 
                case FLOWER_POT: 
                case CAULDRON: 
                case BREWING_STAND: {
                    return false;
                }
            }
            return true;
        }).toArray(Material[]::new);
    }

    @Override
    protected Object fromString(String string) {
        if (string == null || string.equals("null")) {
            return null;
        }
        return Bukkit.createBlockData((String)string.toLowerCase(Locale.ROOT));
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return ((BlockData)object).getAsString();
    }

    @Override
    public boolean isParam(Class clazz) {
        return this.getParamClass().isAssignableFrom(clazz);
    }

    @Override
    public Set<String> getEnums(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        HashSet<String> hashSet = new HashSet<String>();
        if (string2.matches("[a-z_:]+\\[.*")) {
            string2 = string2.substring(0, string2.indexOf("["));
        } else if (string.matches("[a-z:_]+")) {
            for (Material material : this.materials) {
                if (material.isLegacy() || !material.isBlock() || !material.name().toLowerCase(Locale.ENGLISH).startsWith(string2) && !material.getKey().toString().startsWith(string2)) continue;
                if (material.name().toLowerCase(Locale.ENGLISH).startsWith(string2)) {
                    hashSet.add(material.name());
                    continue;
                }
                hashSet.add(material.getKey().toString());
            }
        } else {
            return hashSet;
        }
        return hashSet;
    }
}

