/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.GolemCrack;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoBoolean;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoDouble;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoFloat;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoFloatNullable;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoInteger;
import me.libraryaddict.disguise.utilities.params.types.base.ParamInfoString;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoBlockData;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoBlockPosition;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoChatColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoEulerAngle;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoGameProfile;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStackArray;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoParticle;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoPotionEffect;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoSoundGroup;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoTime;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.TreeSpecies;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class ParamInfoTypes {
    public ParamInfoItemBlock getParamInfoBlock() {
        return new ParamInfoItemBlock(ItemStack.class, "ItemStack", "ItemStack (Material)", "An ItemStack compromised of Material", this.getMaterials());
    }

    public ParamInfoSoundGroup getParamInfoSoundGroup() {
        return new ParamInfoSoundGroup();
    }

    public List<ParamInfo> getParamInfos() {
        ArrayList<ParamInfo> arrayList = new ArrayList<ParamInfo>();
        arrayList.add(new ParamInfoEnum(Art.class, "Art", "View all the paintings you can use for a painting disguise"));
        arrayList.add(new ParamInfoEnum(Horse.Color.class, "Horse Color", "View all the colors you can use for a horses color"));
        arrayList.add(new ParamInfoEnum(Villager.Profession.class, "Villager Profession", "View all the professions you can set on a Villager and Zombie Villager"));
        if (NmsVersion.v1_14.isSupported()) {
            arrayList.add(new ParamInfoEnum(Villager.Type.class, "Villager Biome", "View all the biomes you can set on a Villager and Zombie Villager"));
        }
        arrayList.add(new ParamInfoEnum(BlockFace.class, "Direction", "Direction (North, East, South, West, Up, Down)", "View the directions usable on player setSleeping and shulker direction", (Enum[])Arrays.copyOf(BlockFace.values(), 6)));
        arrayList.add(new ParamInfoEnum(RabbitType.class, "Rabbit Type", "View the kinds of rabbits you can turn into"));
        arrayList.add(new ParamInfoEnum(TreeSpecies.class, "Tree Species", "View the different types of tree species"));
        arrayList.add(new ParamInfoEnum(MainHand.class, "Main Hand", "Set the main hand for an entity"));
        arrayList.add(new ParamInfoEnum(Llama.Color.class, "Llama Color", "View all the colors you can use for a llama color"));
        arrayList.add(new ParamInfoEnum(Parrot.Variant.class, "Parrot Variant", "View the different colors a parrot can be"));
        if (NmsVersion.v1_13.isSupported()) {
            arrayList.add(new ParamInfoParticle(WrappedParticle.class, "Particle", "The different particles of Minecraft", (Enum[])Particle.values(), this.getMaterials()));
            arrayList.add(new ParamInfoEnum(TropicalFish.Pattern.class, "Pattern", "Patterns of a tropical fish"));
            arrayList.add(new ParamInfoBlockData(BlockData.class, "BlockData", "The block data states, barrel[facing=north,open=false] as example", this.getMaterials()));
        } else {
            arrayList.add(new ParamInfoEnum(Particle.class, "Particle", "The different particles of Minecraft"));
        }
        arrayList.add(new ParamInfoEnum(DyeColor.class, "DyeColor", "Dye colors of many different colors"));
        arrayList.add(new ParamInfoEnum(Horse.Style.class, "Horse Style", "Horse style which is the patterns on the horse"));
        if (NmsVersion.v1_14.isSupported()) {
            arrayList.add(new ParamInfoEnum(EntityPose.class, "EntityPose", "The pose the entity should strike"));
            arrayList.add(new ParamInfoEnum(Cat.Type.class, "Cat Type", "The type of cat"));
            arrayList.add(new ParamInfoEnum(Fox.Type.class, "Fox Type", "The type of fox"));
            arrayList.add(new ParamInfoEnum(Panda.Gene.class, "Panda Gene", "The panda gene type"));
            arrayList.add(new ParamInfoEnum(MushroomCow.Variant.class, "Mushroom Cow Variant", "The different variants for mushroom cows"));
            if (NmsVersion.v1_17.isSupported()) {
                arrayList.add(new ParamInfoEnum(Axolotl.Variant.class, "Axolotl Variant", "The variant of Axolotl"));
            }
        } else {
            arrayList.add(new ParamInfoEnum(Ocelot.Type.class, "Ocelot Type", "The type of ocelot"));
        }
        arrayList.add(new ParamInfoEnum(DisguiseConfig.NotifyBar.class, "NotifyBar", "Where the disguised indicator should appear"));
        arrayList.add(new ParamInfoEnum(BarColor.class, "BarColor", "The color of the boss bar"));
        arrayList.add(new ParamInfoEnum(BarStyle.class, "BarStyle", "The style of the boss bar"));
        arrayList.add(new ParamInfoEulerAngle(EulerAngle.class, "Euler Angle", "Euler Angle (X,Y,Z)", "Set the X,Y,Z directions on an armorstand"));
        arrayList.add(new ParamInfoColor((Class)Color.class, "Color", "Colors that can also be defined through RGB", this.getColors()));
        arrayList.add(new ParamInfoEnum(Material.class, "Material", "A material used for blocks and items", (Enum[])this.getMaterials()));
        arrayList.add(new ParamInfoItemStack(ItemStack.class, "ItemStack", "ItemStack (Material,Amount?,Glow?)", "An ItemStack compromised of Material,Amount,Glow. Only requires Material", (Enum[])this.getMaterials()));
        arrayList.add(new ParamInfoItemStackArray(ItemStack[].class, "ItemStack[]", "Four ItemStacks (Material:Amount?:Glow?,Material:Amount?:Glow?..)", "Four ItemStacks separated by a comma", (Enum[])this.getMaterials()));
        arrayList.add(new ParamInfoPotionEffect(PotionEffectType.class, "Potion Effect", "View all the potion effects you can add", this.getPotions()));
        arrayList.add(new ParamInfoBlockPosition(BlockPosition.class, "Block Position", "Block Position (num,num,num)", "Three numbers separated by a ,"));
        arrayList.add(new ParamInfoGameProfile(WrappedGameProfile.class, "GameProfile", "Get the gameprofile here https://sessionserver.mojang.com/session/minecraft/profile/PLAYER_UUID_GOES_HERE?unsigned=false"));
        arrayList.add(new ParamInfoTime(Long.TYPE, "Expiry Time", "Set how long the disguise lasts, <Num><Time><Num>... where <Time> is (s/sec)(m/min)(h/hour)(d/day) etc. 30m20secs = 30 minutes, 20 seconds"));
        arrayList.add(new ParamInfoChatColor(ChatColor.class, "ChatColor", "A chat color"));
        arrayList.add(new ParamInfoEnum(GolemCrack.class, "Golem Cracked", "The stage a golem has been cracked"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("true", true);
        hashMap.put("false", false);
        arrayList.add(new ParamInfoBoolean("Boolean", "True/False", "True or False", hashMap));
        arrayList.add(new ParamInfoString(String.class, "Text", "A line of text"));
        arrayList.add(new ParamInfoInteger("Number", "A whole number without decimals"));
        arrayList.add(new ParamInfoFloat("Number.0", "A number which can have decimal places"));
        arrayList.add(new ParamInfoFloatNullable("Number.0", "A number which can have decimal places or be null"));
        arrayList.add(new ParamInfoDouble("Number.0", "A number which can have decimal places"));
        arrayList.add(new ParamInfoSoundGroup());
        return arrayList;
    }

    private Map<String, Color> getColors() {
        try {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            Class<?> clazz = Class.forName("org.bukkit.Color");
            for (Field field : clazz.getFields()) {
                if (field.getType() != clazz) continue;
                hashMap.put(field.getName(), (Color)field.get(null));
            }
            return hashMap;
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    private Material[] getMaterials() {
        ArrayList<Material> arrayList = new ArrayList<Material>();
        for (Material material : Material.values()) {
            if (material.name().matches("([A-Z]+_)?AIR")) continue;
            try {
                Field field = Material.class.getField(material.name());
                if (field.isAnnotationPresent(Deprecated.class)) continue;
                arrayList.add(material);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new Material[0]);
    }

    private Map<String, Object> getPotions() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (PotionEffectType potionEffectType : PotionEffectType.values()) {
            if (potionEffectType == null) continue;
            hashMap.put(this.toReadable(potionEffectType.getName()), potionEffectType);
        }
        return hashMap;
    }

    private String toReadable(String string) {
        Object[] objectArray = string.split("_");
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ((String)objectArray[i]).substring(0, 1) + ((String)objectArray[i]).substring(1).toLowerCase(Locale.ENGLISH);
        }
        return StringUtils.join((Object[])objectArray, (String)"_");
    }
}

