/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EndermanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoTypes;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoSoundGroup;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ParamInfoManager {
    private static List<ParamInfo> paramList;
    private static DisguiseMethods disguiseMethods;
    private static ParamInfoItemBlock paramInfoItemBlock;
    private static ParamInfoSoundGroup paramInfoSoundGroup;

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ParamInfo paramInfo = ParamInfoManager.getParamInfo(object.getClass());
        if (paramInfo == null) {
            throw new IllegalArgumentException(object.getClass() + " is not handled by ParamInfo!");
        }
        return paramInfo.toString(object);
    }

    public static ParamInfo getParamInfo(WatcherMethod watcherMethod) {
        if (watcherMethod.getName().equals("setSoundGroup")) {
            return ParamInfoManager.getParamInfoSoundGroup();
        }
        if (watcherMethod.getWatcherClass() == EndermanWatcher.class && watcherMethod.getName().equalsIgnoreCase("setItemInMainHand")) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        if (watcherMethod.getWatcherClass() == FallingBlockWatcher.class && (watcherMethod.getParam() == Material.class || watcherMethod.getParam() == ItemStack.class)) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        return ParamInfoManager.getParamInfo(watcherMethod.getParam());
    }

    public static ParamInfo getParamInfo(Class clazz) {
        if (clazz.isAnonymousClass()) {
            clazz = clazz.getSuperclass();
        }
        for (ParamInfo paramInfo : ParamInfoManager.getParamInfos()) {
            if (!paramInfo.isParam(clazz)) continue;
            return paramInfo;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguisePerm, String string) {
        return ParamInfoManager.getParamInfo(disguisePerm.getType(), string);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String string) {
        for (WatcherMethod watcherMethod : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!watcherMethod.getName().toLowerCase(Locale.ENGLISH).equals(string.toLowerCase(Locale.ENGLISH))) continue;
            return ParamInfoManager.getParamInfo(watcherMethod);
        }
        return null;
    }

    public static WatcherMethod[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> clazz) {
        return ParamInfoManager.getDisguiseWatcherMethods(clazz, false);
    }

    public static WatcherMethod[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> clazz, boolean bl) {
        if (clazz == null) {
            return new WatcherMethod[0];
        }
        ArrayList<WatcherMethod> arrayList = new ArrayList<WatcherMethod>(disguiseMethods.getMethods(clazz));
        if (!bl) {
            arrayList.removeIf(WatcherMethod::isHideFromTab);
        }
        arrayList.sort((watcherMethod, watcherMethod2) -> {
            int n;
            int n2 = ParamInfoManager.getValue(watcherMethod);
            if (n2 != (n = ParamInfoManager.getValue(watcherMethod2))) {
                return n2 - n;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(watcherMethod.getName(), watcherMethod2.getName());
        });
        return arrayList.toArray(new WatcherMethod[0]);
    }

    public static int getValue(WatcherMethod watcherMethod) {
        Class<? extends FlagWatcher> clazz = watcherMethod.getWatcherClass();
        if (clazz == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(clazz) || clazz == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }

    public static DisguiseMethods getDisguiseMethods() {
        return disguiseMethods;
    }

    public static ParamInfoItemBlock getParamInfoItemBlock() {
        return paramInfoItemBlock;
    }

    public static ParamInfoSoundGroup getParamInfoSoundGroup() {
        return paramInfoSoundGroup;
    }

    static {
        ParamInfoTypes paramInfoTypes = new ParamInfoTypes();
        paramList = paramInfoTypes.getParamInfos();
        paramInfoItemBlock = paramInfoTypes.getParamInfoBlock();
        paramInfoSoundGroup = paramList.stream().filter(paramInfo -> paramInfo instanceof ParamInfoSoundGroup).findAny().orElse(null);
        disguiseMethods = new DisguiseMethods();
    }
}

