/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.libraryaddict.disguise.utilities.translations.TranslateType;

public abstract class ParamInfo {
    private Class paramClass;
    private String descriptiveName;
    private String name;
    private Map<String, Object> possibleValues;
    private String[] otherValues;
    private String description;

    public ParamInfo(Class clazz, String string, String string2) {
        this(clazz, string, string, string2);
    }

    public ParamInfo(Class clazz, String string, String string2, String string3) {
        this.name = string;
        this.paramClass = clazz;
        this.descriptiveName = string2;
        this.description = string3;
    }

    public ParamInfo(Class clazz, String string, String string2, Enum[] enumArray) {
        this(clazz, string, string, string2, enumArray);
    }

    public ParamInfo(Class clazz, String string, String string2, String string3, Enum[] enumArray) {
        this(clazz, string, string2, string3);
        this.possibleValues = new LinkedHashMap<String, Object>();
        for (Enum enum_ : enumArray) {
            this.getValues().put(enum_.name(), enum_);
        }
    }

    public ParamInfo(Class clazz, String string, String string2, Map<String, Object> map) {
        this(clazz, string, string, string2, map);
    }

    public ParamInfo(Class clazz, String string, String string2, String string3, Map<String, Object> map) {
        this(clazz, string, string2, string3);
        this.possibleValues = new LinkedHashMap<String, Object>();
        this.possibleValues.putAll(map);
    }

    public boolean canTranslateValues() {
        return this.getValues() != null;
    }

    public String[] getOtherValues() {
        return this.otherValues;
    }

    public void setOtherValues(String ... stringArray) {
        if (this.otherValues != null) {
            this.otherValues = Arrays.copyOf(this.otherValues, this.otherValues.length + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.otherValues[this.otherValues.length - (stringArray.length - i)] = stringArray[i];
            }
        } else {
            this.otherValues = stringArray;
        }
    }

    public boolean canReturnNull() {
        return false;
    }

    protected abstract Object fromString(String var1);

    public abstract String toString(Object var1);

    public Object fromString(List<String> list) {
        String string = list.get(0);
        Object object = this.fromString(string);
        if (object == null && !this.canReturnNull()) {
            throw new IllegalArgumentException();
        }
        list.remove(0);
        return object;
    }

    public int getMinArguments() {
        return 1;
    }

    public boolean hasValues() {
        return this.getValues() != null;
    }

    protected Class getParamClass() {
        return this.paramClass;
    }

    public boolean isParam(Class clazz) {
        return this.getParamClass() == clazz;
    }

    public String getName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawName());
    }

    public String getDescriptiveName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescriptiveName());
    }

    public String getRawName() {
        return this.name;
    }

    public String getRawDescriptiveName() {
        return this.descriptiveName;
    }

    public String getDescription() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescription());
    }

    public String getRawDescription() {
        return this.description;
    }

    public Map<String, Object> getValues() {
        return this.possibleValues;
    }

    public Set<String> getEnums(String string) {
        if (this.getOtherValues() != null) {
            HashSet<String> hashSet = new HashSet<String>(this.getValues().keySet());
            hashSet.addAll(Arrays.asList(this.getOtherValues()));
            return hashSet;
        }
        return this.getValues().keySet();
    }

    public boolean isCustomValues() {
        return true;
    }
}

