/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerSounds
extends PacketAdapter {
    private static boolean cancelSound;

    public PacketListenerSounds(LibsDisguises libsDisguises) {
        super((Plugin)libsDisguises, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT, PacketType.Play.Server.ENTITY_STATUS});
    }

    public void onPacketSending(PacketEvent packetEvent) {
        if (packetEvent.isCancelled() || packetEvent.isAsync() || packetEvent.isPlayerTemporary()) {
            return;
        }
        if (packetEvent.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
            this.handleEntityStatus(packetEvent);
        } else if (packetEvent.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT) {
            this.handleNamedSoundEffect(packetEvent);
        }
    }

    private void handleNamedSoundEffect(PacketEvent packetEvent) {
        Object object;
        Location location;
        StructureModifier structureModifier = packetEvent.getPacket().getModifier();
        Player player = packetEvent.getPlayer();
        SoundGroup.SoundType soundType = null;
        Entity entity = null;
        SoundGroup soundGroup = null;
        Object object4 = structureModifier.read(0);
        Disguise disguise = null;
        int[] nArray = new int[]{(Integer)structureModifier.read(2), (Integer)structureModifier.read(3), (Integer)structureModifier.read(4)};
        for (Set<TargetedDisguise> object32 : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise f : object32) {
                Entity f2 = f.getEntity();
                if (f2 == null || f2.getWorld() != player.getWorld() || !f.canSee(player)) continue;
                location = f2.getLocation();
                object = new int[]{(int)(location.getX() * 8.0), (int)(location.getY() * 8.0), (int)(location.getZ() * 8.0)};
                if (nArray[0] != object[0] || nArray[1] != object[1] || nArray[2] != object[2]) continue;
                disguise = f;
                entity = f2;
                soundGroup = SoundGroup.getGroup(f2.getType().name());
                if (soundGroup.getSound(object4) == null) {
                    return;
                }
                if (!(f2 instanceof LivingEntity) || ((LivingEntity)f2).getHealth() > 0.0) {
                    boolean bl = ReflectionManager.hasInvul(f2);
                    soundType = soundGroup.getType(object4, !bl);
                    continue;
                }
                soundType = SoundGroup.SoundType.DEATH;
            }
            if (disguise == null) continue;
            break;
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        if (soundType == SoundGroup.SoundType.STEP || soundType != SoundGroup.SoundType.IDLE) {
            // empty if block
        }
        if (entity == player && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        Object object5 = null;
        SoundGroup soundGroup2 = SoundGroup.getGroup(disguise);
        if (soundGroup2 != null) {
            object5 = soundGroup2.getSound(soundType);
        }
        if (object5 == null) {
            packetEvent.setCancelled(true);
            return;
        }
        Enum enum_ = ReflectionManager.getSoundCategory(disguise.getType());
        float f = ((Float)structureModifier.read(5)).floatValue();
        float f2 = ((Float)structureModifier.read(6)).floatValue();
        if (f == soundGroup.getDamageAndIdleSoundVolume()) {
            f = soundGroup2.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && entity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            f2 = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if (object5.getClass().getSimpleName().equals("MinecraftKey")) {
            location = new PacketContainer(PacketType.Play.Server.CUSTOM_SOUND_EFFECT);
            object = location.getModifier();
            object.write(2, structureModifier.read(2));
            object.write(3, structureModifier.read(3));
            object.write(4, structureModifier.read(4));
        } else {
            location = packetEvent.getPacket().shallowClone();
            structureModifier = location.getModifier();
        }
        structureModifier.write(0, object5);
        structureModifier.write(1, (Object)enum_);
        structureModifier.write(5, (Object)Float.valueOf(f));
        structureModifier.write(6, (Object)Float.valueOf(f2));
        packetEvent.setPacket((PacketContainer)location);
    }

    private void handleEntityStatus(PacketEvent packetEvent) {
        Object object;
        Object object2;
        Object object3;
        StructureModifier structureModifier = packetEvent.getPacket().getModifier();
        Player player = packetEvent.getPlayer();
        if ((Byte)structureModifier.read(1) != 2) {
            return;
        }
        Disguise disguise = DisguiseUtilities.getDisguise(player, (Integer)packetEvent.getPacket().getIntegers().read(0));
        if (disguise == null) {
            return;
        }
        Entity entity = disguise.getEntity();
        if (disguise instanceof TargetedDisguise) {
            object3 = DisguiseUtilities.getDisguises().get(entity.getEntityId());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (TargetedDisguise)object2.next();
                if (object != disguise || ((TargetedDisguise)object).canSee(player)) continue;
                return;
            }
        }
        object3 = SoundGroup.SoundType.HURT;
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getHealth() <= 0.0) {
            object3 = SoundGroup.SoundType.DEATH;
        }
        if (entity == packetEvent.getPlayer() && !disguise.getType().isPlayer() && !disguise.isSelfDisguiseSoundsReplaced()) {
            boolean bl = cancelSound = !cancelSound;
            if (cancelSound) {
                return;
            }
        }
        if ((object2 = SoundGroup.getGroup(entity.getType().name())) == null) {
            return;
        }
        object = ((SoundGroup)object2).getSound((SoundGroup.SoundType)((Object)object3));
        if (object == null) {
            return;
        }
        SoundGroup soundGroup = SoundGroup.getGroup(disguise);
        SoundGroup soundGroup2 = SoundGroup.getGroup(disguise.getType().name());
        if (soundGroup == null || soundGroup == soundGroup2) {
            return;
        }
        Location location = entity.getLocation();
        PacketContainer packetContainer = new PacketContainer(object.getClass().getSimpleName().equals("MinecraftKey") ? PacketType.Play.Server.CUSTOM_SOUND_EFFECT : PacketType.Play.Server.NAMED_SOUND_EFFECT);
        structureModifier = packetContainer.getModifier();
        structureModifier.write(0, object);
        structureModifier.write(1, (Object)ReflectionManager.getSoundCategory(disguise.getType()));
        structureModifier.write(2, (Object)((int)(location.getX() * 8.0)));
        structureModifier.write(3, (Object)((int)(location.getY() * 8.0)));
        structureModifier.write(4, (Object)((int)(location.getZ() * 8.0)));
        structureModifier.write(5, (Object)Float.valueOf(soundGroup.getDamageAndIdleSoundVolume()));
        float f = disguise instanceof MobDisguise && !((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f;
        if (disguise.getType() == DisguiseType.BAT) {
            f *= 0.95f;
        }
        structureModifier.write(6, (Object)Float.valueOf(f));
        packetEvent.setCancelled(true);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

