/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerModdedClient
extends PacketAdapter {
    private final Cache<String, String> loginAttempts = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private final int packetId1 = 5555554;
    private final int packetId2 = 5555555;

    public PacketListenerModdedClient() {
        super((Plugin)LibsDisguises.getInstance(), new PacketType[]{PacketType.Login.Client.START, PacketType.Login.Client.CUSTOM_PAYLOAD});
    }

    private int getInt(ByteBuf byteBuf) {
        byte by;
        int n = 0;
        int n2 = 0;
        do {
            by = byteBuf.readByte();
            n |= (by & 0x7F) << n2++ * 7;
            if (n2 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((by & 0x80) == 128);
        return n;
    }

    private void handleModlist(Player player, String string, byte[] byArray) {
        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])byArray);
        int n = this.getInt(byteBuf);
        if (n != 2) {
            return;
        }
        int n2 = this.getInt(byteBuf);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.getString(byteBuf));
        }
        ModdedManager.getForgeMods().put((Object)string, arrayList);
    }

    public String getString(ByteBuf byteBuf) {
        int n;
        int n2 = this.getInt(byteBuf);
        if (n2 > (n = 256) * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + n2 + " > " + n * 4 + ")");
        }
        if (n2 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String string = byteBuf.toString(byteBuf.readerIndex(), n2, StandardCharsets.UTF_8);
        byteBuf.readerIndex(byteBuf.readerIndex() + n2);
        if (string.length() > n) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + n2 + " > " + n + ")");
        }
        return string;
    }

    private void handleDataReceived(Player player, String string) {
        PacketContainer packetContainer = new PacketContainer(PacketType.Login.Client.START);
        packetContainer.getModifier().write(0, (Object)new GameProfile(null, string));
        try {
            ProtocolLibrary.getProtocolManager().recieveClientPacket(player, packetContainer, false);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    public void onPacketReceiving(PacketEvent packetEvent) {
        packetEvent.setCancelled(true);
        if (packetEvent.getPacketType() != PacketType.Login.Client.START) {
            ByteBuf byteBuf;
            String string = packetEvent.getPlayer().getAddress().toString();
            String string2 = (String)this.loginAttempts.getIfPresent((Object)string);
            if (string2 == null) {
                return;
            }
            if ((Integer)packetEvent.getPacket().getIntegers().read(0) == 5555555) {
                this.loginAttempts.invalidate((Object)string);
                this.handleDataReceived(packetEvent.getPlayer(), string2);
                return;
            }
            if ((Integer)packetEvent.getPacket().getIntegers().read(0) == 5555554 && (byteBuf = (ByteBuf)packetEvent.getPacket().getModifier().read(1)) != null) {
                byte[] byArray = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(byArray);
                this.handleModlist(packetEvent.getPlayer(), string2, byArray);
            }
            return;
        }
        this.loginAttempts.put((Object)packetEvent.getPlayer().getAddress().toString(), (Object)((WrappedGameProfile)packetEvent.getPacket().getGameProfiles().read(0)).getName());
        PacketContainer packetContainer = new PacketContainer(PacketType.Login.Server.CUSTOM_PAYLOAD);
        packetContainer.getIntegers().write(0, (Object)5555554);
        packetContainer.getMinecraftKeys().write(0, (Object)new MinecraftKey("fml", "handshake"));
        try {
            Object t = ReflectionManager.getNmsConstructor("PacketDataSerializer", ByteBuf.class).newInstance(Unpooled.wrappedBuffer((byte[])ModdedManager.getFmlHandshake()));
            packetContainer.getModifier().write(2, t);
            PacketContainer packetContainer2 = new PacketContainer(PacketType.Login.Server.CUSTOM_PAYLOAD);
            packetContainer2.getIntegers().write(0, (Object)5555555);
            packetContainer2.getMinecraftKeys().write(0, (Object)new MinecraftKey("fml", "handshake"));
            Object t2 = ReflectionManager.getNmsConstructor("PacketDataSerializer", ByteBuf.class).newInstance(Unpooled.wrappedBuffer((byte[])ModdedManager.getFmlRegistries()));
            packetContainer2.getModifier().write(2, t2);
            ProtocolLibrary.getProtocolManager().sendServerPacket(packetEvent.getPlayer(), packetContainer);
            ProtocolLibrary.getProtocolManager().sendServerPacket(packetEvent.getPlayer(), packetContainer2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

