/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerMain
extends PacketAdapter {
    public PacketListenerMain(LibsDisguises libsDisguises, ArrayList<PacketType> arrayList) {
        super((Plugin)libsDisguises, ListenerPriority.HIGH, arrayList);
    }

    public void onPacketSending(PacketEvent packetEvent) {
        LibsPackets libsPackets;
        if (packetEvent.isCancelled()) {
            return;
        }
        Player player = packetEvent.getPlayer();
        if (player.getName().contains("UNKNOWN[")) {
            return;
        }
        int n = (Integer)packetEvent.getPacket().getIntegers().read(PacketType.Play.Server.COLLECT == packetEvent.getPacketType() ? 1 : 0);
        Disguise disguise = DisguiseUtilities.getDisguise(player, n);
        if (disguise == null || disguise.getEntity() == player) {
            return;
        }
        try {
            libsPackets = PacketsManager.getPacketsHandler().transformPacket(packetEvent.getPacket(), disguise, player, disguise.getEntity());
            if (disguise.isPlayerDisguise()) {
                LibsDisguises.getInstance().getSkinHandler().handlePackets(player, (PlayerDisguise)disguise, libsPackets);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            packetEvent.setCancelled(true);
            return;
        }
        if (libsPackets.isUnhandled()) {
            return;
        }
        packetEvent.setCancelled(true);
        try {
            for (PacketContainer packetContainer : libsPackets.getPackets()) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
            }
            libsPackets.sendDelayed(player);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

