/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerEntityDestroy
extends PacketAdapter {
    public PacketListenerEntityDestroy(Plugin plugin) {
        super(plugin, new PacketType[]{PacketType.Play.Server.ENTITY_DESTROY});
    }

    public void onPacketSending(PacketEvent packetEvent) {
        if (packetEvent.isCancelled()) {
            return;
        }
        if (!NmsVersion.v1_17.isSupported()) {
            int[] nArray;
            for (int n : nArray = (int[])packetEvent.getPacket().getIntegerArrays().read(0)) {
                this.handleEntityId(packetEvent.getPlayer(), n);
            }
            return;
        }
        List list = (List)packetEvent.getPacket().getIntLists().read(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.handleEntityId(packetEvent.getPlayer(), n);
        }
    }

    private int[] getToRemove(Player player, int n) {
        if (n == DisguiseAPI.getSelfDisguiseId()) {
            return null;
        }
        Disguise disguise = DisguiseUtilities.getDisguise(player, n);
        if (disguise == null) {
            return null;
        }
        int n2 = disguise.getMultiNameLength();
        if (n2 == 0) {
            return null;
        }
        return disguise.getArmorstandIds();
    }

    private void handleEntityId(Player player, int n) {
        int[] nArray = this.getToRemove(player, n);
        if (nArray == null) {
            return;
        }
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, DisguiseUtilities.getDestroyPacket(nArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

