/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LlamaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.events.DisguiseInteractEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListenerClientInteract
extends PacketAdapter {
    public PacketListenerClientInteract(LibsDisguises libsDisguises) {
        super((Plugin)libsDisguises, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.USE_ENTITY});
    }

    public void onPacketReceiving(PacketEvent packetEvent) {
        PacketContainer packetContainer;
        if (packetEvent.isCancelled()) {
            return;
        }
        final Player player = packetEvent.getPlayer();
        if (player == null || packetEvent.isPlayerTemporary() || player.getName().contains("UNKNOWN[")) {
            return;
        }
        if (!player.isOp() && ("802393".equals("12345") || LibsDisguises.getInstance().getUpdateChecker().isGoSilent())) {
            packetEvent.setCancelled(true);
        }
        if ((Integer)(packetContainer = packetEvent.getPacket()).getIntegers().read(0) == DisguiseAPI.getSelfDisguiseId()) {
            packetEvent.setCancelled(true);
        } else if (DisguiseUtilities.isNotInteractable((Integer)packetContainer.getIntegers().read(0))) {
            packetEvent.setCancelled(true);
        } else if (DisguiseUtilities.isSpecialInteract((Integer)packetContainer.getIntegers().read(0)) && this.getHand(packetContainer) == EnumWrappers.Hand.OFF_HAND) {
            packetEvent.setCancelled(true);
        }
        if (packetEvent.isAsync()) {
            new BukkitRunnable(){

                public void run() {
                    PacketListenerClientInteract.this.handleSync(player, packetContainer);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        } else {
            this.handleSync(player, packetContainer);
        }
    }

    private EnumWrappers.Hand getHand(PacketContainer packetContainer) {
        if (!NmsVersion.v1_17.isSupported()) {
            if (this.getInteractType(packetContainer) != EnumWrappers.EntityUseAction.ATTACK) {
                return (EnumWrappers.Hand)packetContainer.getHands().read(0);
            }
            return EnumWrappers.Hand.MAIN_HAND;
        }
        WrappedEnumEntityUseAction wrappedEnumEntityUseAction = (WrappedEnumEntityUseAction)packetContainer.getEnumEntityUseActions().read(0);
        if (wrappedEnumEntityUseAction.getAction() == EnumWrappers.EntityUseAction.ATTACK) {
            return EnumWrappers.Hand.MAIN_HAND;
        }
        return wrappedEnumEntityUseAction.getHand();
    }

    private EnumWrappers.EntityUseAction getInteractType(PacketContainer packetContainer) {
        if (!NmsVersion.v1_17.isSupported()) {
            return (EnumWrappers.EntityUseAction)packetContainer.getEntityUseActions().read(0);
        }
        return ((WrappedEnumEntityUseAction)packetContainer.getEnumEntityUseActions().read(0)).getAction();
    }

    private void handleSync(Player player, PacketContainer packetContainer) {
        final Disguise disguise = DisguiseUtilities.getDisguise(player, (Integer)packetContainer.getIntegers().read(0));
        if (disguise == null) {
            return;
        }
        if (disguise.getEntity() == player) {
            final EnumWrappers.EntityUseAction entityUseAction = this.getInteractType(packetContainer);
            final EquipmentSlot equipmentSlot = entityUseAction != EnumWrappers.EntityUseAction.ATTACK && this.getHand(packetContainer) == EnumWrappers.Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND;
            new BukkitRunnable(){

                public void run() {
                    DisguiseInteractEvent disguiseInteractEvent = new DisguiseInteractEvent((TargetedDisguise)disguise, equipmentSlot, entityUseAction == EnumWrappers.EntityUseAction.ATTACK);
                    Bukkit.getPluginManager().callEvent((Event)disguiseInteractEvent);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        }
        switch (disguise.getType()) {
            case AXOLOTL: {
                if (disguise.getEntity() instanceof Axolotl) break;
                DisguiseUtilities.refreshTrackers((TargetedDisguise)disguise);
                player.updateInventory();
                break;
            }
            case CAT: 
            case WOLF: 
            case SHEEP: {
                this.doDyeable(player, disguise);
                break;
            }
            case MULE: 
            case DONKEY: 
            case HORSE: 
            case ZOMBIE_HORSE: 
            case SKELETON_HORSE: {
                if (!DisguiseConfig.isHorseSaddleable()) break;
                this.doSaddleable(player, disguise);
                break;
            }
            case LLAMA: 
            case TRADER_LLAMA: {
                if (!DisguiseConfig.isLlamaCarpetable()) break;
                this.doCarpetable(player, disguise);
                break;
            }
        }
    }

    private void doSaddleable(final Player player, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack itemStack : new ItemStack[]{player.getInventory().getItemInMainHand(), player.getInventory().getItemInOffHand()}) {
                    if (itemStack == null || itemStack.getType() != Material.SADDLE) continue;
                    AbstractHorseWatcher abstractHorseWatcher = (AbstractHorseWatcher)disguise.getWatcher();
                    abstractHorseWatcher.setSaddled(true);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doCarpetable(final Player player, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack itemStack : new ItemStack[]{player.getInventory().getItemInMainHand(), player.getInventory().getItemInOffHand()}) {
                    AnimalColor animalColor;
                    if (itemStack == null || !itemStack.getType().name().endsWith("_CARPET") || (animalColor = AnimalColor.getColorByItem(itemStack)) == null) continue;
                    LlamaWatcher llamaWatcher = (LlamaWatcher)disguise.getWatcher();
                    llamaWatcher.setSaddled(true);
                    llamaWatcher.setCarpet(animalColor);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doDyeable(final Player player, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack itemStack : new ItemStack[]{player.getInventory().getItemInMainHand(), player.getInventory().getItemInOffHand()}) {
                    AnimalColor animalColor;
                    if (itemStack == null || (animalColor = AnimalColor.getColorByItem(itemStack)) == null) continue;
                    if (disguise.getType() == DisguiseType.SHEEP) {
                        SheepWatcher sheepWatcher = (SheepWatcher)disguise.getWatcher();
                        sheepWatcher.setColor(DisguiseConfig.isSheepDyeable() ? animalColor.getDyeColor() : sheepWatcher.getColor());
                        break;
                    }
                    if (disguise.getType() == DisguiseType.WOLF) {
                        WolfWatcher wolfWatcher = (WolfWatcher)disguise.getWatcher();
                        wolfWatcher.setCollarColor(DisguiseConfig.isWolfDyeable() ? animalColor.getDyeColor() : wolfWatcher.getCollarColor());
                        break;
                    }
                    if (disguise.getType() != DisguiseType.CAT) continue;
                    CatWatcher catWatcher = (CatWatcher)disguise.getWatcher();
                    catWatcher.setCollarColor(DisguiseConfig.isCatDyeable() ? animalColor.getDyeColor() : catWatcher.getCollarColor());
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }
}

