/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketHandlerAttributes
implements IPacketHandler {
    private boolean skipAttributes;

    public PacketHandlerAttributes() {
        boolean bl = this.skipAttributes = !NmsVersion.v1_14.isSupported() && ProtocolLibrary.getPlugin().getDescription().getVersion().equals("4.5.0");
        if (!this.skipAttributes) {
            return;
        }
        DisguiseUtilities.getLogger().info("You are running ProtocolLib 4.5.0, attributes will not be handled; Update if you can.");
    }

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.UPDATE_ATTRIBUTES};
    }

    @Override
    public void handle(Disguise disguise, PacketContainer packetContainer, LibsPackets libsPackets, Player player, Entity entity) {
        libsPackets.clear();
        if (this.skipAttributes) {
            return;
        }
        if (disguise.isMiscDisguise()) {
            return;
        }
        ArrayList<WrappedAttribute> arrayList = new ArrayList<WrappedAttribute>();
        PacketContainer packetContainer2 = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
        for (WrappedAttribute wrappedAttribute : (List)packetContainer.getAttributeCollectionModifier().read(0)) {
            WrappedAttribute.Builder builder;
            if (wrappedAttribute.getAttributeKey().equals(NmsVersion.v1_16.isSupported() ? "generic.max_health" : "generic.maxHealth")) {
                if (disguise.getWatcher() instanceof LivingWatcher && ((LivingWatcher)disguise.getWatcher()).isMaxHealthSet()) {
                    builder = WrappedAttribute.newBuilder();
                    builder.attributeKey(wrappedAttribute.getAttributeKey());
                    builder.baseValue(((LivingWatcher)disguise.getWatcher()).getMaxHealth());
                } else if (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity()) {
                    builder = WrappedAttribute.newBuilder((WrappedAttribute)wrappedAttribute);
                } else {
                    builder = WrappedAttribute.newBuilder();
                    builder.attributeKey(wrappedAttribute.getAttributeKey());
                    builder.baseValue(DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
                }
                builder.packet(packetContainer2);
                arrayList.add(builder.build());
                continue;
            }
            if (!wrappedAttribute.getAttributeKey().equals(NmsVersion.v1_16.isSupported() ? "generic.movement_speed" : "generic.movementSpeed") || !(disguise.getWatcher() instanceof AbstractHorseWatcher)) continue;
            builder = WrappedAttribute.newBuilder((WrappedAttribute)wrappedAttribute);
            builder.packet(packetContainer2);
            arrayList.add(builder.build());
        }
        if (!arrayList.isEmpty()) {
            libsPackets.addPacket(packetContainer2);
            packetContainer2.getIntegers().write(0, (Object)entity.getEntityId());
            packetContainer2.getAttributeCollectionModifier().write(0, arrayList);
        }
    }
}

