/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientCustomPayload;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerEntityDestroy;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerScoreboardTeam;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerTabList;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerViewSelfDisguise;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketsManager {
    private static PacketListener clientInteractEntityListener;
    private static PacketListener inventoryListener;
    private static boolean inventoryModifierEnabled;
    private static PacketListener mainListener;
    private static PacketListener soundsListener;
    private static boolean soundsListenerEnabled;
    private static PacketListener viewDisguisesListener;
    private static boolean viewDisguisesListenerEnabled;
    private static PacketsHandler packetsHandler;
    private static PacketListener destroyListener;
    private static PacketListener scoreboardTeamListener;

    public static void addPacketListeners() {
        clientInteractEntityListener = new PacketListenerClientInteract(LibsDisguises.getInstance());
        PacketListenerTabList packetListenerTabList = new PacketListenerTabList(LibsDisguises.getInstance());
        ProtocolLibrary.getProtocolManager().addPacketListener(clientInteractEntityListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)packetListenerTabList);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketListenerClientCustomPayload());
        PacketsManager.setupMainPacketsListener();
    }

    public static void init() {
        soundsListener = new PacketListenerSounds(LibsDisguises.getInstance());
        viewDisguisesListener = new PacketListenerViewSelfDisguise(LibsDisguises.getInstance());
        inventoryListener = new PacketListenerInventory(LibsDisguises.getInstance());
        packetsHandler = new PacketsHandler();
    }

    public static PacketsHandler getPacketsHandler() {
        return packetsHandler;
    }

    public static boolean isHearDisguisesEnabled() {
        return soundsListenerEnabled;
    }

    public static boolean isInventoryListenerEnabled() {
        return inventoryModifierEnabled;
    }

    public static void setInventoryListenerEnabled(boolean bl) {
        if (inventoryModifierEnabled != bl) {
            inventoryModifierEnabled = bl;
            if (inventoryModifierEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(inventoryListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(inventoryListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !viewDisguisesListenerEnabled || !disguise.isSelfDisguiseVisible() || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }

    public static boolean isViewDisguisesListenerEnabled() {
        return viewDisguisesListenerEnabled;
    }

    public static void setHearDisguisesListener(boolean bl) {
        if (soundsListenerEnabled != bl) {
            soundsListenerEnabled = bl;
            if (soundsListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(soundsListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(soundsListener);
            }
        }
    }

    public static void setupMainPacketsListener() {
        if (clientInteractEntityListener != null) {
            if (mainListener != null) {
                ProtocolLibrary.getProtocolManager().removePacketListener(mainListener);
            }
            ArrayList<PacketType> arrayList = new ArrayList<PacketType>();
            arrayList.add(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            arrayList.add(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB);
            arrayList.add(PacketType.Play.Server.SPAWN_ENTITY);
            arrayList.add(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            arrayList.add(PacketType.Play.Server.SPAWN_ENTITY_PAINTING);
            arrayList.add(PacketType.Play.Server.ENTITY_METADATA);
            if (DisguiseConfig.isCollectPacketsEnabled()) {
                arrayList.add(PacketType.Play.Server.COLLECT);
            }
            if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
                arrayList.add(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            }
            if (DisguiseConfig.isMovementPacketsEnabled()) {
                arrayList.add(PacketType.Play.Server.ENTITY_LOOK);
                arrayList.add(PacketType.Play.Server.REL_ENTITY_MOVE_LOOK);
                arrayList.add(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
                arrayList.add(PacketType.Play.Server.ENTITY_TELEPORT);
                arrayList.add(PacketType.Play.Server.REL_ENTITY_MOVE);
                arrayList.add(PacketType.Play.Server.ENTITY_VELOCITY);
                arrayList.add(PacketType.Play.Server.MOUNT);
            }
            if (DisguiseConfig.isEquipmentPacketsEnabled()) {
                arrayList.add(PacketType.Play.Server.ENTITY_EQUIPMENT);
            }
            if (DisguiseConfig.isAnimationPacketsEnabled()) {
                arrayList.add(PacketType.Play.Server.ANIMATION);
            }
            if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
                arrayList.add(PacketType.Play.Server.ENTITY_STATUS);
            }
            mainListener = new PacketListenerMain(LibsDisguises.getInstance(), arrayList);
            destroyListener = new PacketListenerEntityDestroy((Plugin)LibsDisguises.getInstance());
            ProtocolLibrary.getProtocolManager().addPacketListener(mainListener);
            ProtocolLibrary.getProtocolManager().addPacketListener(destroyListener);
            if (NmsVersion.v1_13.isSupported() && DisguiseConfig.getPlayerNameType() != DisguiseConfig.PlayerNameType.ARMORSTANDS) {
                scoreboardTeamListener = new PacketListenerScoreboardTeam();
                ProtocolLibrary.getProtocolManager().addPacketListener(scoreboardTeamListener);
            }
        }
    }

    public static void setViewDisguisesListener(boolean bl) {
        if (viewDisguisesListenerEnabled != bl) {
            viewDisguisesListenerEnabled = bl;
            if (viewDisguisesListenerEnabled) {
                ProtocolLibrary.getProtocolManager().addPacketListener(viewDisguisesListener);
            } else {
                ProtocolLibrary.getProtocolManager().removePacketListener(viewDisguisesListener);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
                if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
                if (bl) {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                } else {
                    DisguiseUtilities.removeSelfDisguise(disguise);
                }
                if (!inventoryModifierEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
                player.updateInventory();
            }
        }
    }
}

