/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import java.util.ArrayList;
import java.util.Collection;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAnimation;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAttachEntity;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerAttributes;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerCollect;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerEntityStatus;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerEquipment;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerHeadRotation;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerMetadata;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerMovement;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerSpawn;
import me.libraryaddict.disguise.utilities.packets.packethandlers.PacketHandlerVelocity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketsHandler {
    private Collection<IPacketHandler> packetHandlers;

    public PacketsHandler() {
        this.registerPacketHandlers();
    }

    private void registerPacketHandlers() {
        this.packetHandlers = new ArrayList<IPacketHandler>();
        this.packetHandlers.add(new PacketHandlerAnimation());
        this.packetHandlers.add(new PacketHandlerAttributes());
        this.packetHandlers.add(new PacketHandlerCollect());
        this.packetHandlers.add(new PacketHandlerEntityStatus());
        this.packetHandlers.add(new PacketHandlerEquipment(this));
        this.packetHandlers.add(new PacketHandlerAttachEntity());
        this.packetHandlers.add(new PacketHandlerHeadRotation());
        if (!LibsPremium.isPremium().booleanValue() || LibsDisguises.getInstance().getBuildNo().matches("[0-9]+") || LibsPremium.getPaidInformation() != null) {
            this.packetHandlers.add(new PacketHandlerMetadata(this));
        }
        this.packetHandlers.add(new PacketHandlerMovement());
        this.packetHandlers.add(new PacketHandlerSpawn(this));
        this.packetHandlers.add(new PacketHandlerVelocity());
    }

    public LibsPackets transformPacket(PacketContainer packetContainer, Disguise disguise, Player player, Entity entity) {
        LibsPackets libsPackets = new LibsPackets(disguise);
        if (disguise.getType() == DisguiseType.UNKNOWN) {
            return libsPackets;
        }
        try {
            libsPackets.addPacket(packetContainer);
            for (IPacketHandler iPacketHandler : this.packetHandlers) {
                for (PacketType packetType : iPacketHandler.getHandledPackets()) {
                    if (packetType != packetContainer.getType()) continue;
                    iPacketHandler.handle(disguise, packetContainer, libsPackets, player, entity);
                    return libsPackets;
                }
            }
            libsPackets.setUnhandled(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return libsPackets;
    }
}

